<?xml version="1.0"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
xmlns:exsl="http://exslt.org/common"
xmlns:set="http://exslt.org/sets"
version="1.0"
exclude-result-prefixes="doc exsl set">


<xsl:import href="http://docbook.sourceforge.net/release/xsl/current/xhtml/docbook.xsl"/>
<xsl:include href="common.xsl"/>
<xsl:include href="html-common.xsl"/>


<xsl:output encoding="ISO-8859-1"/>

<xsl:template match="section">
  <xsl:variable name="depth" select="count(ancestor::section)+1"/>

  <div xmlns="http://www.w3.org/1999/xhtml" class="{name(.)}_{$depth}">
    <xsl:call-template name="language.attribute"/>
    <xsl:call-template name="section.titlepage"/>

    <xsl:variable name="toc.params">
      <xsl:call-template name="find.path.params">
        <xsl:with-param name="table" select="normalize-space($generate.toc)"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:if test="(contains($toc.params, 'toc') and $depth &lt;= $generate.section.toc.level) or refentry">
      <xsl:call-template name="section.toc">
        <xsl:with-param name="toc.title.p" select="contains($toc.params, 'title')"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:call-template name="process.chunk.footnotes"/>
  </div>
</xsl:template>


</xsl:stylesheet>
