<?xml version="1.0"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
xmlns:exsl="http://exslt.org/common"
xmlns:set="http://exslt.org/sets"
version="1.0"
exclude-result-prefixes="doc exsl set">

<xsl:template match="email">
	<xsl:call-template name="inline.monoseq">
		<xsl:with-param name="content">
			<xsl:text>&lt;</xsl:text>
				<a>
					<xsl:attribute name="href">mailto:<xsl:value-of select="substring-before(.,'@')"/><xsl:text>&lt;AT&gt;</xsl:text><xsl:value-of select="substring-after(.,'@')"/>
					</xsl:attribute>
					<xsl:value-of select="substring-before(.,'@')"/>
					<img src="mailto-link.png" />
					<xsl:value-of select="substring-after(.,'@')"/>
				</a>
			<xsl:text>&gt;</xsl:text>
		</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template name="user.head.content">
	<link rel="SHORTCUT ICON">
		<xsl:attribute name="href">favicon.ico</xsl:attribute>
	</link>
</xsl:template>

<xsl:template match="authorgroup" mode="titlepage.mode">
  <a name="Authorship"></a><p class="authorship-title"><b>Authorship</b></p>
  <div class="{name(.)}">
    <xsl:apply-templates mode="titlepage.mode"/>
  </div>
</xsl:template>

<xsl:template match="editor" mode="titlepage.mode">
  <h3 class="{name(.)}"><xsl:call-template name="person.name"/></h3>
</xsl:template>

<xsl:template match="editor[position()=1]" mode="titlepage.mode">
  <span class="editedby"><xsl:call-template name="gentext.edited.by"/><xsl:call-template name="gentext.space"/><span class="{name(.)}"> <xsl:call-template name="person.name"/></span></span><br/>
</xsl:template>

<xsl:template match="author" mode="titlepage.mode">
  <span class="{name(.)}">
    <xsl:call-template name="person.name"/><xsl:call-template name="gentext.space"/>
    <xsl:apply-templates mode="titlepage.mode" select="./contrib"/><xsl:call-template name="gentext.space"/>
    <xsl:apply-templates mode="titlepage.mode" select="./affiliation"/><xsl:call-template name="gentext.space"/>
    <xsl:apply-templates mode="titlepage.mode" select="./email"/>
  </span><br/>
</xsl:template>

<xsl:template match="copyright" mode="titlepage.mode">
  <a name="Copyright"></a><p class="copyright-title"><b>Copyright</b></p>
  <p class="{name(.)}">
    <xsl:call-template name="gentext">
      <xsl:with-param name="key" select="'Copyright'"/>
    </xsl:call-template>
    <xsl:call-template name="gentext.space"/>
    <xsl:call-template name="dingbat">
      <xsl:with-param name="dingbat">copyright</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="gentext.space"/>
    <xsl:call-template name="copyright.years">
      <xsl:with-param name="years" select="year"/>
      <xsl:with-param name="print.ranges" select="$make.year.ranges"/>
      <xsl:with-param name="single.year.ranges" select="$make.single.year.ranges"/>
    </xsl:call-template>
    <xsl:call-template name="gentext.space"/>
    <xsl:apply-templates select="holder" mode="titlepage.mode"/>
  </p>
</xsl:template>

<!-- Work around some missing stuff in the docbook-xsl templates -->
<xsl:template match="colophon/subtitle"/>
<xsl:template match="colophon/titleabbrev"/>

</xsl:stylesheet>
