#include <iostream>
#include <iomanip>
#include "channelflow/dns.h"
#include "channelflow/flowfield.h"

using namespace std;

int main() {

  // Define gridsize
  const int Nx=24;
  const int Ny=65;
  const int Nz=24;

  // Define box size
  const Real Lx=1.75*pi;
  const Real a= -1.0;
  const Real b=  1.0;
  const Real Lz=1.2*pi;

  // Constructing flow fields
  FlowField u(Nx,Ny,Nz,  3,Lx,Lz,a,b,Physical,Physical);
  FlowField v(Nx,Ny,Nz-1,3,Lx,Lz,a,b,Physical,Physical);

  cout << "Deliberately causing an index-out-of-bounds error..." << endl;
  u(0,Ny+2,0,0) = 0.0;

  cout << "Deliberately causing a field-state error..." << endl;
  u.cmplx(0,0,0,0) = Complex(0.0, 0.0);

  cout << "Deliberately causing a field incompatibility error..." << endl;
  u += v;

}
