load errscaling.asc

e = errscaling;

dt = e(:,1);
u = e(:,2);  % pressure err 
p = e(:,3);  % velocity err 
cpu = e(:,4);

s = dt.^order;   % theoretical O(dt^2) err scaling
%s = dt;
N = length(u);

%[umin, n] = min(u);
n = 1;
s = s * (0.1*u(n)/s(n)); % scale s to be smaller than u

loglog(dt, u, 'b-o', dt, p, 'r-s', dt, cpu/60, 'g-x', dt, s, 'k');
xlabel('dt');
ylabel('normalized L2 err, t=1');
if leg==1 
  legend('velocity','pressure','cpu min', strcat('O(dt^', num2str(order)', ')'), 4)
  legend('boxoff')
end
axis([1e-3 1 1e-12 1e2])