load yp.asc;
load Uplus.asc;

N = length(yp);
N2 = floor(N/2);

yp = yp(N2:N);
Uplus = Uplus(N2:N);

% wall law
ywall = 1e-1: 0.5 : 19;

% core law
ycore = 2:250;

semilogx(yp,Uplus,'k', ywall,ywall, 'b--', ycore, 2.5*log(ycore)+5,'b--');

bigfont;
axis([1e-1 1e3 0 25])

txt(150,19.5,'2.5 ln y_+ + 5')
txt(17,19.5, 'y_+');
txt(16,8.5, 'U_+');

xlbl('y_+')
ylbl('U_+')

print -depsc2 walllaw.eps