"""Module implementing a Postgresql based repository for cfvers"""

# Copyright 2003 Iustin Pop
#
# This file is part of cfvers.
#
# cfvers is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# cfvers is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with cfvers; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import pgdb

import cfvers.repository.sql

class RPostgresql(cfvers.repository.sql.RSql):
    def __init__(self, create=False, cnxargs=None, createopts=None):
        self.conn = pgdb.connect(cnxargs)
        self.backend = 'postgresql'
        self.cnxargs = cnxargs
        if create:
            self._create(createopts=createopts)
        self._check_schema(self.conn.cursor())
        return

    def _init_schema(self, cursor):
        cursor.execute("set client_min_messages to 'warning'")
        super(RPostgresql, self)._init_schema(cursor)
        cursor.execute("CREATE SEQUENCE items_id_seq")
        cursor.execute("ALTER TABLE items ALTER COLUMN id SET DEFAULT nextval('items_id_seq')")
        cursor.execute("ALTER TABLE items ADD constraint items_area_fk FOREIGN KEY (area) REFERENCES areas(name) ON UPDATE CASCADE")
        cursor.execute("ALTER TABLE revisions ADD CONSTRAINT revisions_item_fk FOREIGN KEY (item) REFERENCES items(id)")
        cursor.execute("ALTER TABLE arearevs ADD CONSTRAINT arearevs_area_fk FOREIGN KEY (area) REFERENCES areas(name) ON UPDATE CASCADE")
        return

    def _delete_schema(self, cursor):
        super(RPostgresql, self)._delete_schema(cursor)
        self._try_stm(cursor, "DROP SEQUENCE items_id_seq")
        return
