// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*- 
#ifndef FEDERATION_HH
#define FEDERATION_HH

#include <config.h>
#include <vector>
#include <RTI.hh>
#include "Entity.hh"
#include "ContainerEntity.hh"

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

using namespace std ;

#define NODE_OBJECT_MODEL (const xmlChar*) "objectModel"
#define NODE_OBJECTS (const xmlChar*) "objects"
#define NODE_OBJECT_CLASS (const xmlChar*) "objectClass"
#define NODE_INTERACTIONS (const xmlChar*) "interactions"
#define NODE_INTERACTION_CLASS (const xmlChar*) "interactionClass"
#define NODE_ATTRIBUTE (const xmlChar*) "attribute"
#define NODE_PARAMETER (const xmlChar*) "parameter"
#define NODE_ROUTING_SPACE (const xmlChar*) "routingSpace"
#define NODE_DIMENSIONS (const xmlChar*) "dimensions"
#define NODE_DIMENSION (const xmlChar*) "dimension"

#define ATTRIBUTE_NAME (const xmlChar*) "name"
#define ATTRIBUTE_TRANSPORTATION (const xmlChar*) "transportation"
#define ATTRIBUTE_ORDER (const xmlChar*) "order"
#define ATTRIBUTE_SPACE (const xmlChar*) "space"

#define VALUE_RELIABLE (const xmlChar*) "HLAreliable"
#define VALUE_BESTEFFORT (const xmlChar*) "HLAbestEffort"
#define VALUE_TSO (const xmlChar*) "TimeStamp"
#define VALUE_RO (const xmlChar*) "Receive"

typedef Entity<AttributeHandle> Attr ;
typedef Entity<ParameterHandle> Param ;
typedef ContainerEntity<ObjectClassHandle, Attr> ObjClass ;
typedef ContainerEntity<InteractionClassHandle, Param> IntClass ;

typedef Entity<ObjectHandle> Obj ;

class Federation 
{
public:
    Federation(RTI::RTIambassador*, string);
    ~Federation();  

    void setVerbose(bool);

    void update();
    void connect(Federation&);
    void setId(int);
    void resign(FedTime &);
  
    ObjectClassHandle getObjectClassHandle(string);
    AttributeHandle getAttributeHandle(string);
    InteractionClassHandle getInteractionClassHandle(string);
    ParameterHandle getParameterHandle(string);

    void publishAll(void);
    void subscribeAll(void);

    void discoverObject(ObjectHandle, string);
    void removeObject(ObjectHandle);

    void addObjectTranslation(ObjectHandle, ObjectHandle);
    ObjectHandle getObjectTranslation(int, ObjectHandle);
    ObjectClassHandle getObjectClassTranslation(int, ObjectClassHandle);
    InteractionClassHandle getInteractionClassTranslation(int, InteractionClassHandle);

    bool objectExists(ObjectHandle);

    bool empty(void);

private:
    void updateObjectClasses(vector<ObjClass>&);
    void updateInteractionClasses(vector<IntClass>&);
    void addAttribute(vector<ObjClass>&, string, string);
    void addSubObjectClass(string, string);
    void addSubInteractionClass(string, string);
    void addParameter(string, string);
    ObjectClassHandle searchObjectClassHandle(vector<ObjClass>&, string&);
    InteractionClassHandle searchInteractionClassHandle(vector<ObjClass>&, 
                                                        string&);
    AttributeHandle searchAttributeHandle(vector<ObjClass>&, string&);
    ParameterHandle searchParameterHandle(vector<IntClass>&, string&);

    ObjectClassHandle searchObjectClassTranslation(vector<IntClass>&, int, 
                                                   ObjectClassHandle);

    void connectObjectClasses(vector<ObjClass>&, Federation&);
    void connectInteractionClasses(vector<IntClass>&, Federation&);

    void publishAllObjectClasses(vector<ObjClass>&);
    void publishAllInteractionClasses(vector<IntClass>&);
    void subscribeAllObjectClasses(vector<ObjClass>&);
    void subscribeAllInteractionClasses(vector<IntClass>&);

    void dump(void);

    int parse(string);
    void parseClass(string);
    void parseInteraction(string);

    RTI::RTIambassador* rtiamb ;
    vector<ObjClass> sobj ;
    vector<IntClass> sint ;
    vector<Obj> dobj ;

    int translations ;
    int id ;
    bool verbose ;

    xmlDocPtr doc ;
    xmlNodePtr cur ;
};

#endif // FEDERATION_HH


