// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*- 
// $Id: Federate.hh,v 1.3 2003/03/24 17:54:26 breholee Exp $

#ifndef FEDERATE_HH
#define FEDERATE_HH

#include <config.h>
#include <iostream>
#include <RTI.hh>
#include <fedtime.hh>
#include "Fed.hh"
#include <stdio.h>

#include "Federation.hh"

using std::cout ;
using std::endl ;

#define FEDERATE_JOIN_TRY_MAX 5
#define FEDERATE_ALREADY_JOINED -1
#define FEDERATE_UNABLE_TO_JOIN -2

using namespace std ;

class Fed ;

class Federate
{
    // ========================================================================
public:
    Federate(string, string, string, string, string);
    ~Federate();

    void setSynchro(string);

    RTI::RTIambassador* getRTIAmbassador(void);

    void connect(Federate&);
    Federation& getFederation(void);

    int join(void);
    void init(void);
    int resign(void);
    void synchronize(void);
    void info(void);
  
    ObjectClassHandle getObjectClassHandle(string);
    AttributeHandle getAttributeHandle(string);
    InteractionClassHandle getInteractionClassHandle(string);
    ParameterHandle getParameterHandle(string);

    bool step(void);

    void announce(string);
    void endSynchronization(string);

    void discoverObject(ObjectHandle, ObjectClassHandle, string);
    ObjectHandle registerObject(ObjectClassHandle, string);
    void reflect(ObjectHandle, 
                 const AttributeHandleValuePairSet&, 
                 const FedTime&);
    void update(ObjectHandle, 
                const AttributeHandleValuePairSet&,
                const FedTime&);
    void receive(InteractionClassHandle,
                 const ParameterHandleValuePairSet&,
                 const FedTime&);
    void send(InteractionClassHandle,
              const ParameterHandleValuePairSet&,
              const FedTime&);
    void removeObject(ObjectHandle, const FedTime&);
    void deleteObject(ObjectHandle, const FedTime&);

    void queryLBTS(RTIfedTime &);
    void updateGlobalLBTS(void);

    void setVerbose(bool);
    void setId(int);

    // ========================================================================
private:
    void publishAll(void);
    void subscribeAll(void);
    void setConstrained(bool);
    void setRegulating(bool);  

    RTI::RTIambassador* rtiamb ;
    Fed* fedamb ;
    vector<Federate*> feds ;
    Federation* f ;

    int id ;
    bool joined ;
    bool constrained ;
    bool regulating ;
    bool paused ;
    bool verbose ;
    FederateHandle handle ;

    RTI::RTIfedTime localTime ; // temps du fdr
    RTI::RTIfedTime localLBTS ; // LBTS du fdr
    RTI::RTIfedTime globalLBTS ; // min(LBTS) des autres fdrs
    RTI::RTIfedTime lookahead ; // lookahead du fdr
    RTI::RTIfedTime timeRequest ; // timeStep avancement
    RTI::RTIfedTime minLookahead ; // lookahead min

    string federation ;
    string federate ;
    string fedfile ;
    string synchro ;
    string host ;
    string filter ;
    string certihost ;
};

#endif // FEDERATE_HH

// $Id: Federate.hh,v 1.3 2003/03/24 17:54:26 breholee Exp $
