#!/bin/sh
# myCERTI_env.sh.  Generated from myCERTI_env.sh.in by configure.

export CERTI_VERSION="3.2.5"
echo "CERTI version <$CERTI_VERSION>"

# 1 : shell verification
MYSHELL=`basename $SHELL`
case $MYSHELL in
    sh)   ;;
	bash) ;;
	zsh)  ;;
	ksh)  ;;
	*) 
	 echo "You may not be using a bourne shell, please use myCERTI.csh"
	 exit
	 ;;
esac

# 2 CERTI_HOST (i.e. where rtig runs)

if [ $# -gt 0 ];
then
   export CERTI_HOST=$1
else
   export CERTI_HOST=localhost
fi

# 3 Architecture (i.e 32 or 64 bits)

ARCH=`uname -m`
#if [ "$ARCH" = "i686" ];
#then
#  NBITS="32bits"
#else
# NBITS="64bits"
#fi
echo "Current machine architecture is <$ARCH>".
# assumed to be $NBITS"

# 4 CERTI_HOME (i.e. where we find bin,lib,share,include about CERTI built)
export CERTI_HOME=/LOCAL/ERIC/certi-cvs-autoXX
alias go_certi_home='pushd $CERTI_HOME'

# 5 CERTI_FED (i.e. where we find (default) FED files
export CERTI_FED=$CERTI_HOME/share/federations
alias go_certi_fed='pushd $CERTI_FED'

# 6 PATH (i.e. to run easily rtig and s.o.)
# Not PATH is not modified
# if to be added PATH is already there
MOREPATHBIN=$CERTI_HOME/bin
MODIFPATH=`echo $PATH | grep $MOREPATHBIN`
if [ -z "$MODIFPATH" ];
then
	export PATH=$MOREPATHBIN:$PATH
	echo "Your PATH variable has been modified for bin"
fi
MOREPATHSCRIPTS=$CERTI_HOME/scripts
MODIFPATH=`echo $PATH | grep $MOREPATHSCRIPTS`
if [ -z "$MODIFPATH" ];
then
	export PATH=$MOREPATHSCRIPTS:$PATH
	echo "Your PATH variable has been modified for scripts"
fi

# 7 LD_LIBRARY_PATH ( applications needs...)
# Note LD_LIBRARY_PATH has to be extended sometimes
MOREPATHLIB=$CERTI_HOME/lib
MODIFPATH=`echo $LD_LIBRARY_PATH | grep $MOREPATHLIB`
if [ -z "$MODIFPATH" ];
then
    export LD_LIBRARY_PATH=$MOREPATHLIB:$LD_LIBRARY_PATH
fi

echo "=========================================================="
echo "** WARNING ** We hope you have made source myCERTI.sh **"
echo "                                    ------"
echo "If yes your variables for CERTI are now :"
echo "CERTI_HOST      = " $CERTI_HOST
echo "CERTI_HOME      = " $CERTI_HOME
echo "CERTI_FED       = " $CERTI_FED
echo "PATH            = " $PATH
echo "LD_LIBRARY_PATH = " $LD_LIBRARY_PATH


