
#include <iostream>
#include <sstream>
#include "AllocateMe.hh"
#include "memmgr.h"

int AllocateMe::counter=0;

AllocateMe::AllocateMe() {
	std::cout << "AllocateMe()" <<std::endl;
  _name = std::string("NoName");
  _id    = AllocateMe::counter++;
}

AllocateMe::AllocateMe(const std::string& name) {
	std::cout << "AllocateMe("<< name << ")"<<std::endl;
  _name = name;
  _id    = AllocateMe::counter++;
}

AllocateMe::~AllocateMe() {
	std::cout << "~AllocateMe(), I was named <"<<_name <<"> (i="<<_id<<")"<<std::endl;
}

const std::string AllocateMe::getName() {
 std::stringstream str;
 str << _name << "(id="<<_id<<")";
 return str.str();
}

int AllocateMeOver::counter=0;

AllocateMeOver::AllocateMeOver() {
	std::cout << "AllocateMeOver()" <<std::endl;
  _name = std::string("NoName");
  _id    = AllocateMeOver::counter++;
}

AllocateMeOver::AllocateMeOver(const std::string& name) {
	std::cout << "AllocateMeOver("<< name << ")"<<std::endl;
  _name = name;
  _id    = AllocateMeOver::counter++;
}

AllocateMeOver::~AllocateMeOver() {
	std::cout << "~AllocateMeOver(), I was named <"<<_name <<"> (i="<<_id<<")"<<std::endl;
}

const std::string AllocateMeOver::getName() {
 std::stringstream str;
 str << _name << "(id="<<_id<<")";
 return str.str();
}

/////////////////////////////////////////////////
// Overload global operators
/////////////////////////////////////////////////
void* AllocateMeOver::operator new(size_t s) throw (std::bad_alloc){
	std::cout << "AllocateMeOver operator new("<<s<<")"<<std::endl;
	return memmgr_alloc(s);
}

void AllocateMeOver::operator delete(void * addr) throw (){
	std::cout << "AllocateMeOver operator delete("<<addr<<")"<<std::endl;
	memmgr_free(addr);
}
/////////////////////////////////////////////////
// Overload global operators (array case)
/////////////////////////////////////////////////
void* AllocateMeOver::operator new[] (size_t s) throw (std::bad_alloc){
	std::cout << "AllocateMeOver operator new[] ("<<s<<")"<<std::endl;
	return memmgr_alloc(s);
}


void AllocateMeOver::operator delete[] (void * addr) throw (){
	std::cout << "AllocateMeOver operator delete[]("<<addr<<")"<<std::endl;
	memmgr_free(addr);
}

