#include "gg.h"
/*  ----------------------------------------------------------------------------
 *  CERTI - HLA RunTime Infrastructure
 *  Copyright (C) 2002-2008  ONERA
 * 
 *  This program is free software ; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation ; either version 2 of
 *  the License, or (at your option) Any later version.
 * 
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY ; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program ; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 *  USA
 * 
 *  ----------------------------------------------------------------------------
 *  CERTI Messages description
 *  ----------------------------------------------------------------------------
 *  The messages related classes will be placed in the certi package
 */
/* ---------------------- BEGIN <EventRetraction> ------------------------ */
cer_EventRetraction_t* 
cer_EventRetraction_create(uint32_t nb) {
   cer_EventRetraction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_EventRetraction_t));
   assert(newObj!=NULL);
   cer_FederateHandle_t sendingFederate=0;
   uint64_t SN=0;
   return newObj;
}

void cer_EventRetraction_destroy(cer_EventRetraction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void EventRetraction_serialize(MsgBuffer_t* msgBuffer) {
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,sendingFederate);
   MB_write_uint64(msgBuffer,SN);
}

void EventRetraction_deserialize(MsgBuffer_t* msgBuffer) {
   /* Specific deserialization code    */
   sendingFederate = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
   SN = MB_read_uint64(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_EventRetraction_getSendingFederate(cer_EventRetraction_t* cthis)  {return cthis->sendingFederate;}
void cer_EventRetraction_setSendingFederate(cer_EventRetraction_t* cthis,  cer_FederateHandle_t newSendingFederate) {cthis->sendingFederate=newSendingFederate;}
uint64_t cer_EventRetraction_getSN(cer_EventRetraction_t* cthis)  {return cthis->SN;}
void cer_EventRetraction_setSN(cer_EventRetraction_t* cthis,  uint64_t newSN) {cthis->SN=newSN;}
FILE* EventRetraction_show(FILE* out) {
   fprintf(out,"[EventRetraction -Begin] \n");
   /* Specific show code    */
   fprintf(out," sendingFederate = " + sendingFederate + " "     + "\n");
   fprintf(out," SN = " + SN + " "     + "\n");
   fprintf(out,"[EventRetraction -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <EventRetraction> ------------------------ */

/* ---------------------- BEGIN <M_Open_Connexion> ------------------------ */
cer_M_Open_Connexion_t* 
cer_M_Open_Connexion_create(uint32_t nb) {
   cer_M_Open_Connexion_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Open_Connexion_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Open_Connexion; 
   cthis->super->type = M_OPEN_CONNEXION;
   /* versionMajor= <no default value in message spec using builtin>    */
   /* versionMinor= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Open_Connexion_destroy(cer_M_Open_Connexion_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Open_Connexion_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,versionMajor);
   MB_write_uint32(msgBuffer,versionMinor);
}

void M_Open_Connexion_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   versionMajor = MB_read_uint32(msgBuffer);
   versionMinor = MB_read_uint32(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
uint32_t cer_M_Open_Connexion_getVersionMajor(cer_M_Open_Connexion_t* cthis)  {return cthis->versionMajor;}
void cer_M_Open_Connexion_setVersionMajor(cer_M_Open_Connexion_t* cthis,  uint32_t newVersionMajor) {cthis->versionMajor=newVersionMajor;}
uint32_t cer_M_Open_Connexion_getVersionMinor(cer_M_Open_Connexion_t* cthis)  {return cthis->versionMinor;}
void cer_M_Open_Connexion_setVersionMinor(cer_M_Open_Connexion_t* cthis,  uint32_t newVersionMinor) {cthis->versionMinor=newVersionMinor;}
FILE* M_Open_Connexion_show(FILE* out) {
   fprintf(out,"[M_Open_Connexion -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," versionMajor = " + versionMajor + " "     + "\n");
   fprintf(out," versionMinor = " + versionMinor + " "     + "\n");
   fprintf(out,"[M_Open_Connexion -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Open_Connexion> ------------------------ */

/* ---------------------- BEGIN <M_Close_Connexion> ------------------------ */
cer_M_Close_Connexion_t* 
cer_M_Close_Connexion_create(uint32_t nb) {
   cer_M_Close_Connexion_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Close_Connexion_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Close_Connexion; 
   cthis->super->type = M_CLOSE_CONNEXION;
   return newObj;
}

void cer_M_Close_Connexion_destroy(cer_M_Close_Connexion_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Create_Federation_Execution> ------------------------ */
cer_M_Create_Federation_Execution_t* 
cer_M_Create_Federation_Execution_create(uint32_t nb) {
   cer_M_Create_Federation_Execution_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Create_Federation_Execution_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Create_Federation_Execution; 
   cthis->super->type = M_CREATE_FEDERATION_EXECUTION;
   /* federationName= <no default value in message spec using builtin>    */
   /* FEDid= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Create_Federation_Execution_destroy(cer_M_Create_Federation_Execution_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Create_Federation_Execution_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,federationName);
   MB_write_string(msgBuffer,FEDid);
}

void M_Create_Federation_Execution_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   federationName = MB_read_string(msgBuffer);
   FEDid = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Create_Federation_Execution_getFederationName(cer_M_Create_Federation_Execution_t* cthis)  {return cthis->federationName;}
void cer_M_Create_Federation_Execution_setFederationName(cer_M_Create_Federation_Execution_t* cthis,  char* newFederationName) {cthis->federationName=newFederationName;}
char* cer_M_Create_Federation_Execution_getFEDid(cer_M_Create_Federation_Execution_t* cthis)  {return cthis->FEDid;}
void cer_M_Create_Federation_Execution_setFEDid(cer_M_Create_Federation_Execution_t* cthis,  char* newFEDid) {cthis->FEDid=newFEDid;}
FILE* M_Create_Federation_Execution_show(FILE* out) {
   fprintf(out,"[M_Create_Federation_Execution -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," federationName = " + federationName + " "     + "\n");
   fprintf(out," FEDid = " + FEDid + " "     + "\n");
   fprintf(out,"[M_Create_Federation_Execution -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Create_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Destroy_Federation_Execution> ------------------------ */
cer_M_Destroy_Federation_Execution_t* 
cer_M_Destroy_Federation_Execution_create(uint32_t nb) {
   cer_M_Destroy_Federation_Execution_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Destroy_Federation_Execution_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Destroy_Federation_Execution; 
   cthis->super->type = M_DESTROY_FEDERATION_EXECUTION;
   /* federationName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Destroy_Federation_Execution_destroy(cer_M_Destroy_Federation_Execution_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Destroy_Federation_Execution_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,federationName);
}

void M_Destroy_Federation_Execution_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   federationName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Destroy_Federation_Execution_getFederationName(cer_M_Destroy_Federation_Execution_t* cthis)  {return cthis->federationName;}
void cer_M_Destroy_Federation_Execution_setFederationName(cer_M_Destroy_Federation_Execution_t* cthis,  char* newFederationName) {cthis->federationName=newFederationName;}
FILE* M_Destroy_Federation_Execution_show(FILE* out) {
   fprintf(out,"[M_Destroy_Federation_Execution -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," federationName = " + federationName + " "     + "\n");
   fprintf(out,"[M_Destroy_Federation_Execution -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Destroy_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Join_Federation_Execution> ------------------------ */
cer_M_Join_Federation_Execution_t* 
cer_M_Join_Federation_Execution_create(uint32_t nb) {
   cer_M_Join_Federation_Execution_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Join_Federation_Execution_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Join_Federation_Execution; 
   cthis->super->type = M_JOIN_FEDERATION_EXECUTION;
   /* federate= <no default value in message spec using builtin>    */
   /* federationName= <no default value in message spec using builtin>    */
   /* federateName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Join_Federation_Execution_destroy(cer_M_Join_Federation_Execution_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Join_Federation_Execution_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,federate);
   MB_write_string(msgBuffer,federationName);
   MB_write_string(msgBuffer,federateName);
}

void M_Join_Federation_Execution_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   federate = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
   federationName = MB_read_string(msgBuffer);
   federateName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_M_Join_Federation_Execution_getFederate(cer_M_Join_Federation_Execution_t* cthis)  {return cthis->federate;}
void cer_M_Join_Federation_Execution_setFederate(cer_M_Join_Federation_Execution_t* cthis,  cer_FederateHandle_t newFederate) {cthis->federate=newFederate;}
char* cer_M_Join_Federation_Execution_getFederationName(cer_M_Join_Federation_Execution_t* cthis)  {return cthis->federationName;}
void cer_M_Join_Federation_Execution_setFederationName(cer_M_Join_Federation_Execution_t* cthis,  char* newFederationName) {cthis->federationName=newFederationName;}
char* cer_M_Join_Federation_Execution_getFederateName(cer_M_Join_Federation_Execution_t* cthis)  {return cthis->federateName;}
void cer_M_Join_Federation_Execution_setFederateName(cer_M_Join_Federation_Execution_t* cthis,  char* newFederateName) {cthis->federateName=newFederateName;}
FILE* M_Join_Federation_Execution_show(FILE* out) {
   fprintf(out,"[M_Join_Federation_Execution -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," federate = " + federate + " "     + "\n");
   fprintf(out," federationName = " + federationName + " "     + "\n");
   fprintf(out," federateName = " + federateName + " "     + "\n");
   fprintf(out,"[M_Join_Federation_Execution -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Join_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Resign_Federation_Execution> ------------------------ */
cer_M_Resign_Federation_Execution_t* 
cer_M_Resign_Federation_Execution_create(uint32_t nb) {
   cer_M_Resign_Federation_Execution_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Resign_Federation_Execution_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Resign_Federation_Execution; 
   cthis->super->type = M_RESIGN_FEDERATION_EXECUTION;
   /* resignAction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Resign_Federation_Execution_destroy(cer_M_Resign_Federation_Execution_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Resign_Federation_Execution_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint16(msgBuffer,resignAction);
}

void M_Resign_Federation_Execution_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   resignAction = static_cast<ResignAction>(MB_read_uint16(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ResignAction_t cer_M_Resign_Federation_Execution_getResignAction(cer_M_Resign_Federation_Execution_t* cthis)  {return cthis->resignAction;}
void cer_M_Resign_Federation_Execution_setResignAction(cer_M_Resign_Federation_Execution_t* cthis,  cer_ResignAction_t newResignAction) {cthis->resignAction=newResignAction;}
FILE* M_Resign_Federation_Execution_show(FILE* out) {
   fprintf(out,"[M_Resign_Federation_Execution -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," resignAction = " + resignAction + " "     + "\n");
   fprintf(out,"[M_Resign_Federation_Execution -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Resign_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Register_Federation_Synchronization_Point> ------------------------ */
cer_M_Register_Federation_Synchronization_Point_t* 
cer_M_Register_Federation_Synchronization_Point_create(uint32_t nb) {
   cer_M_Register_Federation_Synchronization_Point_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Register_Federation_Synchronization_Point_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Register_Federation_Synchronization_Point; 
   cthis->super->type = M_REGISTER_FEDERATION_SYNCHRONIZATION_POINT;
   /* federateSet= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Register_Federation_Synchronization_Point_destroy(cer_M_Register_Federation_Synchronization_Point_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Register_Federation_Synchronization_Point_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   uint32_t federateSetSize = federateSetsize;
   MB_write_uint32(msgBuffer,federateSetSize);
   for (uint32_t i = 0; i < federateSetSize; ++i) {
      MB_write_uint32(msgBuffer,federateSet[i]);
   }
}

void M_Register_Federation_Synchronization_Point_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   uint32_t federateSetSize = MB_read_uint32(msgBuffer);
   federateSetsize =federateSetSize);
   for (uint32_t i = 0; i < federateSetSize; ++i) {
      federateSet[i] = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
uint32_t cer_M_Register_Federation_Synchronization_Point_getFederateSetSize(cer_M_Register_Federation_Synchronization_Point_t* cthis){ return cthis->federateSetsize;}
void cer_M_Register_Federation_Synchronization_Point_setFederateSetSize(cer_M_Register_Federation_Synchronization_Point_t* cthis, uint32_t num) { 
   FederateHandle* temp;
   temp = calloc(num,sizeof(FederateHandle));
   memcpy(temp,cthis->federateSet, cthis->federateSetsize);
   free(cthis->federateSet);
   cthis->federateSet = temp;
   cthis->federateSetsize = num;
}
cer_FederateHandle_t cer_M_Register_Federation_Synchronization_Point_getFederateSet(cer_M_Register_Federation_Synchronization_Point_t* cthis, uint32_t rank) {return cthis->federateSet[rank];}
void cer_M_Register_Federation_Synchronization_Point_setFederateSet(cer_M_Register_Federation_Synchronization_Point_t* cthis, cer_FederateHandle_t newFederateSet, uint32_t rank) {cthis->federateSet[rank]=newFederateSet;}
FILE* M_Register_Federation_Synchronization_Point_show(FILE* out) {
   fprintf(out,"[M_Register_Federation_Synchronization_Point -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out,"    federateSet [] = 
");
   for (uint32_t i = 0; i < getFederateSetSize(); ++i) {
      out + federateSet[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Register_Federation_Synchronization_Point -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Register_Federation_Synchronization_Point> ------------------------ */

/* ---------------------- BEGIN <M_Synchronization_Point_Registration_Failed> ------------------------ */
cer_M_Synchronization_Point_Registration_Failed_t* 
cer_M_Synchronization_Point_Registration_Failed_create(uint32_t nb) {
   cer_M_Synchronization_Point_Registration_Failed_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Synchronization_Point_Registration_Failed_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Synchronization_Point_Registration_Failed; 
   cthis->super->type = M_SYNCHRONIZATION_POINT_REGISTRATION_FAILED;
   return newObj;
}

void cer_M_Synchronization_Point_Registration_Failed_destroy(cer_M_Synchronization_Point_Registration_Failed_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Synchronization_Point_Registration_Succeeded> ------------------------ */
cer_M_Synchronization_Point_Registration_Succeeded_t* 
cer_M_Synchronization_Point_Registration_Succeeded_create(uint32_t nb) {
   cer_M_Synchronization_Point_Registration_Succeeded_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Synchronization_Point_Registration_Succeeded_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Synchronization_Point_Registration_Succeeded; 
   cthis->super->type = M_SYNCHRONIZATION_POINT_REGISTRATION_SUCCEEDED;
   return newObj;
}

void cer_M_Synchronization_Point_Registration_Succeeded_destroy(cer_M_Synchronization_Point_Registration_Succeeded_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Announce_Synchronization_Point> ------------------------ */
cer_M_Announce_Synchronization_Point_t* 
cer_M_Announce_Synchronization_Point_create(uint32_t nb) {
   cer_M_Announce_Synchronization_Point_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Announce_Synchronization_Point_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Announce_Synchronization_Point; 
   cthis->super->type = M_ANNOUNCE_SYNCHRONIZATION_POINT;
   return newObj;
}

void cer_M_Announce_Synchronization_Point_destroy(cer_M_Announce_Synchronization_Point_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Synchronization_Point_Achieved> ------------------------ */
cer_M_Synchronization_Point_Achieved_t* 
cer_M_Synchronization_Point_Achieved_create(uint32_t nb) {
   cer_M_Synchronization_Point_Achieved_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Synchronization_Point_Achieved_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Synchronization_Point_Achieved; 
   cthis->super->type = M_SYNCHRONIZATION_POINT_ACHIEVED;
   return newObj;
}

void cer_M_Synchronization_Point_Achieved_destroy(cer_M_Synchronization_Point_Achieved_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Synchronized> ------------------------ */
cer_M_Federation_Synchronized_t* 
cer_M_Federation_Synchronized_create(uint32_t nb) {
   cer_M_Federation_Synchronized_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Synchronized_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Synchronized; 
   cthis->super->type = M_FEDERATION_SYNCHRONIZED;
   return newObj;
}

void cer_M_Federation_Synchronized_destroy(cer_M_Federation_Synchronized_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Request_Federation_Save> ------------------------ */
cer_M_Request_Federation_Save_t* 
cer_M_Request_Federation_Save_create(uint32_t nb) {
   cer_M_Request_Federation_Save_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Federation_Save_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Federation_Save; 
   cthis->super->type = M_REQUEST_FEDERATION_SAVE;
   return newObj;
}

void cer_M_Request_Federation_Save_destroy(cer_M_Request_Federation_Save_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Initiate_Federate_Save> ------------------------ */
cer_M_Initiate_Federate_Save_t* 
cer_M_Initiate_Federate_Save_create(uint32_t nb) {
   cer_M_Initiate_Federate_Save_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Initiate_Federate_Save_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Initiate_Federate_Save; 
   cthis->super->type = M_INITIATE_FEDERATE_SAVE;
   return newObj;
}

void cer_M_Initiate_Federate_Save_destroy(cer_M_Initiate_Federate_Save_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federate_Save_Begun> ------------------------ */
cer_M_Federate_Save_Begun_t* 
cer_M_Federate_Save_Begun_create(uint32_t nb) {
   cer_M_Federate_Save_Begun_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federate_Save_Begun_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federate_Save_Begun; 
   cthis->super->type = M_FEDERATE_SAVE_BEGUN;
   return newObj;
}

void cer_M_Federate_Save_Begun_destroy(cer_M_Federate_Save_Begun_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federate_Save_Complete> ------------------------ */
cer_M_Federate_Save_Complete_t* 
cer_M_Federate_Save_Complete_create(uint32_t nb) {
   cer_M_Federate_Save_Complete_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federate_Save_Complete_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federate_Save_Complete; 
   cthis->super->type = M_FEDERATE_SAVE_COMPLETE;
   return newObj;
}

void cer_M_Federate_Save_Complete_destroy(cer_M_Federate_Save_Complete_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federate_Save_Not_Complete> ------------------------ */
cer_M_Federate_Save_Not_Complete_t* 
cer_M_Federate_Save_Not_Complete_create(uint32_t nb) {
   cer_M_Federate_Save_Not_Complete_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federate_Save_Not_Complete_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federate_Save_Not_Complete; 
   cthis->super->type = M_FEDERATE_SAVE_NOT_COMPLETE;
   return newObj;
}

void cer_M_Federate_Save_Not_Complete_destroy(cer_M_Federate_Save_Not_Complete_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Saved> ------------------------ */
cer_M_Federation_Saved_t* 
cer_M_Federation_Saved_create(uint32_t nb) {
   cer_M_Federation_Saved_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Saved_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Saved; 
   cthis->super->type = M_FEDERATION_SAVED;
   return newObj;
}

void cer_M_Federation_Saved_destroy(cer_M_Federation_Saved_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Not_Saved> ------------------------ */
cer_M_Federation_Not_Saved_t* 
cer_M_Federation_Not_Saved_create(uint32_t nb) {
   cer_M_Federation_Not_Saved_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Not_Saved_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Not_Saved; 
   cthis->super->type = M_FEDERATION_NOT_SAVED;
   return newObj;
}

void cer_M_Federation_Not_Saved_destroy(cer_M_Federation_Not_Saved_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Request_Federation_Restore> ------------------------ */
cer_M_Request_Federation_Restore_t* 
cer_M_Request_Federation_Restore_create(uint32_t nb) {
   cer_M_Request_Federation_Restore_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Federation_Restore_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Federation_Restore; 
   cthis->super->type = M_REQUEST_FEDERATION_RESTORE;
   return newObj;
}

void cer_M_Request_Federation_Restore_destroy(cer_M_Request_Federation_Restore_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Request_Federation_Restore_Failed> ------------------------ */
cer_M_Request_Federation_Restore_Failed_t* 
cer_M_Request_Federation_Restore_Failed_create(uint32_t nb) {
   cer_M_Request_Federation_Restore_Failed_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Federation_Restore_Failed_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Federation_Restore_Failed; 
   cthis->super->type = M_REQUEST_FEDERATION_RESTORE_FAILED;
   /* reason= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Federation_Restore_Failed_destroy(cer_M_Request_Federation_Restore_Failed_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Federation_Restore_Failed_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,reason);
}

void M_Request_Federation_Restore_Failed_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   reason = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Request_Federation_Restore_Failed_getReason(cer_M_Request_Federation_Restore_Failed_t* cthis)  {return cthis->reason;}
void cer_M_Request_Federation_Restore_Failed_setReason(cer_M_Request_Federation_Restore_Failed_t* cthis,  char* newReason) {cthis->reason=newReason;}
FILE* M_Request_Federation_Restore_Failed_show(FILE* out) {
   fprintf(out,"[M_Request_Federation_Restore_Failed -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," reason = " + reason + " "     + "\n");
   fprintf(out,"[M_Request_Federation_Restore_Failed -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Federation_Restore_Failed> ------------------------ */

/* ---------------------- BEGIN <M_Request_Federation_Restore_Succeeded> ------------------------ */
cer_M_Request_Federation_Restore_Succeeded_t* 
cer_M_Request_Federation_Restore_Succeeded_create(uint32_t nb) {
   cer_M_Request_Federation_Restore_Succeeded_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Federation_Restore_Succeeded_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Federation_Restore_Succeeded; 
   cthis->super->type = M_REQUEST_FEDERATION_RESTORE_SUCCEEDED;
   return newObj;
}

void cer_M_Request_Federation_Restore_Succeeded_destroy(cer_M_Request_Federation_Restore_Succeeded_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Initiate_Federate_Restore> ------------------------ */
cer_M_Initiate_Federate_Restore_t* 
cer_M_Initiate_Federate_Restore_create(uint32_t nb) {
   cer_M_Initiate_Federate_Restore_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Initiate_Federate_Restore_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Initiate_Federate_Restore; 
   cthis->super->type = M_INITIATE_FEDERATE_RESTORE;
   /* federate= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Initiate_Federate_Restore_destroy(cer_M_Initiate_Federate_Restore_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Initiate_Federate_Restore_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,federate);
}

void M_Initiate_Federate_Restore_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   federate = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_M_Initiate_Federate_Restore_getFederate(cer_M_Initiate_Federate_Restore_t* cthis)  {return cthis->federate;}
void cer_M_Initiate_Federate_Restore_setFederate(cer_M_Initiate_Federate_Restore_t* cthis,  cer_FederateHandle_t newFederate) {cthis->federate=newFederate;}
FILE* M_Initiate_Federate_Restore_show(FILE* out) {
   fprintf(out,"[M_Initiate_Federate_Restore -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," federate = " + federate + " "     + "\n");
   fprintf(out,"[M_Initiate_Federate_Restore -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Initiate_Federate_Restore> ------------------------ */

/* ---------------------- BEGIN <M_Federate_Restore_Complete> ------------------------ */
cer_M_Federate_Restore_Complete_t* 
cer_M_Federate_Restore_Complete_create(uint32_t nb) {
   cer_M_Federate_Restore_Complete_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federate_Restore_Complete_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federate_Restore_Complete; 
   cthis->super->type = M_FEDERATE_RESTORE_COMPLETE;
   return newObj;
}

void cer_M_Federate_Restore_Complete_destroy(cer_M_Federate_Restore_Complete_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federate_Restore_Not_Complete> ------------------------ */
cer_M_Federate_Restore_Not_Complete_t* 
cer_M_Federate_Restore_Not_Complete_create(uint32_t nb) {
   cer_M_Federate_Restore_Not_Complete_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federate_Restore_Not_Complete_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federate_Restore_Not_Complete; 
   cthis->super->type = M_FEDERATE_RESTORE_NOT_COMPLETE;
   return newObj;
}

void cer_M_Federate_Restore_Not_Complete_destroy(cer_M_Federate_Restore_Not_Complete_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Restored> ------------------------ */
cer_M_Federation_Restored_t* 
cer_M_Federation_Restored_create(uint32_t nb) {
   cer_M_Federation_Restored_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Restored_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Restored; 
   cthis->super->type = M_FEDERATION_RESTORED;
   return newObj;
}

void cer_M_Federation_Restored_destroy(cer_M_Federation_Restored_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Not_Restored> ------------------------ */
cer_M_Federation_Not_Restored_t* 
cer_M_Federation_Not_Restored_create(uint32_t nb) {
   cer_M_Federation_Not_Restored_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Not_Restored_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Not_Restored; 
   cthis->super->type = M_FEDERATION_NOT_RESTORED;
   return newObj;
}

void cer_M_Federation_Not_Restored_destroy(cer_M_Federation_Not_Restored_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Federation_Restore_Begun> ------------------------ */
cer_M_Federation_Restore_Begun_t* 
cer_M_Federation_Restore_Begun_create(uint32_t nb) {
   cer_M_Federation_Restore_Begun_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Federation_Restore_Begun_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Federation_Restore_Begun; 
   cthis->super->type = M_FEDERATION_RESTORE_BEGUN;
   return newObj;
}

void cer_M_Federation_Restore_Begun_destroy(cer_M_Federation_Restore_Begun_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Publish_Object_Class> ------------------------ */
cer_M_Publish_Object_Class_t* 
cer_M_Publish_Object_Class_create(uint32_t nb) {
   cer_M_Publish_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Publish_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Publish_Object_Class; 
   cthis->super->type = M_PUBLISH_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Publish_Object_Class_destroy(cer_M_Publish_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Publish_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Publish_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Publish_Object_Class_getObjectClass(cer_M_Publish_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Publish_Object_Class_setObjectClass(cer_M_Publish_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
uint32_t cer_M_Publish_Object_Class_getAttributesSize(cer_M_Publish_Object_Class_t* cthis){ return cthis->attributessize;}
void cer_M_Publish_Object_Class_setAttributesSize(cer_M_Publish_Object_Class_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Publish_Object_Class_getAttributes(cer_M_Publish_Object_Class_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Publish_Object_Class_setAttributes(cer_M_Publish_Object_Class_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Publish_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Publish_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Publish_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Publish_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unpublish_Object_Class> ------------------------ */
cer_M_Unpublish_Object_Class_t* 
cer_M_Unpublish_Object_Class_create(uint32_t nb) {
   cer_M_Unpublish_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Unpublish_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Unpublish_Object_Class; 
   cthis->super->type = M_UNPUBLISH_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Unpublish_Object_Class_destroy(cer_M_Unpublish_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Unpublish_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
}

void M_Unpublish_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Unpublish_Object_Class_getObjectClass(cer_M_Unpublish_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Unpublish_Object_Class_setObjectClass(cer_M_Unpublish_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
FILE* M_Unpublish_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Unpublish_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"[M_Unpublish_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Unpublish_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Publish_Interaction_Class> ------------------------ */
cer_M_Publish_Interaction_Class_t* 
cer_M_Publish_Interaction_Class_create(uint32_t nb) {
   cer_M_Publish_Interaction_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Publish_Interaction_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Publish_Interaction_Class; 
   cthis->super->type = M_PUBLISH_INTERACTION_CLASS;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Publish_Interaction_Class_destroy(cer_M_Publish_Interaction_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Publish_Interaction_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Publish_Interaction_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Publish_Interaction_Class_getInteractionClass(cer_M_Publish_Interaction_Class_t* cthis)  {return cthis->interactionClass;}
void cer_M_Publish_Interaction_Class_setInteractionClass(cer_M_Publish_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Publish_Interaction_Class_show(FILE* out) {
   fprintf(out,"[M_Publish_Interaction_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Publish_Interaction_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Publish_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unpublish_Interaction_Class> ------------------------ */
cer_M_Unpublish_Interaction_Class_t* 
cer_M_Unpublish_Interaction_Class_create(uint32_t nb) {
   cer_M_Unpublish_Interaction_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Unpublish_Interaction_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Unpublish_Interaction_Class; 
   cthis->super->type = M_UNPUBLISH_INTERACTION_CLASS;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Unpublish_Interaction_Class_destroy(cer_M_Unpublish_Interaction_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Unpublish_Interaction_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Unpublish_Interaction_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Unpublish_Interaction_Class_getInteractionClass(cer_M_Unpublish_Interaction_Class_t* cthis)  {return cthis->interactionClass;}
void cer_M_Unpublish_Interaction_Class_setInteractionClass(cer_M_Unpublish_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Unpublish_Interaction_Class_show(FILE* out) {
   fprintf(out,"[M_Unpublish_Interaction_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Unpublish_Interaction_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Unpublish_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Subscribe_Object_Class_Attributes> ------------------------ */
cer_M_Subscribe_Object_Class_Attributes_t* 
cer_M_Subscribe_Object_Class_Attributes_create(uint32_t nb) {
   cer_M_Subscribe_Object_Class_Attributes_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Subscribe_Object_Class_Attributes_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Subscribe_Object_Class_Attributes; 
   cthis->super->type = M_SUBSCRIBE_OBJECT_CLASS_ATTRIBUTES;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   uint8_t active=true;
   return newObj;
}

void cer_M_Subscribe_Object_Class_Attributes_destroy(cer_M_Subscribe_Object_Class_Attributes_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Subscribe_Object_Class_Attributes_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
   MB_write_bool(msgBuffer,active);
}

void M_Subscribe_Object_Class_Attributes_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
   active = MB_read_bool(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Subscribe_Object_Class_Attributes_getObjectClass(cer_M_Subscribe_Object_Class_Attributes_t* cthis)  {return cthis->objectClass;}
void cer_M_Subscribe_Object_Class_Attributes_setObjectClass(cer_M_Subscribe_Object_Class_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
uint32_t cer_M_Subscribe_Object_Class_Attributes_getAttributesSize(cer_M_Subscribe_Object_Class_Attributes_t* cthis){ return cthis->attributessize;}
void cer_M_Subscribe_Object_Class_Attributes_setAttributesSize(cer_M_Subscribe_Object_Class_Attributes_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Subscribe_Object_Class_Attributes_getAttributes(cer_M_Subscribe_Object_Class_Attributes_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Subscribe_Object_Class_Attributes_setAttributes(cer_M_Subscribe_Object_Class_Attributes_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
uint8_t cer_M_Subscribe_Object_Class_Attributes_getActive(cer_M_Subscribe_Object_Class_Attributes_t* cthis)  {return cthis->active;}
void cer_M_Subscribe_Object_Class_Attributes_setActive(cer_M_Subscribe_Object_Class_Attributes_t* cthis,  uint8_t newActive) {cthis->active=newActive;}
FILE* M_Subscribe_Object_Class_Attributes_show(FILE* out) {
   fprintf(out,"[M_Subscribe_Object_Class_Attributes -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out," active = " + active + " "     + "\n");
   fprintf(out,"[M_Subscribe_Object_Class_Attributes -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Subscribe_Object_Class_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Unsubscribe_Object_Class> ------------------------ */
cer_M_Unsubscribe_Object_Class_t* 
cer_M_Unsubscribe_Object_Class_create(uint32_t nb) {
   cer_M_Unsubscribe_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Unsubscribe_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Unsubscribe_Object_Class; 
   cthis->super->type = M_UNSUBSCRIBE_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Unsubscribe_Object_Class_destroy(cer_M_Unsubscribe_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Unsubscribe_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
}

void M_Unsubscribe_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Unsubscribe_Object_Class_getObjectClass(cer_M_Unsubscribe_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Unsubscribe_Object_Class_setObjectClass(cer_M_Unsubscribe_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
FILE* M_Unsubscribe_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Unsubscribe_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"[M_Unsubscribe_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Unsubscribe_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Subscribe_Interaction_Class> ------------------------ */
cer_M_Subscribe_Interaction_Class_t* 
cer_M_Subscribe_Interaction_Class_create(uint32_t nb) {
   cer_M_Subscribe_Interaction_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Subscribe_Interaction_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Subscribe_Interaction_Class; 
   cthis->super->type = M_SUBSCRIBE_INTERACTION_CLASS;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Subscribe_Interaction_Class_destroy(cer_M_Subscribe_Interaction_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Subscribe_Interaction_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Subscribe_Interaction_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Subscribe_Interaction_Class_getInteractionClass(cer_M_Subscribe_Interaction_Class_t* cthis)  {return cthis->interactionClass;}
void cer_M_Subscribe_Interaction_Class_setInteractionClass(cer_M_Subscribe_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Subscribe_Interaction_Class_show(FILE* out) {
   fprintf(out,"[M_Subscribe_Interaction_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Subscribe_Interaction_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Subscribe_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unsubscribe_Interaction_Class> ------------------------ */
cer_M_Unsubscribe_Interaction_Class_t* 
cer_M_Unsubscribe_Interaction_Class_create(uint32_t nb) {
   cer_M_Unsubscribe_Interaction_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Unsubscribe_Interaction_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Unsubscribe_Interaction_Class; 
   cthis->super->type = M_UNSUBSCRIBE_INTERACTION_CLASS;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Unsubscribe_Interaction_Class_destroy(cer_M_Unsubscribe_Interaction_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Unsubscribe_Interaction_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Unsubscribe_Interaction_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Unsubscribe_Interaction_Class_getInteractionClass(cer_M_Unsubscribe_Interaction_Class_t* cthis)  {return cthis->interactionClass;}
void cer_M_Unsubscribe_Interaction_Class_setInteractionClass(cer_M_Unsubscribe_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Unsubscribe_Interaction_Class_show(FILE* out) {
   fprintf(out,"[M_Unsubscribe_Interaction_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Unsubscribe_Interaction_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Unsubscribe_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Start_Registration_For_Object_Class> ------------------------ */
cer_M_Start_Registration_For_Object_Class_t* 
cer_M_Start_Registration_For_Object_Class_create(uint32_t nb) {
   cer_M_Start_Registration_For_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Start_Registration_For_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Start_Registration_For_Object_Class; 
   cthis->super->type = M_START_REGISTRATION_FOR_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Start_Registration_For_Object_Class_destroy(cer_M_Start_Registration_For_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Start_Registration_For_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
}

void M_Start_Registration_For_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Start_Registration_For_Object_Class_getObjectClass(cer_M_Start_Registration_For_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Start_Registration_For_Object_Class_setObjectClass(cer_M_Start_Registration_For_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
FILE* M_Start_Registration_For_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Start_Registration_For_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"[M_Start_Registration_For_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Start_Registration_For_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Stop_Registration_For_Object_Class> ------------------------ */
cer_M_Stop_Registration_For_Object_Class_t* 
cer_M_Stop_Registration_For_Object_Class_create(uint32_t nb) {
   cer_M_Stop_Registration_For_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Stop_Registration_For_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Stop_Registration_For_Object_Class; 
   cthis->super->type = M_STOP_REGISTRATION_FOR_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Stop_Registration_For_Object_Class_destroy(cer_M_Stop_Registration_For_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Stop_Registration_For_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
}

void M_Stop_Registration_For_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Stop_Registration_For_Object_Class_getObjectClass(cer_M_Stop_Registration_For_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Stop_Registration_For_Object_Class_setObjectClass(cer_M_Stop_Registration_For_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
FILE* M_Stop_Registration_For_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Stop_Registration_For_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"[M_Stop_Registration_For_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Stop_Registration_For_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Interactions_On> ------------------------ */
cer_M_Turn_Interactions_On_t* 
cer_M_Turn_Interactions_On_create(uint32_t nb) {
   cer_M_Turn_Interactions_On_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Turn_Interactions_On_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Turn_Interactions_On; 
   cthis->super->type = M_TURN_INTERACTIONS_ON;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Turn_Interactions_On_destroy(cer_M_Turn_Interactions_On_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Turn_Interactions_On_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Turn_Interactions_On_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Turn_Interactions_On_getInteractionClass(cer_M_Turn_Interactions_On_t* cthis)  {return cthis->interactionClass;}
void cer_M_Turn_Interactions_On_setInteractionClass(cer_M_Turn_Interactions_On_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Turn_Interactions_On_show(FILE* out) {
   fprintf(out,"[M_Turn_Interactions_On -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Turn_Interactions_On -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Turn_Interactions_On> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Interactions_Off> ------------------------ */
cer_M_Turn_Interactions_Off_t* 
cer_M_Turn_Interactions_Off_create(uint32_t nb) {
   cer_M_Turn_Interactions_Off_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Turn_Interactions_Off_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Turn_Interactions_Off; 
   cthis->super->type = M_TURN_INTERACTIONS_OFF;
   /* interactionClass= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Turn_Interactions_Off_destroy(cer_M_Turn_Interactions_Off_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Turn_Interactions_Off_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
}

void M_Turn_Interactions_Off_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Turn_Interactions_Off_getInteractionClass(cer_M_Turn_Interactions_Off_t* cthis)  {return cthis->interactionClass;}
void cer_M_Turn_Interactions_Off_setInteractionClass(cer_M_Turn_Interactions_Off_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
FILE* M_Turn_Interactions_Off_show(FILE* out) {
   fprintf(out,"[M_Turn_Interactions_Off -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"[M_Turn_Interactions_Off -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Turn_Interactions_Off> ------------------------ */

/* ---------------------- BEGIN <M_Register_Object_Instance> ------------------------ */
cer_M_Register_Object_Instance_t* 
cer_M_Register_Object_Instance_create(uint32_t nb) {
   cer_M_Register_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Register_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Register_Object_Instance; 
   cthis->super->type = M_REGISTER_OBJECT_INSTANCE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   _hasObjectName=0;
   /* objectName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Register_Object_Instance_destroy(cer_M_Register_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Register_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   MB_write_bool(msgBuffer,_hasObjectName);
   if (_hasObjectName) {
      MB_write_string(msgBuffer,objectName);
   }
}

void M_Register_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   _hasObjectName = MB_read_bool(msgBuffer);
   if (_hasObjectName) {
      objectName = MB_read_string(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Register_Object_Instance_getObjectClass(cer_M_Register_Object_Instance_t* cthis)  {return cthis->objectClass;}
void cer_M_Register_Object_Instance_setObjectClass(cer_M_Register_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Register_Object_Instance_getObject(cer_M_Register_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Register_Object_Instance_setObject(cer_M_Register_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Register_Object_Instance_getObjectName(cer_M_Register_Object_Instance_t* cthis)  {return cthis->objectName;}
void cer_M_Register_Object_Instance_setObjectName(cer_M_Register_Object_Instance_t* cthis,  char* newObjectName) {
   cthis->_hasObjectName=1;
   cthis->objectName=newObjectName;
}
uint8_t hasObjectName(cer_M_Register_Object_Instance_t cthis) {return cthis->_hasObjectName;}
FILE* M_Register_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Register_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"(opt) objectName =" + objectName + " "    + "\n");
   fflush(out)
   fprintf(out,"[M_Register_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Register_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Update_Attribute_Values> ------------------------ */
cer_M_Update_Attribute_Values_t* 
cer_M_Update_Attribute_Values_create(uint32_t nb) {
   cer_M_Update_Attribute_Values_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Update_Attribute_Values_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Update_Attribute_Values; 
   cthis->super->type = M_UPDATE_ATTRIBUTE_VALUES;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   /* values= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Update_Attribute_Values_destroy(cer_M_Update_Attribute_Values_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Update_Attribute_Values_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
   uint32_t valuesSize = valuessize;
   MB_write_uint32(msgBuffer,valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <values> of type <AttributeValue_t>
   }
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Update_Attribute_Values_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
   uint32_t valuesSize = MB_read_uint32(msgBuffer);
   valuessize =valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <values> of type <AttributeValue_t>
   }
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Update_Attribute_Values_getObjectClass(cer_M_Update_Attribute_Values_t* cthis)  {return cthis->objectClass;}
void cer_M_Update_Attribute_Values_setObjectClass(cer_M_Update_Attribute_Values_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Update_Attribute_Values_getObject(cer_M_Update_Attribute_Values_t* cthis)  {return cthis->object;}
void cer_M_Update_Attribute_Values_setObject(cer_M_Update_Attribute_Values_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Update_Attribute_Values_getAttributesSize(cer_M_Update_Attribute_Values_t* cthis){ return cthis->attributessize;}
void cer_M_Update_Attribute_Values_setAttributesSize(cer_M_Update_Attribute_Values_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Update_Attribute_Values_getAttributes(cer_M_Update_Attribute_Values_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Update_Attribute_Values_setAttributes(cer_M_Update_Attribute_Values_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
uint32_t cer_M_Update_Attribute_Values_getValuesSize(cer_M_Update_Attribute_Values_t* cthis){ return cthis->valuessize;}
void cer_M_Update_Attribute_Values_setValuesSize(cer_M_Update_Attribute_Values_t* cthis, uint32_t num) { 
   AttributeValue_t* temp;
   temp = calloc(num,sizeof(AttributeValue_t));
   memcpy(temp,cthis->values, cthis->valuessize);
   free(cthis->values);
   cthis->values = temp;
   cthis->valuessize = num;
}
cer_AttributeValue_t_t cer_M_Update_Attribute_Values_getValues(cer_M_Update_Attribute_Values_t* cthis, uint32_t rank) {return cthis->values[rank];}
void cer_M_Update_Attribute_Values_setValues(cer_M_Update_Attribute_Values_t* cthis, cer_AttributeValue_t_t newValues, uint32_t rank) {cthis->values[rank]=newValues;}
cer_EventRetraction_t cer_M_Update_Attribute_Values_getEventRetraction(cer_M_Update_Attribute_Values_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Update_Attribute_Values_setEventRetraction(cer_M_Update_Attribute_Values_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Update_Attribute_Values_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Update_Attribute_Values_show(FILE* out) {
   fprintf(out,"[M_Update_Attribute_Values -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"    values [] = 
");
   for (uint32_t i = 0; i < getValuesSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <values> of type <AttributeValue_t>";
   }
   fprintf(out,"\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Update_Attribute_Values -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Update_Attribute_Values> ------------------------ */

/* ---------------------- BEGIN <M_Discover_Object_Instance> ------------------------ */
cer_M_Discover_Object_Instance_t* 
cer_M_Discover_Object_Instance_create(uint32_t nb) {
   cer_M_Discover_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Discover_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Discover_Object_Instance; 
   cthis->super->type = M_DISCOVER_OBJECT_INSTANCE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* objectName= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Discover_Object_Instance_destroy(cer_M_Discover_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Discover_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   MB_write_string(msgBuffer,objectName);
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Discover_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   objectName = MB_read_string(msgBuffer);
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Discover_Object_Instance_getObjectClass(cer_M_Discover_Object_Instance_t* cthis)  {return cthis->objectClass;}
void cer_M_Discover_Object_Instance_setObjectClass(cer_M_Discover_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Discover_Object_Instance_getObject(cer_M_Discover_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Discover_Object_Instance_setObject(cer_M_Discover_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Discover_Object_Instance_getObjectName(cer_M_Discover_Object_Instance_t* cthis)  {return cthis->objectName;}
void cer_M_Discover_Object_Instance_setObjectName(cer_M_Discover_Object_Instance_t* cthis,  char* newObjectName) {cthis->objectName=newObjectName;}
cer_EventRetraction_t cer_M_Discover_Object_Instance_getEventRetraction(cer_M_Discover_Object_Instance_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Discover_Object_Instance_setEventRetraction(cer_M_Discover_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Discover_Object_Instance_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Discover_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Discover_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," objectName = " + objectName + " "     + "\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Discover_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Discover_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Reflect_Attribute_Values> ------------------------ */
cer_M_Reflect_Attribute_Values_t* 
cer_M_Reflect_Attribute_Values_create(uint32_t nb) {
   cer_M_Reflect_Attribute_Values_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Reflect_Attribute_Values_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Reflect_Attribute_Values; 
   cthis->super->type = M_REFLECT_ATTRIBUTE_VALUES;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   /* values= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Reflect_Attribute_Values_destroy(cer_M_Reflect_Attribute_Values_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Reflect_Attribute_Values_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
   uint32_t valuesSize = valuessize;
   MB_write_uint32(msgBuffer,valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <values> of type <AttributeValue_t>
   }
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Reflect_Attribute_Values_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
   uint32_t valuesSize = MB_read_uint32(msgBuffer);
   valuessize =valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <values> of type <AttributeValue_t>
   }
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Reflect_Attribute_Values_getObjectClass(cer_M_Reflect_Attribute_Values_t* cthis)  {return cthis->objectClass;}
void cer_M_Reflect_Attribute_Values_setObjectClass(cer_M_Reflect_Attribute_Values_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Reflect_Attribute_Values_getObject(cer_M_Reflect_Attribute_Values_t* cthis)  {return cthis->object;}
void cer_M_Reflect_Attribute_Values_setObject(cer_M_Reflect_Attribute_Values_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Reflect_Attribute_Values_getAttributesSize(cer_M_Reflect_Attribute_Values_t* cthis){ return cthis->attributessize;}
void cer_M_Reflect_Attribute_Values_setAttributesSize(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Reflect_Attribute_Values_getAttributes(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Reflect_Attribute_Values_setAttributes(cer_M_Reflect_Attribute_Values_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
uint32_t cer_M_Reflect_Attribute_Values_getValuesSize(cer_M_Reflect_Attribute_Values_t* cthis){ return cthis->valuessize;}
void cer_M_Reflect_Attribute_Values_setValuesSize(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t num) { 
   AttributeValue_t* temp;
   temp = calloc(num,sizeof(AttributeValue_t));
   memcpy(temp,cthis->values, cthis->valuessize);
   free(cthis->values);
   cthis->values = temp;
   cthis->valuessize = num;
}
cer_AttributeValue_t_t cer_M_Reflect_Attribute_Values_getValues(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t rank) {return cthis->values[rank];}
void cer_M_Reflect_Attribute_Values_setValues(cer_M_Reflect_Attribute_Values_t* cthis, cer_AttributeValue_t_t newValues, uint32_t rank) {cthis->values[rank]=newValues;}
cer_EventRetraction_t cer_M_Reflect_Attribute_Values_getEventRetraction(cer_M_Reflect_Attribute_Values_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Reflect_Attribute_Values_setEventRetraction(cer_M_Reflect_Attribute_Values_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Reflect_Attribute_Values_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Reflect_Attribute_Values_show(FILE* out) {
   fprintf(out,"[M_Reflect_Attribute_Values -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"    values [] = 
");
   for (uint32_t i = 0; i < getValuesSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <values> of type <AttributeValue_t>";
   }
   fprintf(out,"\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Reflect_Attribute_Values -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Reflect_Attribute_Values> ------------------------ */

/* ---------------------- BEGIN <M_Send_Interaction> ------------------------ */
cer_M_Send_Interaction_t* 
cer_M_Send_Interaction_create(uint32_t nb) {
   cer_M_Send_Interaction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Send_Interaction_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Send_Interaction; 
   cthis->super->type = M_SEND_INTERACTION;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* parameters= <no default value in message spec using builtin>    */
   /* values= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Send_Interaction_destroy(cer_M_Send_Interaction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Send_Interaction_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   uint32_t parametersSize = parameterssize;
   MB_write_uint32(msgBuffer,parametersSize);
   for (uint32_t i = 0; i < parametersSize; ++i) {
      MB_write_uint32(msgBuffer,parameters[i]);
   }
   uint32_t valuesSize = valuessize;
   MB_write_uint32(msgBuffer,valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <values> of type <ParameterValue_t>
   }
   MB_write_uint32(msgBuffer,region);
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Send_Interaction_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   uint32_t parametersSize = MB_read_uint32(msgBuffer);
   parameterssize =parametersSize);
   for (uint32_t i = 0; i < parametersSize; ++i) {
      parameters[i] = static_cast<ParameterHandle>(MB_read_uint32(msgBuffer));
   }
   uint32_t valuesSize = MB_read_uint32(msgBuffer);
   valuessize =valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <values> of type <ParameterValue_t>
   }
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Send_Interaction_getInteractionClass(cer_M_Send_Interaction_t* cthis)  {return cthis->interactionClass;}
void cer_M_Send_Interaction_setInteractionClass(cer_M_Send_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
uint32_t cer_M_Send_Interaction_getParametersSize(cer_M_Send_Interaction_t* cthis){ return cthis->parameterssize;}
void cer_M_Send_Interaction_setParametersSize(cer_M_Send_Interaction_t* cthis, uint32_t num) { 
   ParameterHandle* temp;
   temp = calloc(num,sizeof(ParameterHandle));
   memcpy(temp,cthis->parameters, cthis->parameterssize);
   free(cthis->parameters);
   cthis->parameters = temp;
   cthis->parameterssize = num;
}
cer_ParameterHandle_t cer_M_Send_Interaction_getParameters(cer_M_Send_Interaction_t* cthis, uint32_t rank) {return cthis->parameters[rank];}
void cer_M_Send_Interaction_setParameters(cer_M_Send_Interaction_t* cthis, cer_ParameterHandle_t newParameters, uint32_t rank) {cthis->parameters[rank]=newParameters;}
uint32_t cer_M_Send_Interaction_getValuesSize(cer_M_Send_Interaction_t* cthis){ return cthis->valuessize;}
void cer_M_Send_Interaction_setValuesSize(cer_M_Send_Interaction_t* cthis, uint32_t num) { 
   ParameterValue_t* temp;
   temp = calloc(num,sizeof(ParameterValue_t));
   memcpy(temp,cthis->values, cthis->valuessize);
   free(cthis->values);
   cthis->values = temp;
   cthis->valuessize = num;
}
cer_ParameterValue_t_t cer_M_Send_Interaction_getValues(cer_M_Send_Interaction_t* cthis, uint32_t rank) {return cthis->values[rank];}
void cer_M_Send_Interaction_setValues(cer_M_Send_Interaction_t* cthis, cer_ParameterValue_t_t newValues, uint32_t rank) {cthis->values[rank]=newValues;}
cer_RegionHandle_t cer_M_Send_Interaction_getRegion(cer_M_Send_Interaction_t* cthis)  {return cthis->region;}
void cer_M_Send_Interaction_setRegion(cer_M_Send_Interaction_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
cer_EventRetraction_t cer_M_Send_Interaction_getEventRetraction(cer_M_Send_Interaction_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Send_Interaction_setEventRetraction(cer_M_Send_Interaction_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Send_Interaction_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Send_Interaction_show(FILE* out) {
   fprintf(out,"[M_Send_Interaction -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"    parameters [] = 
");
   for (uint32_t i = 0; i < getParametersSize(); ++i) {
      out + parameters[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"    values [] = 
");
   for (uint32_t i = 0; i < getValuesSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <values> of type <ParameterValue_t>";
   }
   fprintf(out,"\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Send_Interaction -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Send_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Receive_Interaction> ------------------------ */
cer_M_Receive_Interaction_t* 
cer_M_Receive_Interaction_create(uint32_t nb) {
   cer_M_Receive_Interaction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Receive_Interaction_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Receive_Interaction; 
   cthis->super->type = M_RECEIVE_INTERACTION;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* parameters= <no default value in message spec using builtin>    */
   /* values= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Receive_Interaction_destroy(cer_M_Receive_Interaction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Receive_Interaction_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   uint32_t parametersSize = parameterssize;
   MB_write_uint32(msgBuffer,parametersSize);
   for (uint32_t i = 0; i < parametersSize; ++i) {
      MB_write_uint32(msgBuffer,parameters[i]);
   }
   uint32_t valuesSize = valuessize;
   MB_write_uint32(msgBuffer,valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <values> of type <ParameterValue_t>
   }
   MB_write_uint32(msgBuffer,region);
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Receive_Interaction_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   uint32_t parametersSize = MB_read_uint32(msgBuffer);
   parameterssize =parametersSize);
   for (uint32_t i = 0; i < parametersSize; ++i) {
      parameters[i] = static_cast<ParameterHandle>(MB_read_uint32(msgBuffer));
   }
   uint32_t valuesSize = MB_read_uint32(msgBuffer);
   valuessize =valuesSize);
   for (uint32_t i = 0; i < valuesSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <values> of type <ParameterValue_t>
   }
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Receive_Interaction_getInteractionClass(cer_M_Receive_Interaction_t* cthis)  {return cthis->interactionClass;}
void cer_M_Receive_Interaction_setInteractionClass(cer_M_Receive_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
uint32_t cer_M_Receive_Interaction_getParametersSize(cer_M_Receive_Interaction_t* cthis){ return cthis->parameterssize;}
void cer_M_Receive_Interaction_setParametersSize(cer_M_Receive_Interaction_t* cthis, uint32_t num) { 
   ParameterHandle* temp;
   temp = calloc(num,sizeof(ParameterHandle));
   memcpy(temp,cthis->parameters, cthis->parameterssize);
   free(cthis->parameters);
   cthis->parameters = temp;
   cthis->parameterssize = num;
}
cer_ParameterHandle_t cer_M_Receive_Interaction_getParameters(cer_M_Receive_Interaction_t* cthis, uint32_t rank) {return cthis->parameters[rank];}
void cer_M_Receive_Interaction_setParameters(cer_M_Receive_Interaction_t* cthis, cer_ParameterHandle_t newParameters, uint32_t rank) {cthis->parameters[rank]=newParameters;}
uint32_t cer_M_Receive_Interaction_getValuesSize(cer_M_Receive_Interaction_t* cthis){ return cthis->valuessize;}
void cer_M_Receive_Interaction_setValuesSize(cer_M_Receive_Interaction_t* cthis, uint32_t num) { 
   ParameterValue_t* temp;
   temp = calloc(num,sizeof(ParameterValue_t));
   memcpy(temp,cthis->values, cthis->valuessize);
   free(cthis->values);
   cthis->values = temp;
   cthis->valuessize = num;
}
cer_ParameterValue_t_t cer_M_Receive_Interaction_getValues(cer_M_Receive_Interaction_t* cthis, uint32_t rank) {return cthis->values[rank];}
void cer_M_Receive_Interaction_setValues(cer_M_Receive_Interaction_t* cthis, cer_ParameterValue_t_t newValues, uint32_t rank) {cthis->values[rank]=newValues;}
cer_RegionHandle_t cer_M_Receive_Interaction_getRegion(cer_M_Receive_Interaction_t* cthis)  {return cthis->region;}
void cer_M_Receive_Interaction_setRegion(cer_M_Receive_Interaction_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
cer_EventRetraction_t cer_M_Receive_Interaction_getEventRetraction(cer_M_Receive_Interaction_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Receive_Interaction_setEventRetraction(cer_M_Receive_Interaction_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Receive_Interaction_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Receive_Interaction_show(FILE* out) {
   fprintf(out,"[M_Receive_Interaction -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out,"    parameters [] = 
");
   for (uint32_t i = 0; i < getParametersSize(); ++i) {
      out + parameters[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"    values [] = 
");
   for (uint32_t i = 0; i < getValuesSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <values> of type <ParameterValue_t>";
   }
   fprintf(out,"\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Receive_Interaction -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Receive_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Delete_Object_Instance> ------------------------ */
cer_M_Delete_Object_Instance_t* 
cer_M_Delete_Object_Instance_create(uint32_t nb) {
   cer_M_Delete_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Delete_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Delete_Object_Instance; 
   cthis->super->type = M_DELETE_OBJECT_INSTANCE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* objectName= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Delete_Object_Instance_destroy(cer_M_Delete_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Delete_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   MB_write_string(msgBuffer,objectName);
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Delete_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   objectName = MB_read_string(msgBuffer);
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Delete_Object_Instance_getObjectClass(cer_M_Delete_Object_Instance_t* cthis)  {return cthis->objectClass;}
void cer_M_Delete_Object_Instance_setObjectClass(cer_M_Delete_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Delete_Object_Instance_getObject(cer_M_Delete_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Delete_Object_Instance_setObject(cer_M_Delete_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Delete_Object_Instance_getObjectName(cer_M_Delete_Object_Instance_t* cthis)  {return cthis->objectName;}
void cer_M_Delete_Object_Instance_setObjectName(cer_M_Delete_Object_Instance_t* cthis,  char* newObjectName) {cthis->objectName=newObjectName;}
cer_EventRetraction_t cer_M_Delete_Object_Instance_getEventRetraction(cer_M_Delete_Object_Instance_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Delete_Object_Instance_setEventRetraction(cer_M_Delete_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Delete_Object_Instance_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Delete_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Delete_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," objectName = " + objectName + " "     + "\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Delete_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Delete_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Local_Delete_Object_Instance> ------------------------ */
cer_M_Local_Delete_Object_Instance_t* 
cer_M_Local_Delete_Object_Instance_create(uint32_t nb) {
   cer_M_Local_Delete_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Local_Delete_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Local_Delete_Object_Instance; 
   cthis->super->type = M_LOCAL_DELETE_OBJECT_INSTANCE;
   /* object= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Local_Delete_Object_Instance_destroy(cer_M_Local_Delete_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Local_Delete_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
}

void M_Local_Delete_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Local_Delete_Object_Instance_getObject(cer_M_Local_Delete_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Local_Delete_Object_Instance_setObject(cer_M_Local_Delete_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
FILE* M_Local_Delete_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Local_Delete_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"[M_Local_Delete_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Local_Delete_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Remove_Object_Instance> ------------------------ */
cer_M_Remove_Object_Instance_t* 
cer_M_Remove_Object_Instance_create(uint32_t nb) {
   cer_M_Remove_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Remove_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Remove_Object_Instance; 
   cthis->super->type = M_REMOVE_OBJECT_INSTANCE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* objectName= <no default value in message spec using builtin>    */
   _hasEventRetraction=0;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Remove_Object_Instance_destroy(cer_M_Remove_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Remove_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   MB_write_string(msgBuffer,objectName);
   MB_write_bool(msgBuffer,_hasEventRetraction);
   if (_hasEventRetraction) {
      eventRetraction_serialize(msgBuffer);
   }
}

void M_Remove_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   objectName = MB_read_string(msgBuffer);
   _hasEventRetraction = MB_read_bool(msgBuffer);
   if (_hasEventRetraction) {
      eventRetraction_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Remove_Object_Instance_getObjectClass(cer_M_Remove_Object_Instance_t* cthis)  {return cthis->objectClass;}
void cer_M_Remove_Object_Instance_setObjectClass(cer_M_Remove_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Remove_Object_Instance_getObject(cer_M_Remove_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Remove_Object_Instance_setObject(cer_M_Remove_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Remove_Object_Instance_getObjectName(cer_M_Remove_Object_Instance_t* cthis)  {return cthis->objectName;}
void cer_M_Remove_Object_Instance_setObjectName(cer_M_Remove_Object_Instance_t* cthis,  char* newObjectName) {cthis->objectName=newObjectName;}
cer_EventRetraction_t cer_M_Remove_Object_Instance_getEventRetraction(cer_M_Remove_Object_Instance_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Remove_Object_Instance_setEventRetraction(cer_M_Remove_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction) {
   cthis->_hasEventRetraction=1;
   cthis->eventRetraction=newEventRetraction;
}
uint8_t hasEventRetraction(cer_M_Remove_Object_Instance_t cthis) {return cthis->_hasEventRetraction;}
FILE* M_Remove_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Remove_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," objectName = " + objectName + " "     + "\n");
   fprintf(out,"(opt) eventRetraction =" eventRetraction.show(out)   + "\n");
   fflush(out)
   fprintf(out,"[M_Remove_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Remove_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Change_Attribute_Transportation_Type> ------------------------ */
cer_M_Change_Attribute_Transportation_Type_t* 
cer_M_Change_Attribute_Transportation_Type_create(uint32_t nb) {
   cer_M_Change_Attribute_Transportation_Type_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Change_Attribute_Transportation_Type_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Change_Attribute_Transportation_Type; 
   cthis->super->type = M_CHANGE_ATTRIBUTE_TRANSPORTATION_TYPE;
   /* transportationType= <no default value in message spec using builtin>    */
   /* orderType= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Change_Attribute_Transportation_Type_destroy(cer_M_Change_Attribute_Transportation_Type_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Change_Attribute_Transportation_Type_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint8(msgBuffer,transportationType);
   MB_write_uint8(msgBuffer,orderType);
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Change_Attribute_Transportation_Type_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   transportationType = static_cast<TransportType>(MB_read_uint8(msgBuffer));
   orderType = static_cast<OrderType>(MB_read_uint8(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_TransportType_t cer_M_Change_Attribute_Transportation_Type_getTransportationType(cer_M_Change_Attribute_Transportation_Type_t* cthis)  {return cthis->transportationType;}
void cer_M_Change_Attribute_Transportation_Type_setTransportationType(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_TransportType_t newTransportationType) {cthis->transportationType=newTransportationType;}
cer_OrderType_t cer_M_Change_Attribute_Transportation_Type_getOrderType(cer_M_Change_Attribute_Transportation_Type_t* cthis)  {return cthis->orderType;}
void cer_M_Change_Attribute_Transportation_Type_setOrderType(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_OrderType_t newOrderType) {cthis->orderType=newOrderType;}
cer_ObjectHandle_t cer_M_Change_Attribute_Transportation_Type_getObject(cer_M_Change_Attribute_Transportation_Type_t* cthis)  {return cthis->object;}
void cer_M_Change_Attribute_Transportation_Type_setObject(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Change_Attribute_Transportation_Type_getAttributesSize(cer_M_Change_Attribute_Transportation_Type_t* cthis){ return cthis->attributessize;}
void cer_M_Change_Attribute_Transportation_Type_setAttributesSize(cer_M_Change_Attribute_Transportation_Type_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Change_Attribute_Transportation_Type_getAttributes(cer_M_Change_Attribute_Transportation_Type_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Change_Attribute_Transportation_Type_setAttributes(cer_M_Change_Attribute_Transportation_Type_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Change_Attribute_Transportation_Type_show(FILE* out) {
   fprintf(out,"[M_Change_Attribute_Transportation_Type -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," transportationType = " + transportationType + " "     + "\n");
   fprintf(out," orderType = " + orderType + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Change_Attribute_Transportation_Type -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Change_Attribute_Transportation_Type> ------------------------ */

/* ---------------------- BEGIN <M_Change_Interaction_Transportation_Type> ------------------------ */
cer_M_Change_Interaction_Transportation_Type_t* 
cer_M_Change_Interaction_Transportation_Type_create(uint32_t nb) {
   cer_M_Change_Interaction_Transportation_Type_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Change_Interaction_Transportation_Type_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Change_Interaction_Transportation_Type; 
   cthis->super->type = M_CHANGE_INTERACTION_TRANSPORTATION_TYPE;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* transportationType= <no default value in message spec using builtin>    */
   /* orderType= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Change_Interaction_Transportation_Type_destroy(cer_M_Change_Interaction_Transportation_Type_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Change_Interaction_Transportation_Type_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_uint8(msgBuffer,transportationType);
   MB_write_uint8(msgBuffer,orderType);
}

void M_Change_Interaction_Transportation_Type_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   transportationType = static_cast<TransportType>(MB_read_uint8(msgBuffer));
   orderType = static_cast<OrderType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Change_Interaction_Transportation_Type_getInteractionClass(cer_M_Change_Interaction_Transportation_Type_t* cthis)  {return cthis->interactionClass;}
void cer_M_Change_Interaction_Transportation_Type_setInteractionClass(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
cer_TransportType_t cer_M_Change_Interaction_Transportation_Type_getTransportationType(cer_M_Change_Interaction_Transportation_Type_t* cthis)  {return cthis->transportationType;}
void cer_M_Change_Interaction_Transportation_Type_setTransportationType(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_TransportType_t newTransportationType) {cthis->transportationType=newTransportationType;}
cer_OrderType_t cer_M_Change_Interaction_Transportation_Type_getOrderType(cer_M_Change_Interaction_Transportation_Type_t* cthis)  {return cthis->orderType;}
void cer_M_Change_Interaction_Transportation_Type_setOrderType(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_OrderType_t newOrderType) {cthis->orderType=newOrderType;}
FILE* M_Change_Interaction_Transportation_Type_show(FILE* out) {
   fprintf(out,"[M_Change_Interaction_Transportation_Type -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," transportationType = " + transportationType + " "     + "\n");
   fprintf(out," orderType = " + orderType + " "     + "\n");
   fprintf(out,"[M_Change_Interaction_Transportation_Type -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Change_Interaction_Transportation_Type> ------------------------ */

/* ---------------------- BEGIN <M_Request_Object_Attribute_Value_Update> ------------------------ */
cer_M_Request_Object_Attribute_Value_Update_t* 
cer_M_Request_Object_Attribute_Value_Update_create(uint32_t nb) {
   cer_M_Request_Object_Attribute_Value_Update_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Object_Attribute_Value_Update_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Object_Attribute_Value_Update; 
   cthis->super->type = M_REQUEST_OBJECT_ATTRIBUTE_VALUE_UPDATE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Object_Attribute_Value_Update_destroy(cer_M_Request_Object_Attribute_Value_Update_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Object_Attribute_Value_Update_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Request_Object_Attribute_Value_Update_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Object_Attribute_Value_Update_getObject(cer_M_Request_Object_Attribute_Value_Update_t* cthis)  {return cthis->object;}
void cer_M_Request_Object_Attribute_Value_Update_setObject(cer_M_Request_Object_Attribute_Value_Update_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Request_Object_Attribute_Value_Update_getAttributesSize(cer_M_Request_Object_Attribute_Value_Update_t* cthis){ return cthis->attributessize;}
void cer_M_Request_Object_Attribute_Value_Update_setAttributesSize(cer_M_Request_Object_Attribute_Value_Update_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Request_Object_Attribute_Value_Update_getAttributes(cer_M_Request_Object_Attribute_Value_Update_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Request_Object_Attribute_Value_Update_setAttributes(cer_M_Request_Object_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Request_Object_Attribute_Value_Update_show(FILE* out) {
   fprintf(out,"[M_Request_Object_Attribute_Value_Update -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Request_Object_Attribute_Value_Update -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Object_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Request_Class_Attribute_Value_Update> ------------------------ */
cer_M_Request_Class_Attribute_Value_Update_t* 
cer_M_Request_Class_Attribute_Value_Update_create(uint32_t nb) {
   cer_M_Request_Class_Attribute_Value_Update_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Class_Attribute_Value_Update_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Class_Attribute_Value_Update; 
   cthis->super->type = M_REQUEST_CLASS_ATTRIBUTE_VALUE_UPDATE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Class_Attribute_Value_Update_destroy(cer_M_Request_Class_Attribute_Value_Update_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Class_Attribute_Value_Update_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Request_Class_Attribute_Value_Update_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Request_Class_Attribute_Value_Update_getObjectClass(cer_M_Request_Class_Attribute_Value_Update_t* cthis)  {return cthis->objectClass;}
void cer_M_Request_Class_Attribute_Value_Update_setObjectClass(cer_M_Request_Class_Attribute_Value_Update_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
uint32_t cer_M_Request_Class_Attribute_Value_Update_getAttributesSize(cer_M_Request_Class_Attribute_Value_Update_t* cthis){ return cthis->attributessize;}
void cer_M_Request_Class_Attribute_Value_Update_setAttributesSize(cer_M_Request_Class_Attribute_Value_Update_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Request_Class_Attribute_Value_Update_getAttributes(cer_M_Request_Class_Attribute_Value_Update_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Request_Class_Attribute_Value_Update_setAttributes(cer_M_Request_Class_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Request_Class_Attribute_Value_Update_show(FILE* out) {
   fprintf(out,"[M_Request_Class_Attribute_Value_Update -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Request_Class_Attribute_Value_Update -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Class_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Provide_Attribute_Value_Update> ------------------------ */
cer_M_Provide_Attribute_Value_Update_t* 
cer_M_Provide_Attribute_Value_Update_create(uint32_t nb) {
   cer_M_Provide_Attribute_Value_Update_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Provide_Attribute_Value_Update_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Provide_Attribute_Value_Update; 
   cthis->super->type = M_PROVIDE_ATTRIBUTE_VALUE_UPDATE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Provide_Attribute_Value_Update_destroy(cer_M_Provide_Attribute_Value_Update_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Provide_Attribute_Value_Update_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Provide_Attribute_Value_Update_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Provide_Attribute_Value_Update_getObject(cer_M_Provide_Attribute_Value_Update_t* cthis)  {return cthis->object;}
void cer_M_Provide_Attribute_Value_Update_setObject(cer_M_Provide_Attribute_Value_Update_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Provide_Attribute_Value_Update_getAttributesSize(cer_M_Provide_Attribute_Value_Update_t* cthis){ return cthis->attributessize;}
void cer_M_Provide_Attribute_Value_Update_setAttributesSize(cer_M_Provide_Attribute_Value_Update_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Provide_Attribute_Value_Update_getAttributes(cer_M_Provide_Attribute_Value_Update_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Provide_Attribute_Value_Update_setAttributes(cer_M_Provide_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Provide_Attribute_Value_Update_show(FILE* out) {
   fprintf(out,"[M_Provide_Attribute_Value_Update -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Provide_Attribute_Value_Update -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Provide_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Attributes_In_Scope> ------------------------ */
cer_M_Attributes_In_Scope_t* 
cer_M_Attributes_In_Scope_create(uint32_t nb) {
   cer_M_Attributes_In_Scope_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attributes_In_Scope_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attributes_In_Scope; 
   cthis->super->type = M_ATTRIBUTES_IN_SCOPE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attributes_In_Scope_destroy(cer_M_Attributes_In_Scope_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attributes_In_Scope_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attributes_In_Scope_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attributes_In_Scope_getObject(cer_M_Attributes_In_Scope_t* cthis)  {return cthis->object;}
void cer_M_Attributes_In_Scope_setObject(cer_M_Attributes_In_Scope_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attributes_In_Scope_getAttributesSize(cer_M_Attributes_In_Scope_t* cthis){ return cthis->attributessize;}
void cer_M_Attributes_In_Scope_setAttributesSize(cer_M_Attributes_In_Scope_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attributes_In_Scope_getAttributes(cer_M_Attributes_In_Scope_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attributes_In_Scope_setAttributes(cer_M_Attributes_In_Scope_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attributes_In_Scope_show(FILE* out) {
   fprintf(out,"[M_Attributes_In_Scope -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attributes_In_Scope -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attributes_In_Scope> ------------------------ */

/* ---------------------- BEGIN <M_Attributes_Out_Of_Scope> ------------------------ */
cer_M_Attributes_Out_Of_Scope_t* 
cer_M_Attributes_Out_Of_Scope_create(uint32_t nb) {
   cer_M_Attributes_Out_Of_Scope_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attributes_Out_Of_Scope_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attributes_Out_Of_Scope; 
   cthis->super->type = M_ATTRIBUTES_OUT_OF_SCOPE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attributes_Out_Of_Scope_destroy(cer_M_Attributes_Out_Of_Scope_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attributes_Out_Of_Scope_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attributes_Out_Of_Scope_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attributes_Out_Of_Scope_getObject(cer_M_Attributes_Out_Of_Scope_t* cthis)  {return cthis->object;}
void cer_M_Attributes_Out_Of_Scope_setObject(cer_M_Attributes_Out_Of_Scope_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attributes_Out_Of_Scope_getAttributesSize(cer_M_Attributes_Out_Of_Scope_t* cthis){ return cthis->attributessize;}
void cer_M_Attributes_Out_Of_Scope_setAttributesSize(cer_M_Attributes_Out_Of_Scope_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attributes_Out_Of_Scope_getAttributes(cer_M_Attributes_Out_Of_Scope_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attributes_Out_Of_Scope_setAttributes(cer_M_Attributes_Out_Of_Scope_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attributes_Out_Of_Scope_show(FILE* out) {
   fprintf(out,"[M_Attributes_Out_Of_Scope -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attributes_Out_Of_Scope -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attributes_Out_Of_Scope> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Updates_On_For_Object_Instance> ------------------------ */
cer_M_Turn_Updates_On_For_Object_Instance_t* 
cer_M_Turn_Updates_On_For_Object_Instance_create(uint32_t nb) {
   cer_M_Turn_Updates_On_For_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Turn_Updates_On_For_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Turn_Updates_On_For_Object_Instance; 
   cthis->super->type = M_TURN_UPDATES_ON_FOR_OBJECT_INSTANCE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Turn_Updates_On_For_Object_Instance_destroy(cer_M_Turn_Updates_On_For_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Turn_Updates_On_For_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Turn_Updates_On_For_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Turn_Updates_On_For_Object_Instance_getObject(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Turn_Updates_On_For_Object_Instance_setObject(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Turn_Updates_On_For_Object_Instance_getAttributesSize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis){ return cthis->attributessize;}
void cer_M_Turn_Updates_On_For_Object_Instance_setAttributesSize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Turn_Updates_On_For_Object_Instance_getAttributes(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Turn_Updates_On_For_Object_Instance_setAttributes(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Turn_Updates_On_For_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Turn_Updates_On_For_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Turn_Updates_On_For_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Turn_Updates_On_For_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Updates_Off_For_Object_Instance> ------------------------ */
cer_M_Turn_Updates_Off_For_Object_Instance_t* 
cer_M_Turn_Updates_Off_For_Object_Instance_create(uint32_t nb) {
   cer_M_Turn_Updates_Off_For_Object_Instance_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Turn_Updates_Off_For_Object_Instance_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Turn_Updates_Off_For_Object_Instance; 
   cthis->super->type = M_TURN_UPDATES_OFF_FOR_OBJECT_INSTANCE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Turn_Updates_Off_For_Object_Instance_destroy(cer_M_Turn_Updates_Off_For_Object_Instance_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Turn_Updates_Off_For_Object_Instance_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Turn_Updates_Off_For_Object_Instance_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Turn_Updates_Off_For_Object_Instance_getObject(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis)  {return cthis->object;}
void cer_M_Turn_Updates_Off_For_Object_Instance_setObject(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Turn_Updates_Off_For_Object_Instance_getAttributesSize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis){ return cthis->attributessize;}
void cer_M_Turn_Updates_Off_For_Object_Instance_setAttributesSize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Turn_Updates_Off_For_Object_Instance_getAttributes(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Turn_Updates_Off_For_Object_Instance_setAttributes(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Turn_Updates_Off_For_Object_Instance_show(FILE* out) {
   fprintf(out,"[M_Turn_Updates_Off_For_Object_Instance -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Turn_Updates_Off_For_Object_Instance -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Turn_Updates_Off_For_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Divestiture> ------------------------ */
cer_M_Request_Attribute_Ownership_Divestiture_t* 
cer_M_Request_Attribute_Ownership_Divestiture_create(uint32_t nb) {
   cer_M_Request_Attribute_Ownership_Divestiture_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Attribute_Ownership_Divestiture_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Attribute_Ownership_Divestiture; 
   cthis->super->type = M_REQUEST_ATTRIBUTE_OWNERSHIP_DIVESTITURE;
   return newObj;
}

void cer_M_Request_Attribute_Ownership_Divestiture_destroy(cer_M_Request_Attribute_Ownership_Divestiture_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Assumption> ------------------------ */
cer_M_Request_Attribute_Ownership_Assumption_t* 
cer_M_Request_Attribute_Ownership_Assumption_create(uint32_t nb) {
   cer_M_Request_Attribute_Ownership_Assumption_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Attribute_Ownership_Assumption_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Attribute_Ownership_Assumption; 
   cthis->super->type = M_REQUEST_ATTRIBUTE_OWNERSHIP_ASSUMPTION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Attribute_Ownership_Assumption_destroy(cer_M_Request_Attribute_Ownership_Assumption_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Attribute_Ownership_Assumption_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Request_Attribute_Ownership_Assumption_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Assumption_getObject(cer_M_Request_Attribute_Ownership_Assumption_t* cthis)  {return cthis->object;}
void cer_M_Request_Attribute_Ownership_Assumption_setObject(cer_M_Request_Attribute_Ownership_Assumption_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Request_Attribute_Ownership_Assumption_getAttributesSize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis){ return cthis->attributessize;}
void cer_M_Request_Attribute_Ownership_Assumption_setAttributesSize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Assumption_getAttributes(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Request_Attribute_Ownership_Assumption_setAttributes(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Request_Attribute_Ownership_Assumption_show(FILE* out) {
   fprintf(out,"[M_Request_Attribute_Ownership_Assumption -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Request_Attribute_Ownership_Assumption -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Attribute_Ownership_Assumption> ------------------------ */

/* ---------------------- BEGIN <M_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */
cer_M_Negotiated_Attribute_Ownership_Divestiture_t* 
cer_M_Negotiated_Attribute_Ownership_Divestiture_create(uint32_t nb) {
   cer_M_Negotiated_Attribute_Ownership_Divestiture_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Negotiated_Attribute_Ownership_Divestiture_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Negotiated_Attribute_Ownership_Divestiture; 
   cthis->super->type = M_NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Negotiated_Attribute_Ownership_Divestiture_destroy(cer_M_Negotiated_Attribute_Ownership_Divestiture_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Negotiated_Attribute_Ownership_Divestiture_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Negotiated_Attribute_Ownership_Divestiture_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getObject(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis)  {return cthis->object;}
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setObject(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis){ return cthis->attributessize;}
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getAttributes(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setAttributes(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Negotiated_Attribute_Ownership_Divestiture_show(FILE* out) {
   fprintf(out,"[M_Negotiated_Attribute_Ownership_Divestiture -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Negotiated_Attribute_Ownership_Divestiture -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Divestiture_Notification> ------------------------ */
cer_M_Attribute_Ownership_Divestiture_Notification_t* 
cer_M_Attribute_Ownership_Divestiture_Notification_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Divestiture_Notification_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Divestiture_Notification_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Divestiture_Notification; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_DIVESTITURE_NOTIFICATION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Divestiture_Notification_destroy(cer_M_Attribute_Ownership_Divestiture_Notification_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Divestiture_Notification_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Divestiture_Notification_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Divestiture_Notification_getObject(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Divestiture_Notification_setObject(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Divestiture_Notification_getAttributesSize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Divestiture_Notification_setAttributesSize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Divestiture_Notification_getAttributes(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Divestiture_Notification_setAttributes(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Divestiture_Notification_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Divestiture_Notification -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Divestiture_Notification -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Divestiture_Notification> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition_Notification> ------------------------ */
cer_M_Attribute_Ownership_Acquisition_Notification_t* 
cer_M_Attribute_Ownership_Acquisition_Notification_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Acquisition_Notification_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Acquisition_Notification_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Acquisition_Notification; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_ACQUISITION_NOTIFICATION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Acquisition_Notification_destroy(cer_M_Attribute_Ownership_Acquisition_Notification_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Acquisition_Notification_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Acquisition_Notification_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_Notification_getObject(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Acquisition_Notification_setObject(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Acquisition_Notification_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Acquisition_Notification_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_Notification_getAttributes(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Acquisition_Notification_setAttributes(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Acquisition_Notification_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Acquisition_Notification -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Acquisition_Notification -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Acquisition_Notification> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Acquisition> ------------------------ */
cer_M_Request_Attribute_Ownership_Acquisition_t* 
cer_M_Request_Attribute_Ownership_Acquisition_create(uint32_t nb) {
   cer_M_Request_Attribute_Ownership_Acquisition_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Attribute_Ownership_Acquisition_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Attribute_Ownership_Acquisition; 
   cthis->super->type = M_REQUEST_ATTRIBUTE_OWNERSHIP_ACQUISITION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Attribute_Ownership_Acquisition_destroy(cer_M_Request_Attribute_Ownership_Acquisition_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Attribute_Ownership_Acquisition_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Request_Attribute_Ownership_Acquisition_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Acquisition_getObject(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis)  {return cthis->object;}
void cer_M_Request_Attribute_Ownership_Acquisition_setObject(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Request_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis){ return cthis->attributessize;}
void cer_M_Request_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Acquisition_getAttributes(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Request_Attribute_Ownership_Acquisition_setAttributes(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Request_Attribute_Ownership_Acquisition_show(FILE* out) {
   fprintf(out,"[M_Request_Attribute_Ownership_Acquisition -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Request_Attribute_Ownership_Acquisition -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Release> ------------------------ */
cer_M_Request_Attribute_Ownership_Release_t* 
cer_M_Request_Attribute_Ownership_Release_create(uint32_t nb) {
   cer_M_Request_Attribute_Ownership_Release_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Attribute_Ownership_Release_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Attribute_Ownership_Release; 
   cthis->super->type = M_REQUEST_ATTRIBUTE_OWNERSHIP_RELEASE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Request_Attribute_Ownership_Release_destroy(cer_M_Request_Attribute_Ownership_Release_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Request_Attribute_Ownership_Release_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Request_Attribute_Ownership_Release_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Release_getObject(cer_M_Request_Attribute_Ownership_Release_t* cthis)  {return cthis->object;}
void cer_M_Request_Attribute_Ownership_Release_setObject(cer_M_Request_Attribute_Ownership_Release_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Request_Attribute_Ownership_Release_getAttributesSize(cer_M_Request_Attribute_Ownership_Release_t* cthis){ return cthis->attributessize;}
void cer_M_Request_Attribute_Ownership_Release_setAttributesSize(cer_M_Request_Attribute_Ownership_Release_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Release_getAttributes(cer_M_Request_Attribute_Ownership_Release_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Request_Attribute_Ownership_Release_setAttributes(cer_M_Request_Attribute_Ownership_Release_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Request_Attribute_Ownership_Release_show(FILE* out) {
   fprintf(out,"[M_Request_Attribute_Ownership_Release -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Request_Attribute_Ownership_Release -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Request_Attribute_Ownership_Release> ------------------------ */

/* ---------------------- BEGIN <M_Query_Attribute_Ownership> ------------------------ */
cer_M_Query_Attribute_Ownership_t* 
cer_M_Query_Attribute_Ownership_create(uint32_t nb) {
   cer_M_Query_Attribute_Ownership_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Query_Attribute_Ownership_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Query_Attribute_Ownership; 
   cthis->super->type = M_QUERY_ATTRIBUTE_OWNERSHIP;
   /* object= <no default value in message spec using builtin>    */
   /* attribute= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Query_Attribute_Ownership_destroy(cer_M_Query_Attribute_Ownership_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Query_Attribute_Ownership_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,attribute);
}

void M_Query_Attribute_Ownership_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Query_Attribute_Ownership_getObject(cer_M_Query_Attribute_Ownership_t* cthis)  {return cthis->object;}
void cer_M_Query_Attribute_Ownership_setObject(cer_M_Query_Attribute_Ownership_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_AttributeHandle_t cer_M_Query_Attribute_Ownership_getAttribute(cer_M_Query_Attribute_Ownership_t* cthis)  {return cthis->attribute;}
void cer_M_Query_Attribute_Ownership_setAttribute(cer_M_Query_Attribute_Ownership_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
FILE* M_Query_Attribute_Ownership_show(FILE* out) {
   fprintf(out,"[M_Query_Attribute_Ownership -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out,"[M_Query_Attribute_Ownership -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Query_Attribute_Ownership> ------------------------ */

/* ---------------------- BEGIN <M_Inform_Attribute_Ownership> ------------------------ */
cer_M_Inform_Attribute_Ownership_t* 
cer_M_Inform_Attribute_Ownership_create(uint32_t nb) {
   cer_M_Inform_Attribute_Ownership_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Inform_Attribute_Ownership_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Inform_Attribute_Ownership; 
   cthis->super->type = M_INFORM_ATTRIBUTE_OWNERSHIP;
   /* object= <no default value in message spec using builtin>    */
   /* attribute= <no default value in message spec using builtin>    */
   /* federate= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Inform_Attribute_Ownership_destroy(cer_M_Inform_Attribute_Ownership_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Inform_Attribute_Ownership_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,attribute);
   MB_write_uint32(msgBuffer,federate);
}

void M_Inform_Attribute_Ownership_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   federate = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Inform_Attribute_Ownership_getObject(cer_M_Inform_Attribute_Ownership_t* cthis)  {return cthis->object;}
void cer_M_Inform_Attribute_Ownership_setObject(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_AttributeHandle_t cer_M_Inform_Attribute_Ownership_getAttribute(cer_M_Inform_Attribute_Ownership_t* cthis)  {return cthis->attribute;}
void cer_M_Inform_Attribute_Ownership_setAttribute(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
cer_FederateHandle_t cer_M_Inform_Attribute_Ownership_getFederate(cer_M_Inform_Attribute_Ownership_t* cthis)  {return cthis->federate;}
void cer_M_Inform_Attribute_Ownership_setFederate(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_FederateHandle_t newFederate) {cthis->federate=newFederate;}
FILE* M_Inform_Attribute_Ownership_show(FILE* out) {
   fprintf(out,"[M_Inform_Attribute_Ownership -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out," federate = " + federate + " "     + "\n");
   fprintf(out,"[M_Inform_Attribute_Ownership -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Inform_Attribute_Ownership> ------------------------ */

/* ---------------------- BEGIN <M_Is_Attribute_Owned_By_Federate> ------------------------ */
cer_M_Is_Attribute_Owned_By_Federate_t* 
cer_M_Is_Attribute_Owned_By_Federate_create(uint32_t nb) {
   cer_M_Is_Attribute_Owned_By_Federate_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Is_Attribute_Owned_By_Federate_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Is_Attribute_Owned_By_Federate; 
   cthis->super->type = M_IS_ATTRIBUTE_OWNED_BY_FEDERATE;
   /* object= <no default value in message spec using builtin>    */
   /* attribute= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Is_Attribute_Owned_By_Federate_destroy(cer_M_Is_Attribute_Owned_By_Federate_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Is_Attribute_Owned_By_Federate_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,attribute);
}

void M_Is_Attribute_Owned_By_Federate_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Is_Attribute_Owned_By_Federate_getObject(cer_M_Is_Attribute_Owned_By_Federate_t* cthis)  {return cthis->object;}
void cer_M_Is_Attribute_Owned_By_Federate_setObject(cer_M_Is_Attribute_Owned_By_Federate_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_AttributeHandle_t cer_M_Is_Attribute_Owned_By_Federate_getAttribute(cer_M_Is_Attribute_Owned_By_Federate_t* cthis)  {return cthis->attribute;}
void cer_M_Is_Attribute_Owned_By_Federate_setAttribute(cer_M_Is_Attribute_Owned_By_Federate_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
FILE* M_Is_Attribute_Owned_By_Federate_show(FILE* out) {
   fprintf(out,"[M_Is_Attribute_Owned_By_Federate -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out,"[M_Is_Attribute_Owned_By_Federate -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Is_Attribute_Owned_By_Federate> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Is_Not_Owned> ------------------------ */
cer_M_Attribute_Is_Not_Owned_t* 
cer_M_Attribute_Is_Not_Owned_create(uint32_t nb) {
   cer_M_Attribute_Is_Not_Owned_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Is_Not_Owned_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Is_Not_Owned; 
   cthis->super->type = M_ATTRIBUTE_IS_NOT_OWNED;
   /* object= <no default value in message spec using builtin>    */
   /* attribute= <no default value in message spec using builtin>    */
   /* federate= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Is_Not_Owned_destroy(cer_M_Attribute_Is_Not_Owned_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Is_Not_Owned_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,attribute);
   MB_write_uint32(msgBuffer,federate);
}

void M_Attribute_Is_Not_Owned_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   federate = static_cast<FederateHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Is_Not_Owned_getObject(cer_M_Attribute_Is_Not_Owned_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Is_Not_Owned_setObject(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_AttributeHandle_t cer_M_Attribute_Is_Not_Owned_getAttribute(cer_M_Attribute_Is_Not_Owned_t* cthis)  {return cthis->attribute;}
void cer_M_Attribute_Is_Not_Owned_setAttribute(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
cer_FederateHandle_t cer_M_Attribute_Is_Not_Owned_getFederate(cer_M_Attribute_Is_Not_Owned_t* cthis)  {return cthis->federate;}
void cer_M_Attribute_Is_Not_Owned_setFederate(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_FederateHandle_t newFederate) {cthis->federate=newFederate;}
FILE* M_Attribute_Is_Not_Owned_show(FILE* out) {
   fprintf(out,"[M_Attribute_Is_Not_Owned -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out," federate = " + federate + " "     + "\n");
   fprintf(out,"[M_Attribute_Is_Not_Owned -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Is_Not_Owned> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Owned_By_Rti> ------------------------ */
cer_M_Attribute_Owned_By_Rti_t* 
cer_M_Attribute_Owned_By_Rti_create(uint32_t nb) {
   cer_M_Attribute_Owned_By_Rti_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Owned_By_Rti_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Owned_By_Rti; 
   cthis->super->type = M_ATTRIBUTE_OWNED_BY_RTI;
   return newObj;
}

void cer_M_Attribute_Owned_By_Rti_destroy(cer_M_Attribute_Owned_By_Rti_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition_If_Available> ------------------------ */
cer_M_Attribute_Ownership_Acquisition_If_Available_t* 
cer_M_Attribute_Ownership_Acquisition_If_Available_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Acquisition_If_Available_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Acquisition_If_Available_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Acquisition_If_Available; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_ACQUISITION_IF_AVAILABLE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Acquisition_If_Available_destroy(cer_M_Attribute_Ownership_Acquisition_If_Available_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Acquisition_If_Available_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Acquisition_If_Available_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_If_Available_getObject(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Acquisition_If_Available_setObject(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Acquisition_If_Available_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Acquisition_If_Available_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_If_Available_getAttributes(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Acquisition_If_Available_setAttributes(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Acquisition_If_Available_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Acquisition_If_Available -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Acquisition_If_Available -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Acquisition_If_Available> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Unavailable> ------------------------ */
cer_M_Attribute_Ownership_Unavailable_t* 
cer_M_Attribute_Ownership_Unavailable_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Unavailable_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Unavailable_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Unavailable; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_UNAVAILABLE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Unavailable_destroy(cer_M_Attribute_Ownership_Unavailable_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Unavailable_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Unavailable_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Unavailable_getObject(cer_M_Attribute_Ownership_Unavailable_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Unavailable_setObject(cer_M_Attribute_Ownership_Unavailable_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Unavailable_getAttributesSize(cer_M_Attribute_Ownership_Unavailable_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Unavailable_setAttributesSize(cer_M_Attribute_Ownership_Unavailable_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Unavailable_getAttributes(cer_M_Attribute_Ownership_Unavailable_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Unavailable_setAttributes(cer_M_Attribute_Ownership_Unavailable_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Unavailable_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Unavailable -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Unavailable -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Unavailable> ------------------------ */

/* ---------------------- BEGIN <M_Unconditional_Attribute_Ownership_Divestiture> ------------------------ */
cer_M_Unconditional_Attribute_Ownership_Divestiture_t* 
cer_M_Unconditional_Attribute_Ownership_Divestiture_create(uint32_t nb) {
   cer_M_Unconditional_Attribute_Ownership_Divestiture_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Unconditional_Attribute_Ownership_Divestiture_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Unconditional_Attribute_Ownership_Divestiture; 
   cthis->super->type = M_UNCONDITIONAL_ATTRIBUTE_OWNERSHIP_DIVESTITURE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Unconditional_Attribute_Ownership_Divestiture_destroy(cer_M_Unconditional_Attribute_Ownership_Divestiture_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Unconditional_Attribute_Ownership_Divestiture_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Unconditional_Attribute_Ownership_Divestiture_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getObject(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis)  {return cthis->object;}
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setObject(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis){ return cthis->attributessize;}
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getAttributes(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setAttributes(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Unconditional_Attribute_Ownership_Divestiture_show(FILE* out) {
   fprintf(out,"[M_Unconditional_Attribute_Ownership_Divestiture -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Unconditional_Attribute_Ownership_Divestiture -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Unconditional_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition> ------------------------ */
cer_M_Attribute_Ownership_Acquisition_t* 
cer_M_Attribute_Ownership_Acquisition_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Acquisition_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Acquisition_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Acquisition; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_ACQUISITION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Acquisition_destroy(cer_M_Attribute_Ownership_Acquisition_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Acquisition_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Acquisition_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_getObject(cer_M_Attribute_Ownership_Acquisition_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Acquisition_setObject(cer_M_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_getAttributes(cer_M_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Acquisition_setAttributes(cer_M_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Acquisition_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Acquisition -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Acquisition -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Cancel_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */
cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* 
cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_create(uint32_t nb) {
   cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Cancel_Negotiated_Attribute_Ownership_Divestiture; 
   cthis->super->type = M_CANCEL_NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_destroy(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Cancel_Negotiated_Attribute_Ownership_Divestiture_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Cancel_Negotiated_Attribute_Ownership_Divestiture_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getObject(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis)  {return cthis->object;}
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setObject(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis){ return cthis->attributessize;}
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getAttributes(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setAttributes(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Cancel_Negotiated_Attribute_Ownership_Divestiture_show(FILE* out) {
   fprintf(out,"[M_Cancel_Negotiated_Attribute_Ownership_Divestiture -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Cancel_Negotiated_Attribute_Ownership_Divestiture -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Cancel_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Release_Response> ------------------------ */
cer_M_Attribute_Ownership_Release_Response_t* 
cer_M_Attribute_Ownership_Release_Response_create(uint32_t nb) {
   cer_M_Attribute_Ownership_Release_Response_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Attribute_Ownership_Release_Response_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Attribute_Ownership_Release_Response; 
   cthis->super->type = M_ATTRIBUTE_OWNERSHIP_RELEASE_RESPONSE;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Attribute_Ownership_Release_Response_destroy(cer_M_Attribute_Ownership_Release_Response_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Attribute_Ownership_Release_Response_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Attribute_Ownership_Release_Response_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Release_Response_getObject(cer_M_Attribute_Ownership_Release_Response_t* cthis)  {return cthis->object;}
void cer_M_Attribute_Ownership_Release_Response_setObject(cer_M_Attribute_Ownership_Release_Response_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Attribute_Ownership_Release_Response_getAttributesSize(cer_M_Attribute_Ownership_Release_Response_t* cthis){ return cthis->attributessize;}
void cer_M_Attribute_Ownership_Release_Response_setAttributesSize(cer_M_Attribute_Ownership_Release_Response_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Attribute_Ownership_Release_Response_getAttributes(cer_M_Attribute_Ownership_Release_Response_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Attribute_Ownership_Release_Response_setAttributes(cer_M_Attribute_Ownership_Release_Response_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Attribute_Ownership_Release_Response_show(FILE* out) {
   fprintf(out,"[M_Attribute_Ownership_Release_Response -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Attribute_Ownership_Release_Response -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Attribute_Ownership_Release_Response> ------------------------ */

/* ---------------------- BEGIN <M_Cancel_Attribute_Ownership_Acquisition> ------------------------ */
cer_M_Cancel_Attribute_Ownership_Acquisition_t* 
cer_M_Cancel_Attribute_Ownership_Acquisition_create(uint32_t nb) {
   cer_M_Cancel_Attribute_Ownership_Acquisition_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Cancel_Attribute_Ownership_Acquisition_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Cancel_Attribute_Ownership_Acquisition; 
   cthis->super->type = M_CANCEL_ATTRIBUTE_OWNERSHIP_ACQUISITION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Cancel_Attribute_Ownership_Acquisition_destroy(cer_M_Cancel_Attribute_Ownership_Acquisition_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Cancel_Attribute_Ownership_Acquisition_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Cancel_Attribute_Ownership_Acquisition_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Cancel_Attribute_Ownership_Acquisition_getObject(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis)  {return cthis->object;}
void cer_M_Cancel_Attribute_Ownership_Acquisition_setObject(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Cancel_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis){ return cthis->attributessize;}
void cer_M_Cancel_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Cancel_Attribute_Ownership_Acquisition_getAttributes(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Cancel_Attribute_Ownership_Acquisition_setAttributes(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Cancel_Attribute_Ownership_Acquisition_show(FILE* out) {
   fprintf(out,"[M_Cancel_Attribute_Ownership_Acquisition -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Cancel_Attribute_Ownership_Acquisition -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Cancel_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Confirm_Attribute_Ownership_Acquisition_Cancellation> ------------------------ */
cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* 
cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_create(uint32_t nb) {
   cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Confirm_Attribute_Ownership_Acquisition_Cancellation; 
   cthis->super->type = M_CONFIRM_ATTRIBUTE_OWNERSHIP_ACQUISITION_CANCELLATION;
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_destroy(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Confirm_Attribute_Ownership_Acquisition_Cancellation_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Confirm_Attribute_Ownership_Acquisition_Cancellation_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getObject(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis)  {return cthis->object;}
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setObject(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getAttributesSize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis){ return cthis->attributessize;}
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setAttributesSize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getAttributes(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setAttributes(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Confirm_Attribute_Ownership_Acquisition_Cancellation_show(FILE* out) {
   fprintf(out,"[M_Confirm_Attribute_Ownership_Acquisition_Cancellation -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Confirm_Attribute_Ownership_Acquisition_Cancellation -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Confirm_Attribute_Ownership_Acquisition_Cancellation> ------------------------ */

/* ---------------------- BEGIN <M_Change_Attribute_Order_Type> ------------------------ */
cer_M_Change_Attribute_Order_Type_t* 
cer_M_Change_Attribute_Order_Type_create(uint32_t nb) {
   cer_M_Change_Attribute_Order_Type_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Change_Attribute_Order_Type_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Change_Attribute_Order_Type; 
   cthis->super->type = M_CHANGE_ATTRIBUTE_ORDER_TYPE;
   /* transport= <no default value in message spec using builtin>    */
   /* order= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Change_Attribute_Order_Type_destroy(cer_M_Change_Attribute_Order_Type_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Change_Attribute_Order_Type_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint8(msgBuffer,transport);
   MB_write_uint8(msgBuffer,order);
   MB_write_uint32(msgBuffer,object);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Change_Attribute_Order_Type_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   transport = static_cast<TransportType>(MB_read_uint8(msgBuffer));
   order = static_cast<OrderType>(MB_read_uint8(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_TransportType_t cer_M_Change_Attribute_Order_Type_getTransport(cer_M_Change_Attribute_Order_Type_t* cthis)  {return cthis->transport;}
void cer_M_Change_Attribute_Order_Type_setTransport(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_TransportType_t newTransport) {cthis->transport=newTransport;}
cer_OrderType_t cer_M_Change_Attribute_Order_Type_getOrder(cer_M_Change_Attribute_Order_Type_t* cthis)  {return cthis->order;}
void cer_M_Change_Attribute_Order_Type_setOrder(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_OrderType_t newOrder) {cthis->order=newOrder;}
cer_ObjectHandle_t cer_M_Change_Attribute_Order_Type_getObject(cer_M_Change_Attribute_Order_Type_t* cthis)  {return cthis->object;}
void cer_M_Change_Attribute_Order_Type_setObject(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
uint32_t cer_M_Change_Attribute_Order_Type_getAttributesSize(cer_M_Change_Attribute_Order_Type_t* cthis){ return cthis->attributessize;}
void cer_M_Change_Attribute_Order_Type_setAttributesSize(cer_M_Change_Attribute_Order_Type_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Change_Attribute_Order_Type_getAttributes(cer_M_Change_Attribute_Order_Type_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Change_Attribute_Order_Type_setAttributes(cer_M_Change_Attribute_Order_Type_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Change_Attribute_Order_Type_show(FILE* out) {
   fprintf(out,"[M_Change_Attribute_Order_Type -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," transport = " + transport + " "     + "\n");
   fprintf(out," order = " + order + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Change_Attribute_Order_Type -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Change_Attribute_Order_Type> ------------------------ */

/* ---------------------- BEGIN <M_Change_Interaction_Order_Type> ------------------------ */
cer_M_Change_Interaction_Order_Type_t* 
cer_M_Change_Interaction_Order_Type_create(uint32_t nb) {
   cer_M_Change_Interaction_Order_Type_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Change_Interaction_Order_Type_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Change_Interaction_Order_Type; 
   cthis->super->type = M_CHANGE_INTERACTION_ORDER_TYPE;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* transport= <no default value in message spec using builtin>    */
   /* order= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Change_Interaction_Order_Type_destroy(cer_M_Change_Interaction_Order_Type_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Change_Interaction_Order_Type_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_uint8(msgBuffer,transport);
   MB_write_uint8(msgBuffer,order);
}

void M_Change_Interaction_Order_Type_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   transport = static_cast<TransportType>(MB_read_uint8(msgBuffer));
   order = static_cast<OrderType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Change_Interaction_Order_Type_getInteractionClass(cer_M_Change_Interaction_Order_Type_t* cthis)  {return cthis->interactionClass;}
void cer_M_Change_Interaction_Order_Type_setInteractionClass(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
cer_TransportType_t cer_M_Change_Interaction_Order_Type_getTransport(cer_M_Change_Interaction_Order_Type_t* cthis)  {return cthis->transport;}
void cer_M_Change_Interaction_Order_Type_setTransport(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_TransportType_t newTransport) {cthis->transport=newTransport;}
cer_OrderType_t cer_M_Change_Interaction_Order_Type_getOrder(cer_M_Change_Interaction_Order_Type_t* cthis)  {return cthis->order;}
void cer_M_Change_Interaction_Order_Type_setOrder(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_OrderType_t newOrder) {cthis->order=newOrder;}
FILE* M_Change_Interaction_Order_Type_show(FILE* out) {
   fprintf(out,"[M_Change_Interaction_Order_Type -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," transport = " + transport + " "     + "\n");
   fprintf(out," order = " + order + " "     + "\n");
   fprintf(out,"[M_Change_Interaction_Order_Type -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Change_Interaction_Order_Type> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Time_Regulation> ------------------------ */
cer_M_Enable_Time_Regulation_t* 
cer_M_Enable_Time_Regulation_create(uint32_t nb) {
   cer_M_Enable_Time_Regulation_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Time_Regulation_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Time_Regulation; 
   cthis->super->type = M_ENABLE_TIME_REGULATION;
   double lookahead=0;
   return newObj;
}

void cer_M_Enable_Time_Regulation_destroy(cer_M_Enable_Time_Regulation_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Enable_Time_Regulation_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_double(msgBuffer,lookahead);
}

void M_Enable_Time_Regulation_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   lookahead = MB_read_double(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
double cer_M_Enable_Time_Regulation_getLookahead(cer_M_Enable_Time_Regulation_t* cthis)  {return cthis->lookahead;}
void cer_M_Enable_Time_Regulation_setLookahead(cer_M_Enable_Time_Regulation_t* cthis,  double newLookahead) {cthis->lookahead=newLookahead;}
FILE* M_Enable_Time_Regulation_show(FILE* out) {
   fprintf(out,"[M_Enable_Time_Regulation -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," lookahead = " + lookahead + " "     + "\n");
   fprintf(out,"[M_Enable_Time_Regulation -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Enable_Time_Regulation> ------------------------ */

/* ---------------------- BEGIN <M_Disable_Time_Regulation> ------------------------ */
cer_M_Disable_Time_Regulation_t* 
cer_M_Disable_Time_Regulation_create(uint32_t nb) {
   cer_M_Disable_Time_Regulation_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Time_Regulation_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Time_Regulation; 
   cthis->super->type = M_DISABLE_TIME_REGULATION;
   double lookahead=0;
   return newObj;
}

void cer_M_Disable_Time_Regulation_destroy(cer_M_Disable_Time_Regulation_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Disable_Time_Regulation_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_double(msgBuffer,lookahead);
}

void M_Disable_Time_Regulation_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   lookahead = MB_read_double(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
double cer_M_Disable_Time_Regulation_getLookahead(cer_M_Disable_Time_Regulation_t* cthis)  {return cthis->lookahead;}
void cer_M_Disable_Time_Regulation_setLookahead(cer_M_Disable_Time_Regulation_t* cthis,  double newLookahead) {cthis->lookahead=newLookahead;}
FILE* M_Disable_Time_Regulation_show(FILE* out) {
   fprintf(out,"[M_Disable_Time_Regulation -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," lookahead = " + lookahead + " "     + "\n");
   fprintf(out,"[M_Disable_Time_Regulation -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Disable_Time_Regulation> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Time_Constrained> ------------------------ */
cer_M_Enable_Time_Constrained_t* 
cer_M_Enable_Time_Constrained_create(uint32_t nb) {
   cer_M_Enable_Time_Constrained_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Time_Constrained_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Time_Constrained; 
   cthis->super->type = M_ENABLE_TIME_CONSTRAINED;
   return newObj;
}

void cer_M_Enable_Time_Constrained_destroy(cer_M_Enable_Time_Constrained_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Time_Constrained> ------------------------ */
cer_M_Disable_Time_Constrained_t* 
cer_M_Disable_Time_Constrained_create(uint32_t nb) {
   cer_M_Disable_Time_Constrained_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Time_Constrained_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Time_Constrained; 
   cthis->super->type = M_DISABLE_TIME_CONSTRAINED;
   return newObj;
}

void cer_M_Disable_Time_Constrained_destroy(cer_M_Disable_Time_Constrained_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Query_Lbts> ------------------------ */
cer_M_Query_Lbts_t* 
cer_M_Query_Lbts_create(uint32_t nb) {
   cer_M_Query_Lbts_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Query_Lbts_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Query_Lbts; 
   cthis->super->type = M_QUERY_LBTS;
   return newObj;
}

void cer_M_Query_Lbts_destroy(cer_M_Query_Lbts_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Query_Federate_Time> ------------------------ */
cer_M_Query_Federate_Time_t* 
cer_M_Query_Federate_Time_create(uint32_t nb) {
   cer_M_Query_Federate_Time_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Query_Federate_Time_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Query_Federate_Time; 
   cthis->super->type = M_QUERY_FEDERATE_TIME;
   return newObj;
}

void cer_M_Query_Federate_Time_destroy(cer_M_Query_Federate_Time_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Query_Min_Next_Event_Time> ------------------------ */
cer_M_Query_Min_Next_Event_Time_t* 
cer_M_Query_Min_Next_Event_Time_create(uint32_t nb) {
   cer_M_Query_Min_Next_Event_Time_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Query_Min_Next_Event_Time_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Query_Min_Next_Event_Time; 
   cthis->super->type = M_QUERY_MIN_NEXT_EVENT_TIME;
   return newObj;
}

void cer_M_Query_Min_Next_Event_Time_destroy(cer_M_Query_Min_Next_Event_Time_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Modify_Lookahead> ------------------------ */
cer_M_Modify_Lookahead_t* 
cer_M_Modify_Lookahead_create(uint32_t nb) {
   cer_M_Modify_Lookahead_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Modify_Lookahead_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Modify_Lookahead; 
   cthis->super->type = M_MODIFY_LOOKAHEAD;
   /* lookahead= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Modify_Lookahead_destroy(cer_M_Modify_Lookahead_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Modify_Lookahead_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_double(msgBuffer,lookahead);
}

void M_Modify_Lookahead_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   lookahead = MB_read_double(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
double cer_M_Modify_Lookahead_getLookahead(cer_M_Modify_Lookahead_t* cthis)  {return cthis->lookahead;}
void cer_M_Modify_Lookahead_setLookahead(cer_M_Modify_Lookahead_t* cthis,  double newLookahead) {cthis->lookahead=newLookahead;}
FILE* M_Modify_Lookahead_show(FILE* out) {
   fprintf(out,"[M_Modify_Lookahead -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," lookahead = " + lookahead + " "     + "\n");
   fprintf(out,"[M_Modify_Lookahead -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Modify_Lookahead> ------------------------ */

/* ---------------------- BEGIN <M_Query_Lookahead> ------------------------ */
cer_M_Query_Lookahead_t* 
cer_M_Query_Lookahead_create(uint32_t nb) {
   cer_M_Query_Lookahead_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Query_Lookahead_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Query_Lookahead; 
   cthis->super->type = M_QUERY_LOOKAHEAD;
   /* lookahead= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Query_Lookahead_destroy(cer_M_Query_Lookahead_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Query_Lookahead_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_double(msgBuffer,lookahead);
}

void M_Query_Lookahead_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   lookahead = MB_read_double(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
double cer_M_Query_Lookahead_getLookahead(cer_M_Query_Lookahead_t* cthis)  {return cthis->lookahead;}
void cer_M_Query_Lookahead_setLookahead(cer_M_Query_Lookahead_t* cthis,  double newLookahead) {cthis->lookahead=newLookahead;}
FILE* M_Query_Lookahead_show(FILE* out) {
   fprintf(out,"[M_Query_Lookahead -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," lookahead = " + lookahead + " "     + "\n");
   fprintf(out,"[M_Query_Lookahead -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Query_Lookahead> ------------------------ */

/* ---------------------- BEGIN <M_Retract> ------------------------ */
cer_M_Retract_t* 
cer_M_Retract_create(uint32_t nb) {
   cer_M_Retract_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Retract_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Retract; 
   cthis->super->type = M_RETRACT;
   /* eventRetraction= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Retract_destroy(cer_M_Retract_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Retract_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   eventRetraction_serialize(msgBuffer);
}

void M_Retract_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   eventRetraction_deserialize(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_EventRetraction_t cer_M_Retract_getEventRetraction(cer_M_Retract_t* cthis)  {return cthis->eventRetraction;}
void cer_M_Retract_setEventRetraction(cer_M_Retract_t* cthis,  cer_EventRetraction_t newEventRetraction) {cthis->eventRetraction=newEventRetraction;}
FILE* M_Retract_show(FILE* out) {
   fprintf(out,"[M_Retract -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," eventRetraction = " eventRetraction.show(out)    + "\n");
   fprintf(out,"[M_Retract -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Retract> ------------------------ */

/* ---------------------- BEGIN <M_Request_Retraction> ------------------------ */
cer_M_Request_Retraction_t* 
cer_M_Request_Retraction_create(uint32_t nb) {
   cer_M_Request_Retraction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Request_Retraction_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Request_Retraction; 
   cthis->super->type = M_REQUEST_RETRACTION;
   return newObj;
}

void cer_M_Request_Retraction_destroy(cer_M_Request_Retraction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Time_Advance_Request> ------------------------ */
cer_M_Time_Advance_Request_t* 
cer_M_Time_Advance_Request_create(uint32_t nb) {
   cer_M_Time_Advance_Request_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Time_Advance_Request_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Time_Advance_Request; 
   cthis->super->type = M_TIME_ADVANCE_REQUEST;
   return newObj;
}

void cer_M_Time_Advance_Request_destroy(cer_M_Time_Advance_Request_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Time_Advance_Request_Available> ------------------------ */
cer_M_Time_Advance_Request_Available_t* 
cer_M_Time_Advance_Request_Available_create(uint32_t nb) {
   cer_M_Time_Advance_Request_Available_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Time_Advance_Request_Available_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Time_Advance_Request_Available; 
   cthis->super->type = M_TIME_ADVANCE_REQUEST_AVAILABLE;
   return newObj;
}

void cer_M_Time_Advance_Request_Available_destroy(cer_M_Time_Advance_Request_Available_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Next_Event_Request> ------------------------ */
cer_M_Next_Event_Request_t* 
cer_M_Next_Event_Request_create(uint32_t nb) {
   cer_M_Next_Event_Request_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Next_Event_Request_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Next_Event_Request; 
   cthis->super->type = M_NEXT_EVENT_REQUEST;
   return newObj;
}

void cer_M_Next_Event_Request_destroy(cer_M_Next_Event_Request_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Next_Event_Request_Available> ------------------------ */
cer_M_Next_Event_Request_Available_t* 
cer_M_Next_Event_Request_Available_create(uint32_t nb) {
   cer_M_Next_Event_Request_Available_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Next_Event_Request_Available_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Next_Event_Request_Available; 
   cthis->super->type = M_NEXT_EVENT_REQUEST_AVAILABLE;
   return newObj;
}

void cer_M_Next_Event_Request_Available_destroy(cer_M_Next_Event_Request_Available_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Flush_Queue_Request> ------------------------ */
cer_M_Flush_Queue_Request_t* 
cer_M_Flush_Queue_Request_create(uint32_t nb) {
   cer_M_Flush_Queue_Request_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Flush_Queue_Request_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Flush_Queue_Request; 
   cthis->super->type = M_FLUSH_QUEUE_REQUEST;
   return newObj;
}

void cer_M_Flush_Queue_Request_destroy(cer_M_Flush_Queue_Request_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Time_Advance_Grant> ------------------------ */
cer_M_Time_Advance_Grant_t* 
cer_M_Time_Advance_Grant_create(uint32_t nb) {
   cer_M_Time_Advance_Grant_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Time_Advance_Grant_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Time_Advance_Grant; 
   cthis->super->type = M_TIME_ADVANCE_GRANT;
   return newObj;
}

void cer_M_Time_Advance_Grant_destroy(cer_M_Time_Advance_Grant_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Enable_Asynchronous_Delivery> ------------------------ */
cer_M_Enable_Asynchronous_Delivery_t* 
cer_M_Enable_Asynchronous_Delivery_create(uint32_t nb) {
   cer_M_Enable_Asynchronous_Delivery_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Asynchronous_Delivery_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Asynchronous_Delivery; 
   cthis->super->type = M_ENABLE_ASYNCHRONOUS_DELIVERY;
   return newObj;
}

void cer_M_Enable_Asynchronous_Delivery_destroy(cer_M_Enable_Asynchronous_Delivery_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Asynchronous_Delivery> ------------------------ */
cer_M_Disable_Asynchronous_Delivery_t* 
cer_M_Disable_Asynchronous_Delivery_create(uint32_t nb) {
   cer_M_Disable_Asynchronous_Delivery_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Asynchronous_Delivery_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Asynchronous_Delivery; 
   cthis->super->type = M_DISABLE_ASYNCHRONOUS_DELIVERY;
   return newObj;
}

void cer_M_Disable_Asynchronous_Delivery_destroy(cer_M_Disable_Asynchronous_Delivery_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Time_Regulation_Enabled> ------------------------ */
cer_M_Time_Regulation_Enabled_t* 
cer_M_Time_Regulation_Enabled_create(uint32_t nb) {
   cer_M_Time_Regulation_Enabled_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Time_Regulation_Enabled_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Time_Regulation_Enabled; 
   cthis->super->type = M_TIME_REGULATION_ENABLED;
   return newObj;
}

void cer_M_Time_Regulation_Enabled_destroy(cer_M_Time_Regulation_Enabled_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Time_Constrained_Enabled> ------------------------ */
cer_M_Time_Constrained_Enabled_t* 
cer_M_Time_Constrained_Enabled_create(uint32_t nb) {
   cer_M_Time_Constrained_Enabled_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Time_Constrained_Enabled_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Time_Constrained_Enabled; 
   cthis->super->type = M_TIME_CONSTRAINED_ENABLED;
   return newObj;
}

void cer_M_Time_Constrained_Enabled_destroy(cer_M_Time_Constrained_Enabled_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Ddm_Create_Region> ------------------------ */
cer_M_Ddm_Create_Region_t* 
cer_M_Ddm_Create_Region_create(uint32_t nb) {
   cer_M_Ddm_Create_Region_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Create_Region_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Create_Region; 
   cthis->super->type = M_DDM_CREATE_REGION;
   /* space= <no default value in message spec using builtin>    */
   /* extentSet= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Create_Region_destroy(cer_M_Ddm_Create_Region_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Create_Region_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,space);
   uint32_t extentSetSize = extentSetsize;
   MB_write_uint32(msgBuffer,extentSetSize);
   for (uint32_t i = 0; i < extentSetSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <extentSet> of type <Extent>
   }
   MB_write_uint32(msgBuffer,region);
}

void M_Ddm_Create_Region_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
   uint32_t extentSetSize = MB_read_uint32(msgBuffer);
   extentSetsize =extentSetSize);
   for (uint32_t i = 0; i < extentSetSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <extentSet> of type <Extent>
   }
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_SpaceHandle_t cer_M_Ddm_Create_Region_getSpace(cer_M_Ddm_Create_Region_t* cthis)  {return cthis->space;}
void cer_M_Ddm_Create_Region_setSpace(cer_M_Ddm_Create_Region_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
uint32_t cer_M_Ddm_Create_Region_getExtentSetSize(cer_M_Ddm_Create_Region_t* cthis){ return cthis->extentSetsize;}
void cer_M_Ddm_Create_Region_setExtentSetSize(cer_M_Ddm_Create_Region_t* cthis, uint32_t num) { 
   Extent* temp;
   temp = calloc(num,sizeof(Extent));
   memcpy(temp,cthis->extentSet, cthis->extentSetsize);
   free(cthis->extentSet);
   cthis->extentSet = temp;
   cthis->extentSetsize = num;
}
cer_Extent_t cer_M_Ddm_Create_Region_getExtentSet(cer_M_Ddm_Create_Region_t* cthis, uint32_t rank) {return cthis->extentSet[rank];}
void cer_M_Ddm_Create_Region_setExtentSet(cer_M_Ddm_Create_Region_t* cthis, cer_Extent_t newExtentSet, uint32_t rank) {cthis->extentSet[rank]=newExtentSet;}
cer_RegionHandle_t cer_M_Ddm_Create_Region_getRegion(cer_M_Ddm_Create_Region_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Create_Region_setRegion(cer_M_Ddm_Create_Region_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
FILE* M_Ddm_Create_Region_show(FILE* out) {
   fprintf(out,"[M_Ddm_Create_Region -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out,"    extentSet [] = 
");
   for (uint32_t i = 0; i < getExtentSetSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <extentSet> of type <Extent>";
   }
   fprintf(out,"\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"[M_Ddm_Create_Region -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Create_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Modify_Region> ------------------------ */
cer_M_Ddm_Modify_Region_t* 
cer_M_Ddm_Modify_Region_create(uint32_t nb) {
   cer_M_Ddm_Modify_Region_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Modify_Region_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Modify_Region; 
   cthis->super->type = M_DDM_MODIFY_REGION;
   /* region= <no default value in message spec using builtin>    */
   /* extentSet= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Modify_Region_destroy(cer_M_Ddm_Modify_Region_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Modify_Region_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,region);
   uint32_t extentSetSize = extentSetsize;
   MB_write_uint32(msgBuffer,extentSetSize);
   for (uint32_t i = 0; i < extentSetSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to serialize native field <extentSet> of type <Extent>
   }
}

void M_Ddm_Modify_Region_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   uint32_t extentSetSize = MB_read_uint32(msgBuffer);
   extentSetsize =extentSetSize);
   for (uint32_t i = 0; i < extentSetSize; ++i) {
      /*  FIXME FIXME FIXME
      /*  don't know how to deserialize native field <extentSet> of type <Extent>
   }
}

/* specific Getter(s)/Setter(s) */
cer_RegionHandle_t cer_M_Ddm_Modify_Region_getRegion(cer_M_Ddm_Modify_Region_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Modify_Region_setRegion(cer_M_Ddm_Modify_Region_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
uint32_t cer_M_Ddm_Modify_Region_getExtentSetSize(cer_M_Ddm_Modify_Region_t* cthis){ return cthis->extentSetsize;}
void cer_M_Ddm_Modify_Region_setExtentSetSize(cer_M_Ddm_Modify_Region_t* cthis, uint32_t num) { 
   Extent* temp;
   temp = calloc(num,sizeof(Extent));
   memcpy(temp,cthis->extentSet, cthis->extentSetsize);
   free(cthis->extentSet);
   cthis->extentSet = temp;
   cthis->extentSetsize = num;
}
cer_Extent_t cer_M_Ddm_Modify_Region_getExtentSet(cer_M_Ddm_Modify_Region_t* cthis, uint32_t rank) {return cthis->extentSet[rank];}
void cer_M_Ddm_Modify_Region_setExtentSet(cer_M_Ddm_Modify_Region_t* cthis, cer_Extent_t newExtentSet, uint32_t rank) {cthis->extentSet[rank]=newExtentSet;}
FILE* M_Ddm_Modify_Region_show(FILE* out) {
   fprintf(out,"[M_Ddm_Modify_Region -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"    extentSet [] = 
");
   for (uint32_t i = 0; i < getExtentSetSize(); ++i) {
      out << "      /* FIXME FIXME don't know how to serialize native field <extentSet> of type <Extent>";
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Ddm_Modify_Region -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Modify_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Delete_Region> ------------------------ */
cer_M_Ddm_Delete_Region_t* 
cer_M_Ddm_Delete_Region_create(uint32_t nb) {
   cer_M_Ddm_Delete_Region_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Delete_Region_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Delete_Region; 
   cthis->super->type = M_DDM_DELETE_REGION;
   /* region= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Delete_Region_destroy(cer_M_Ddm_Delete_Region_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Delete_Region_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,region);
}

void M_Ddm_Delete_Region_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_RegionHandle_t cer_M_Ddm_Delete_Region_getRegion(cer_M_Ddm_Delete_Region_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Delete_Region_setRegion(cer_M_Ddm_Delete_Region_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
FILE* M_Ddm_Delete_Region_show(FILE* out) {
   fprintf(out,"[M_Ddm_Delete_Region -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"[M_Ddm_Delete_Region -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Delete_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Register_Object> ------------------------ */
cer_M_Ddm_Register_Object_t* 
cer_M_Ddm_Register_Object_create(uint32_t nb) {
   cer_M_Ddm_Register_Object_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Register_Object_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Register_Object; 
   cthis->super->type = M_DDM_REGISTER_OBJECT;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   _hasObjectInstanceName=0;
   /* objectInstanceName= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Register_Object_destroy(cer_M_Ddm_Register_Object_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Register_Object_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
   MB_write_bool(msgBuffer,_hasObjectInstanceName);
   if (_hasObjectInstanceName) {
      MB_write_string(msgBuffer,objectInstanceName);
   }
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Ddm_Register_Object_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   _hasObjectInstanceName = MB_read_bool(msgBuffer);
   if (_hasObjectInstanceName) {
      objectInstanceName = MB_read_string(msgBuffer);
   }
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Register_Object_getObjectClass(cer_M_Ddm_Register_Object_t* cthis)  {return cthis->objectClass;}
void cer_M_Ddm_Register_Object_setObjectClass(cer_M_Ddm_Register_Object_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Ddm_Register_Object_getObject(cer_M_Ddm_Register_Object_t* cthis)  {return cthis->object;}
void cer_M_Ddm_Register_Object_setObject(cer_M_Ddm_Register_Object_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Ddm_Register_Object_getObjectInstanceName(cer_M_Ddm_Register_Object_t* cthis)  {return cthis->objectInstanceName;}
void cer_M_Ddm_Register_Object_setObjectInstanceName(cer_M_Ddm_Register_Object_t* cthis,  char* newObjectInstanceName) {
   cthis->_hasObjectInstanceName=1;
   cthis->objectInstanceName=newObjectInstanceName;
}
uint8_t hasObjectInstanceName(cer_M_Ddm_Register_Object_t cthis) {return cthis->_hasObjectInstanceName;}
uint32_t cer_M_Ddm_Register_Object_getAttributesSize(cer_M_Ddm_Register_Object_t* cthis){ return cthis->attributessize;}
void cer_M_Ddm_Register_Object_setAttributesSize(cer_M_Ddm_Register_Object_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Ddm_Register_Object_getAttributes(cer_M_Ddm_Register_Object_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Ddm_Register_Object_setAttributes(cer_M_Ddm_Register_Object_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Ddm_Register_Object_show(FILE* out) {
   fprintf(out,"[M_Ddm_Register_Object -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"(opt) objectInstanceName =" + objectInstanceName + " "    + "\n");
   fflush(out)
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Ddm_Register_Object -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Register_Object> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Associate_Region> ------------------------ */
cer_M_Ddm_Associate_Region_t* 
cer_M_Ddm_Associate_Region_create(uint32_t nb) {
   cer_M_Ddm_Associate_Region_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Associate_Region_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Associate_Region; 
   cthis->super->type = M_DDM_ASSOCIATE_REGION;
   /* object= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Associate_Region_destroy(cer_M_Ddm_Associate_Region_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Associate_Region_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,region);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Ddm_Associate_Region_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Ddm_Associate_Region_getObject(cer_M_Ddm_Associate_Region_t* cthis)  {return cthis->object;}
void cer_M_Ddm_Associate_Region_setObject(cer_M_Ddm_Associate_Region_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_RegionHandle_t cer_M_Ddm_Associate_Region_getRegion(cer_M_Ddm_Associate_Region_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Associate_Region_setRegion(cer_M_Ddm_Associate_Region_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
uint32_t cer_M_Ddm_Associate_Region_getAttributesSize(cer_M_Ddm_Associate_Region_t* cthis){ return cthis->attributessize;}
void cer_M_Ddm_Associate_Region_setAttributesSize(cer_M_Ddm_Associate_Region_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Ddm_Associate_Region_getAttributes(cer_M_Ddm_Associate_Region_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Ddm_Associate_Region_setAttributes(cer_M_Ddm_Associate_Region_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Ddm_Associate_Region_show(FILE* out) {
   fprintf(out,"[M_Ddm_Associate_Region -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Ddm_Associate_Region -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Associate_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unassociate_Region> ------------------------ */
cer_M_Ddm_Unassociate_Region_t* 
cer_M_Ddm_Unassociate_Region_create(uint32_t nb) {
   cer_M_Ddm_Unassociate_Region_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Unassociate_Region_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Unassociate_Region; 
   cthis->super->type = M_DDM_UNASSOCIATE_REGION;
   /* object= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Unassociate_Region_destroy(cer_M_Ddm_Unassociate_Region_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Unassociate_Region_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_uint32(msgBuffer,region);
}

void M_Ddm_Unassociate_Region_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Ddm_Unassociate_Region_getObject(cer_M_Ddm_Unassociate_Region_t* cthis)  {return cthis->object;}
void cer_M_Ddm_Unassociate_Region_setObject(cer_M_Ddm_Unassociate_Region_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
cer_RegionHandle_t cer_M_Ddm_Unassociate_Region_getRegion(cer_M_Ddm_Unassociate_Region_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Unassociate_Region_setRegion(cer_M_Ddm_Unassociate_Region_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
FILE* M_Ddm_Unassociate_Region_show(FILE* out) {
   fprintf(out,"[M_Ddm_Unassociate_Region -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"[M_Ddm_Unassociate_Region -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Unassociate_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Subscribe_Attributes> ------------------------ */
cer_M_Ddm_Subscribe_Attributes_t* 
cer_M_Ddm_Subscribe_Attributes_create(uint32_t nb) {
   cer_M_Ddm_Subscribe_Attributes_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Subscribe_Attributes_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Subscribe_Attributes; 
   cthis->super->type = M_DDM_SUBSCRIBE_ATTRIBUTES;
   /* objectClass= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   /* passive= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Subscribe_Attributes_destroy(cer_M_Ddm_Subscribe_Attributes_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Subscribe_Attributes_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,region);
   MB_write_bool(msgBuffer,passive);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Ddm_Subscribe_Attributes_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   passive = MB_read_bool(msgBuffer);
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Subscribe_Attributes_getObjectClass(cer_M_Ddm_Subscribe_Attributes_t* cthis)  {return cthis->objectClass;}
void cer_M_Ddm_Subscribe_Attributes_setObjectClass(cer_M_Ddm_Subscribe_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_RegionHandle_t cer_M_Ddm_Subscribe_Attributes_getRegion(cer_M_Ddm_Subscribe_Attributes_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Subscribe_Attributes_setRegion(cer_M_Ddm_Subscribe_Attributes_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
void cer_M_Ddm_Subscribe_Attributes_passiveOn(cer_M_Ddm_Subscribe_Attributes_t* cthis) {cthis->passive = 1;}
void cer_M_Ddm_Subscribe_Attributes_passiveOff(cer_M_Ddm_Subscribe_Attributes_t* cthis) {cthis->passive = 0;}
uint8_t isPassiveOn(cer_M_Ddm_Subscribe_Attributes* cthis)  {return cthis->passive;}
uint32_t cer_M_Ddm_Subscribe_Attributes_getAttributesSize(cer_M_Ddm_Subscribe_Attributes_t* cthis){ return cthis->attributessize;}
void cer_M_Ddm_Subscribe_Attributes_setAttributesSize(cer_M_Ddm_Subscribe_Attributes_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Ddm_Subscribe_Attributes_getAttributes(cer_M_Ddm_Subscribe_Attributes_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Ddm_Subscribe_Attributes_setAttributes(cer_M_Ddm_Subscribe_Attributes_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Ddm_Subscribe_Attributes_show(FILE* out) {
   fprintf(out,"[M_Ddm_Subscribe_Attributes -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out," passive = " + passive + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Ddm_Subscribe_Attributes -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Subscribe_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unsubscribe_Attributes> ------------------------ */
cer_M_Ddm_Unsubscribe_Attributes_t* 
cer_M_Ddm_Unsubscribe_Attributes_create(uint32_t nb) {
   cer_M_Ddm_Unsubscribe_Attributes_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Unsubscribe_Attributes_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Unsubscribe_Attributes; 
   cthis->super->type = M_DDM_UNSUBSCRIBE_ATTRIBUTES;
   /* objectClass= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Unsubscribe_Attributes_destroy(cer_M_Ddm_Unsubscribe_Attributes_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Unsubscribe_Attributes_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,region);
}

void M_Ddm_Unsubscribe_Attributes_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Unsubscribe_Attributes_getObjectClass(cer_M_Ddm_Unsubscribe_Attributes_t* cthis)  {return cthis->objectClass;}
void cer_M_Ddm_Unsubscribe_Attributes_setObjectClass(cer_M_Ddm_Unsubscribe_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_RegionHandle_t cer_M_Ddm_Unsubscribe_Attributes_getRegion(cer_M_Ddm_Unsubscribe_Attributes_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Unsubscribe_Attributes_setRegion(cer_M_Ddm_Unsubscribe_Attributes_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
FILE* M_Ddm_Unsubscribe_Attributes_show(FILE* out) {
   fprintf(out,"[M_Ddm_Unsubscribe_Attributes -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"[M_Ddm_Unsubscribe_Attributes -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Unsubscribe_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Subscribe_Interaction> ------------------------ */
cer_M_Ddm_Subscribe_Interaction_t* 
cer_M_Ddm_Subscribe_Interaction_create(uint32_t nb) {
   cer_M_Ddm_Subscribe_Interaction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Subscribe_Interaction_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Subscribe_Interaction; 
   cthis->super->type = M_DDM_SUBSCRIBE_INTERACTION;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   /* passive= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Subscribe_Interaction_destroy(cer_M_Ddm_Subscribe_Interaction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Subscribe_Interaction_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_uint32(msgBuffer,region);
   MB_write_bool(msgBuffer,passive);
}

void M_Ddm_Subscribe_Interaction_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   passive = MB_read_bool(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Ddm_Subscribe_Interaction_getInteractionClass(cer_M_Ddm_Subscribe_Interaction_t* cthis)  {return cthis->interactionClass;}
void cer_M_Ddm_Subscribe_Interaction_setInteractionClass(cer_M_Ddm_Subscribe_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
cer_RegionHandle_t cer_M_Ddm_Subscribe_Interaction_getRegion(cer_M_Ddm_Subscribe_Interaction_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Subscribe_Interaction_setRegion(cer_M_Ddm_Subscribe_Interaction_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
void cer_M_Ddm_Subscribe_Interaction_passiveOn(cer_M_Ddm_Subscribe_Interaction_t* cthis) {cthis->passive = 1;}
void cer_M_Ddm_Subscribe_Interaction_passiveOff(cer_M_Ddm_Subscribe_Interaction_t* cthis) {cthis->passive = 0;}
uint8_t isPassiveOn(cer_M_Ddm_Subscribe_Interaction* cthis)  {return cthis->passive;}
FILE* M_Ddm_Subscribe_Interaction_show(FILE* out) {
   fprintf(out,"[M_Ddm_Subscribe_Interaction -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out," passive = " + passive + " "     + "\n");
   fprintf(out,"[M_Ddm_Subscribe_Interaction -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Subscribe_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unsubscribe_Interaction> ------------------------ */
cer_M_Ddm_Unsubscribe_Interaction_t* 
cer_M_Ddm_Unsubscribe_Interaction_create(uint32_t nb) {
   cer_M_Ddm_Unsubscribe_Interaction_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Unsubscribe_Interaction_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Unsubscribe_Interaction; 
   cthis->super->type = M_DDM_UNSUBSCRIBE_INTERACTION;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   /* passive= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Unsubscribe_Interaction_destroy(cer_M_Ddm_Unsubscribe_Interaction_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Unsubscribe_Interaction_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_uint32(msgBuffer,region);
   MB_write_bool(msgBuffer,passive);
}

void M_Ddm_Unsubscribe_Interaction_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   passive = MB_read_bool(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Ddm_Unsubscribe_Interaction_getInteractionClass(cer_M_Ddm_Unsubscribe_Interaction_t* cthis)  {return cthis->interactionClass;}
void cer_M_Ddm_Unsubscribe_Interaction_setInteractionClass(cer_M_Ddm_Unsubscribe_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
cer_RegionHandle_t cer_M_Ddm_Unsubscribe_Interaction_getRegion(cer_M_Ddm_Unsubscribe_Interaction_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Unsubscribe_Interaction_setRegion(cer_M_Ddm_Unsubscribe_Interaction_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
void cer_M_Ddm_Unsubscribe_Interaction_passiveOn(cer_M_Ddm_Unsubscribe_Interaction_t* cthis) {cthis->passive = 1;}
void cer_M_Ddm_Unsubscribe_Interaction_passiveOff(cer_M_Ddm_Unsubscribe_Interaction_t* cthis) {cthis->passive = 0;}
uint8_t isPassiveOn(cer_M_Ddm_Unsubscribe_Interaction* cthis)  {return cthis->passive;}
FILE* M_Ddm_Unsubscribe_Interaction_show(FILE* out) {
   fprintf(out,"[M_Ddm_Unsubscribe_Interaction -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out," passive = " + passive + " "     + "\n");
   fprintf(out,"[M_Ddm_Unsubscribe_Interaction -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Unsubscribe_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Request_Update> ------------------------ */
cer_M_Ddm_Request_Update_t* 
cer_M_Ddm_Request_Update_create(uint32_t nb) {
   cer_M_Ddm_Request_Update_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Ddm_Request_Update_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Ddm_Request_Update; 
   cthis->super->type = M_DDM_REQUEST_UPDATE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* region= <no default value in message spec using builtin>    */
   /* attributes= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Ddm_Request_Update_destroy(cer_M_Ddm_Request_Update_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Ddm_Request_Update_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,region);
   uint32_t attributesSize = attributessize;
   MB_write_uint32(msgBuffer,attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      MB_write_uint32(msgBuffer,attributes[i]);
   }
}

void M_Ddm_Request_Update_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   region = static_cast<RegionHandle>(MB_read_uint32(msgBuffer));
   uint32_t attributesSize = MB_read_uint32(msgBuffer);
   attributessize =attributesSize);
   for (uint32_t i = 0; i < attributesSize; ++i) {
      attributes[i] = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   }
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Request_Update_getObjectClass(cer_M_Ddm_Request_Update_t* cthis)  {return cthis->objectClass;}
void cer_M_Ddm_Request_Update_setObjectClass(cer_M_Ddm_Request_Update_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_RegionHandle_t cer_M_Ddm_Request_Update_getRegion(cer_M_Ddm_Request_Update_t* cthis)  {return cthis->region;}
void cer_M_Ddm_Request_Update_setRegion(cer_M_Ddm_Request_Update_t* cthis,  cer_RegionHandle_t newRegion) {cthis->region=newRegion;}
uint32_t cer_M_Ddm_Request_Update_getAttributesSize(cer_M_Ddm_Request_Update_t* cthis){ return cthis->attributessize;}
void cer_M_Ddm_Request_Update_setAttributesSize(cer_M_Ddm_Request_Update_t* cthis, uint32_t num) { 
   AttributeHandle* temp;
   temp = calloc(num,sizeof(AttributeHandle));
   memcpy(temp,cthis->attributes, cthis->attributessize);
   free(cthis->attributes);
   cthis->attributes = temp;
   cthis->attributessize = num;
}
cer_AttributeHandle_t cer_M_Ddm_Request_Update_getAttributes(cer_M_Ddm_Request_Update_t* cthis, uint32_t rank) {return cthis->attributes[rank];}
void cer_M_Ddm_Request_Update_setAttributes(cer_M_Ddm_Request_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank) {cthis->attributes[rank]=newAttributes;}
FILE* M_Ddm_Request_Update_show(FILE* out) {
   fprintf(out,"[M_Ddm_Request_Update -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," region = " + region + " "     + "\n");
   fprintf(out,"    attributes [] = 
");
   for (uint32_t i = 0; i < getAttributesSize(); ++i) {
      out + attributes[i] + " " ;
   }
   fprintf(out,"\n");
   fprintf(out,"[M_Ddm_Request_Update -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Ddm_Request_Update> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class_Handle> ------------------------ */
cer_M_Get_Object_Class_Handle_t* 
cer_M_Get_Object_Class_Handle_create(uint32_t nb) {
   cer_M_Get_Object_Class_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Object_Class_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Object_Class_Handle; 
   cthis->super->type = M_GET_OBJECT_CLASS_HANDLE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* className= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Object_Class_Handle_destroy(cer_M_Get_Object_Class_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Object_Class_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_string(msgBuffer,className);
}

void M_Get_Object_Class_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   className = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_Handle_getObjectClass(cer_M_Get_Object_Class_Handle_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Object_Class_Handle_setObjectClass(cer_M_Get_Object_Class_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
char* cer_M_Get_Object_Class_Handle_getClassName(cer_M_Get_Object_Class_Handle_t* cthis)  {return cthis->className;}
void cer_M_Get_Object_Class_Handle_setClassName(cer_M_Get_Object_Class_Handle_t* cthis,  char* newClassName) {cthis->className=newClassName;}
FILE* M_Get_Object_Class_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Object_Class_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," className = " + className + " "     + "\n");
   fprintf(out,"[M_Get_Object_Class_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Object_Class_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class_Name> ------------------------ */
cer_M_Get_Object_Class_Name_t* 
cer_M_Get_Object_Class_Name_create(uint32_t nb) {
   cer_M_Get_Object_Class_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Object_Class_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Object_Class_Name; 
   cthis->super->type = M_GET_OBJECT_CLASS_NAME;
   /* objectClass= <no default value in message spec using builtin>    */
   /* className= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Object_Class_Name_destroy(cer_M_Get_Object_Class_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Object_Class_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_string(msgBuffer,className);
}

void M_Get_Object_Class_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   className = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_Name_getObjectClass(cer_M_Get_Object_Class_Name_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Object_Class_Name_setObjectClass(cer_M_Get_Object_Class_Name_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
char* cer_M_Get_Object_Class_Name_getClassName(cer_M_Get_Object_Class_Name_t* cthis)  {return cthis->className;}
void cer_M_Get_Object_Class_Name_setClassName(cer_M_Get_Object_Class_Name_t* cthis,  char* newClassName) {cthis->className=newClassName;}
FILE* M_Get_Object_Class_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Object_Class_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," className = " + className + " "     + "\n");
   fprintf(out,"[M_Get_Object_Class_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Object_Class_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Handle> ------------------------ */
cer_M_Get_Attribute_Handle_t* 
cer_M_Get_Attribute_Handle_create(uint32_t nb) {
   cer_M_Get_Attribute_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Attribute_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Attribute_Handle; 
   cthis->super->type = M_GET_ATTRIBUTE_HANDLE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attributeName= <no default value in message spec using builtin>    */
   cer_AttributeHandle_t attribute=0;
   return newObj;
}

void cer_M_Get_Attribute_Handle_destroy(cer_M_Get_Attribute_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Attribute_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_string(msgBuffer,attributeName);
   MB_write_uint32(msgBuffer,attribute);
}

void M_Get_Attribute_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   attributeName = MB_read_string(msgBuffer);
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Handle_getObjectClass(cer_M_Get_Attribute_Handle_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Attribute_Handle_setObjectClass(cer_M_Get_Attribute_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
char* cer_M_Get_Attribute_Handle_getAttributeName(cer_M_Get_Attribute_Handle_t* cthis)  {return cthis->attributeName;}
void cer_M_Get_Attribute_Handle_setAttributeName(cer_M_Get_Attribute_Handle_t* cthis,  char* newAttributeName) {cthis->attributeName=newAttributeName;}
cer_AttributeHandle_t cer_M_Get_Attribute_Handle_getAttribute(cer_M_Get_Attribute_Handle_t* cthis)  {return cthis->attribute;}
void cer_M_Get_Attribute_Handle_setAttribute(cer_M_Get_Attribute_Handle_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
FILE* M_Get_Attribute_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Attribute_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," attributeName = " + attributeName + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out,"[M_Get_Attribute_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Attribute_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Name> ------------------------ */
cer_M_Get_Attribute_Name_t* 
cer_M_Get_Attribute_Name_create(uint32_t nb) {
   cer_M_Get_Attribute_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Attribute_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Attribute_Name; 
   cthis->super->type = M_GET_ATTRIBUTE_NAME;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attributeName= <no default value in message spec using builtin>    */
   cer_AttributeHandle_t attribute=0;
   return newObj;
}

void cer_M_Get_Attribute_Name_destroy(cer_M_Get_Attribute_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Attribute_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_string(msgBuffer,attributeName);
   MB_write_uint32(msgBuffer,attribute);
}

void M_Get_Attribute_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   attributeName = MB_read_string(msgBuffer);
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Name_getObjectClass(cer_M_Get_Attribute_Name_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Attribute_Name_setObjectClass(cer_M_Get_Attribute_Name_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
char* cer_M_Get_Attribute_Name_getAttributeName(cer_M_Get_Attribute_Name_t* cthis)  {return cthis->attributeName;}
void cer_M_Get_Attribute_Name_setAttributeName(cer_M_Get_Attribute_Name_t* cthis,  char* newAttributeName) {cthis->attributeName=newAttributeName;}
cer_AttributeHandle_t cer_M_Get_Attribute_Name_getAttribute(cer_M_Get_Attribute_Name_t* cthis)  {return cthis->attribute;}
void cer_M_Get_Attribute_Name_setAttribute(cer_M_Get_Attribute_Name_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
FILE* M_Get_Attribute_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Attribute_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," attributeName = " + attributeName + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out,"[M_Get_Attribute_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Attribute_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Class_Handle> ------------------------ */
cer_M_Get_Interaction_Class_Handle_t* 
cer_M_Get_Interaction_Class_Handle_create(uint32_t nb) {
   cer_M_Get_Interaction_Class_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Interaction_Class_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Interaction_Class_Handle; 
   cthis->super->type = M_GET_INTERACTION_CLASS_HANDLE;
   cer_InteractionClassHandle_t interactionClass=0;
   /* className= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Interaction_Class_Handle_destroy(cer_M_Get_Interaction_Class_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Interaction_Class_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_string(msgBuffer,className);
}

void M_Get_Interaction_Class_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   className = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Class_Handle_getInteractionClass(cer_M_Get_Interaction_Class_Handle_t* cthis)  {return cthis->interactionClass;}
void cer_M_Get_Interaction_Class_Handle_setInteractionClass(cer_M_Get_Interaction_Class_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
char* cer_M_Get_Interaction_Class_Handle_getClassName(cer_M_Get_Interaction_Class_Handle_t* cthis)  {return cthis->className;}
void cer_M_Get_Interaction_Class_Handle_setClassName(cer_M_Get_Interaction_Class_Handle_t* cthis,  char* newClassName) {cthis->className=newClassName;}
FILE* M_Get_Interaction_Class_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Interaction_Class_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," className = " + className + " "     + "\n");
   fprintf(out,"[M_Get_Interaction_Class_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Interaction_Class_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Class_Name> ------------------------ */
cer_M_Get_Interaction_Class_Name_t* 
cer_M_Get_Interaction_Class_Name_create(uint32_t nb) {
   cer_M_Get_Interaction_Class_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Interaction_Class_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Interaction_Class_Name; 
   cthis->super->type = M_GET_INTERACTION_CLASS_NAME;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* className= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Interaction_Class_Name_destroy(cer_M_Get_Interaction_Class_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Interaction_Class_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_string(msgBuffer,className);
}

void M_Get_Interaction_Class_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   className = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Class_Name_getInteractionClass(cer_M_Get_Interaction_Class_Name_t* cthis)  {return cthis->interactionClass;}
void cer_M_Get_Interaction_Class_Name_setInteractionClass(cer_M_Get_Interaction_Class_Name_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
char* cer_M_Get_Interaction_Class_Name_getClassName(cer_M_Get_Interaction_Class_Name_t* cthis)  {return cthis->className;}
void cer_M_Get_Interaction_Class_Name_setClassName(cer_M_Get_Interaction_Class_Name_t* cthis,  char* newClassName) {cthis->className=newClassName;}
FILE* M_Get_Interaction_Class_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Interaction_Class_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," className = " + className + " "     + "\n");
   fprintf(out,"[M_Get_Interaction_Class_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Interaction_Class_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Parameter_Handle> ------------------------ */
cer_M_Get_Parameter_Handle_t* 
cer_M_Get_Parameter_Handle_create(uint32_t nb) {
   cer_M_Get_Parameter_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Parameter_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Parameter_Handle; 
   cthis->super->type = M_GET_PARAMETER_HANDLE;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* parameterName= <no default value in message spec using builtin>    */
   cer_ParameterHandle_t parameter=0;
   return newObj;
}

void cer_M_Get_Parameter_Handle_destroy(cer_M_Get_Parameter_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Parameter_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_string(msgBuffer,parameterName);
   MB_write_uint32(msgBuffer,parameter);
}

void M_Get_Parameter_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   parameterName = MB_read_string(msgBuffer);
   parameter = static_cast<ParameterHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Parameter_Handle_getInteractionClass(cer_M_Get_Parameter_Handle_t* cthis)  {return cthis->interactionClass;}
void cer_M_Get_Parameter_Handle_setInteractionClass(cer_M_Get_Parameter_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
char* cer_M_Get_Parameter_Handle_getParameterName(cer_M_Get_Parameter_Handle_t* cthis)  {return cthis->parameterName;}
void cer_M_Get_Parameter_Handle_setParameterName(cer_M_Get_Parameter_Handle_t* cthis,  char* newParameterName) {cthis->parameterName=newParameterName;}
cer_ParameterHandle_t cer_M_Get_Parameter_Handle_getParameter(cer_M_Get_Parameter_Handle_t* cthis)  {return cthis->parameter;}
void cer_M_Get_Parameter_Handle_setParameter(cer_M_Get_Parameter_Handle_t* cthis,  cer_ParameterHandle_t newParameter) {cthis->parameter=newParameter;}
FILE* M_Get_Parameter_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Parameter_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," parameterName = " + parameterName + " "     + "\n");
   fprintf(out," parameter = " + parameter + " "     + "\n");
   fprintf(out,"[M_Get_Parameter_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Parameter_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Parameter_Name> ------------------------ */
cer_M_Get_Parameter_Name_t* 
cer_M_Get_Parameter_Name_create(uint32_t nb) {
   cer_M_Get_Parameter_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Parameter_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Parameter_Name; 
   cthis->super->type = M_GET_PARAMETER_NAME;
   /* interactionClass= <no default value in message spec using builtin>    */
   /* parameterName= <no default value in message spec using builtin>    */
   cer_ParameterHandle_t parameter=0;
   return newObj;
}

void cer_M_Get_Parameter_Name_destroy(cer_M_Get_Parameter_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Parameter_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_string(msgBuffer,parameterName);
   MB_write_uint32(msgBuffer,parameter);
}

void M_Get_Parameter_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   parameterName = MB_read_string(msgBuffer);
   parameter = static_cast<ParameterHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Parameter_Name_getInteractionClass(cer_M_Get_Parameter_Name_t* cthis)  {return cthis->interactionClass;}
void cer_M_Get_Parameter_Name_setInteractionClass(cer_M_Get_Parameter_Name_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
char* cer_M_Get_Parameter_Name_getParameterName(cer_M_Get_Parameter_Name_t* cthis)  {return cthis->parameterName;}
void cer_M_Get_Parameter_Name_setParameterName(cer_M_Get_Parameter_Name_t* cthis,  char* newParameterName) {cthis->parameterName=newParameterName;}
cer_ParameterHandle_t cer_M_Get_Parameter_Name_getParameter(cer_M_Get_Parameter_Name_t* cthis)  {return cthis->parameter;}
void cer_M_Get_Parameter_Name_setParameter(cer_M_Get_Parameter_Name_t* cthis,  cer_ParameterHandle_t newParameter) {cthis->parameter=newParameter;}
FILE* M_Get_Parameter_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Parameter_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," parameterName = " + parameterName + " "     + "\n");
   fprintf(out," parameter = " + parameter + " "     + "\n");
   fprintf(out,"[M_Get_Parameter_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Parameter_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Instance_Handle> ------------------------ */
cer_M_Get_Object_Instance_Handle_t* 
cer_M_Get_Object_Instance_Handle_create(uint32_t nb) {
   cer_M_Get_Object_Instance_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Object_Instance_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Object_Instance_Handle; 
   cthis->super->type = M_GET_OBJECT_INSTANCE_HANDLE;
   cer_ObjectHandle_t object=0;
   /* objectInstanceName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Object_Instance_Handle_destroy(cer_M_Get_Object_Instance_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Object_Instance_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_string(msgBuffer,objectInstanceName);
}

void M_Get_Object_Instance_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   objectInstanceName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Get_Object_Instance_Handle_getObject(cer_M_Get_Object_Instance_Handle_t* cthis)  {return cthis->object;}
void cer_M_Get_Object_Instance_Handle_setObject(cer_M_Get_Object_Instance_Handle_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Get_Object_Instance_Handle_getObjectInstanceName(cer_M_Get_Object_Instance_Handle_t* cthis)  {return cthis->objectInstanceName;}
void cer_M_Get_Object_Instance_Handle_setObjectInstanceName(cer_M_Get_Object_Instance_Handle_t* cthis,  char* newObjectInstanceName) {cthis->objectInstanceName=newObjectInstanceName;}
FILE* M_Get_Object_Instance_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Object_Instance_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," objectInstanceName = " + objectInstanceName + " "     + "\n");
   fprintf(out,"[M_Get_Object_Instance_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Object_Instance_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Instance_Name> ------------------------ */
cer_M_Get_Object_Instance_Name_t* 
cer_M_Get_Object_Instance_Name_create(uint32_t nb) {
   cer_M_Get_Object_Instance_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Object_Instance_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Object_Instance_Name; 
   cthis->super->type = M_GET_OBJECT_INSTANCE_NAME;
   /* object= <no default value in message spec using builtin>    */
   /* objectInstanceName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Object_Instance_Name_destroy(cer_M_Get_Object_Instance_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Object_Instance_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,object);
   MB_write_string(msgBuffer,objectInstanceName);
}

void M_Get_Object_Instance_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
   objectInstanceName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Get_Object_Instance_Name_getObject(cer_M_Get_Object_Instance_Name_t* cthis)  {return cthis->object;}
void cer_M_Get_Object_Instance_Name_setObject(cer_M_Get_Object_Instance_Name_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
char* cer_M_Get_Object_Instance_Name_getObjectInstanceName(cer_M_Get_Object_Instance_Name_t* cthis)  {return cthis->objectInstanceName;}
void cer_M_Get_Object_Instance_Name_setObjectInstanceName(cer_M_Get_Object_Instance_Name_t* cthis,  char* newObjectInstanceName) {cthis->objectInstanceName=newObjectInstanceName;}
FILE* M_Get_Object_Instance_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Object_Instance_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out," objectInstanceName = " + objectInstanceName + " "     + "\n");
   fprintf(out,"[M_Get_Object_Instance_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Object_Instance_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Space_Handle> ------------------------ */
cer_M_Get_Space_Handle_t* 
cer_M_Get_Space_Handle_create(uint32_t nb) {
   cer_M_Get_Space_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Space_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Space_Handle; 
   cthis->super->type = M_GET_SPACE_HANDLE;
   /* spaceName= <no default value in message spec using builtin>    */
   cer_SpaceHandle_t space=0;
   return newObj;
}

void cer_M_Get_Space_Handle_destroy(cer_M_Get_Space_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Space_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,spaceName);
   MB_write_uint32(msgBuffer,space);
}

void M_Get_Space_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   spaceName = MB_read_string(msgBuffer);
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Space_Handle_getSpaceName(cer_M_Get_Space_Handle_t* cthis)  {return cthis->spaceName;}
void cer_M_Get_Space_Handle_setSpaceName(cer_M_Get_Space_Handle_t* cthis,  char* newSpaceName) {cthis->spaceName=newSpaceName;}
cer_SpaceHandle_t cer_M_Get_Space_Handle_getSpace(cer_M_Get_Space_Handle_t* cthis)  {return cthis->space;}
void cer_M_Get_Space_Handle_setSpace(cer_M_Get_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
FILE* M_Get_Space_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Space_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," spaceName = " + spaceName + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out,"[M_Get_Space_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Space_Name> ------------------------ */
cer_M_Get_Space_Name_t* 
cer_M_Get_Space_Name_create(uint32_t nb) {
   cer_M_Get_Space_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Space_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Space_Name; 
   cthis->super->type = M_GET_SPACE_NAME;
   /* spaceName= <no default value in message spec using builtin>    */
   /* space= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Space_Name_destroy(cer_M_Get_Space_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Space_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,spaceName);
   MB_write_uint32(msgBuffer,space);
}

void M_Get_Space_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   spaceName = MB_read_string(msgBuffer);
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Space_Name_getSpaceName(cer_M_Get_Space_Name_t* cthis)  {return cthis->spaceName;}
void cer_M_Get_Space_Name_setSpaceName(cer_M_Get_Space_Name_t* cthis,  char* newSpaceName) {cthis->spaceName=newSpaceName;}
cer_SpaceHandle_t cer_M_Get_Space_Name_getSpace(cer_M_Get_Space_Name_t* cthis)  {return cthis->space;}
void cer_M_Get_Space_Name_setSpace(cer_M_Get_Space_Name_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
FILE* M_Get_Space_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Space_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," spaceName = " + spaceName + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out,"[M_Get_Space_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Space_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Dimension_Handle> ------------------------ */
cer_M_Get_Dimension_Handle_t* 
cer_M_Get_Dimension_Handle_create(uint32_t nb) {
   cer_M_Get_Dimension_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Dimension_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Dimension_Handle; 
   cthis->super->type = M_GET_DIMENSION_HANDLE;
   /* dimensionName= <no default value in message spec using builtin>    */
   /* space= <no default value in message spec using builtin>    */
   cer_DimensionHandle_t dimension=0;
   return newObj;
}

void cer_M_Get_Dimension_Handle_destroy(cer_M_Get_Dimension_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Dimension_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,dimensionName);
   MB_write_uint32(msgBuffer,space);
   MB_write_uint32(msgBuffer,dimension);
}

void M_Get_Dimension_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   dimensionName = MB_read_string(msgBuffer);
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
   dimension = static_cast<DimensionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Dimension_Handle_getDimensionName(cer_M_Get_Dimension_Handle_t* cthis)  {return cthis->dimensionName;}
void cer_M_Get_Dimension_Handle_setDimensionName(cer_M_Get_Dimension_Handle_t* cthis,  char* newDimensionName) {cthis->dimensionName=newDimensionName;}
cer_SpaceHandle_t cer_M_Get_Dimension_Handle_getSpace(cer_M_Get_Dimension_Handle_t* cthis)  {return cthis->space;}
void cer_M_Get_Dimension_Handle_setSpace(cer_M_Get_Dimension_Handle_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
cer_DimensionHandle_t cer_M_Get_Dimension_Handle_getDimension(cer_M_Get_Dimension_Handle_t* cthis)  {return cthis->dimension;}
void cer_M_Get_Dimension_Handle_setDimension(cer_M_Get_Dimension_Handle_t* cthis,  cer_DimensionHandle_t newDimension) {cthis->dimension=newDimension;}
FILE* M_Get_Dimension_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Dimension_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," dimensionName = " + dimensionName + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out," dimension = " + dimension + " "     + "\n");
   fprintf(out,"[M_Get_Dimension_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Dimension_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Dimension_Name> ------------------------ */
cer_M_Get_Dimension_Name_t* 
cer_M_Get_Dimension_Name_create(uint32_t nb) {
   cer_M_Get_Dimension_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Dimension_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Dimension_Name; 
   cthis->super->type = M_GET_DIMENSION_NAME;
   /* dimensionName= <no default value in message spec using builtin>    */
   /* space= <no default value in message spec using builtin>    */
   /* dimension= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Dimension_Name_destroy(cer_M_Get_Dimension_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Dimension_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,dimensionName);
   MB_write_uint32(msgBuffer,space);
   MB_write_uint32(msgBuffer,dimension);
}

void M_Get_Dimension_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   dimensionName = MB_read_string(msgBuffer);
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
   dimension = static_cast<DimensionHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Dimension_Name_getDimensionName(cer_M_Get_Dimension_Name_t* cthis)  {return cthis->dimensionName;}
void cer_M_Get_Dimension_Name_setDimensionName(cer_M_Get_Dimension_Name_t* cthis,  char* newDimensionName) {cthis->dimensionName=newDimensionName;}
cer_SpaceHandle_t cer_M_Get_Dimension_Name_getSpace(cer_M_Get_Dimension_Name_t* cthis)  {return cthis->space;}
void cer_M_Get_Dimension_Name_setSpace(cer_M_Get_Dimension_Name_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
cer_DimensionHandle_t cer_M_Get_Dimension_Name_getDimension(cer_M_Get_Dimension_Name_t* cthis)  {return cthis->dimension;}
void cer_M_Get_Dimension_Name_setDimension(cer_M_Get_Dimension_Name_t* cthis,  cer_DimensionHandle_t newDimension) {cthis->dimension=newDimension;}
FILE* M_Get_Dimension_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Dimension_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," dimensionName = " + dimensionName + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out," dimension = " + dimension + " "     + "\n");
   fprintf(out,"[M_Get_Dimension_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Dimension_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Space_Handle> ------------------------ */
cer_M_Get_Attribute_Space_Handle_t* 
cer_M_Get_Attribute_Space_Handle_create(uint32_t nb) {
   cer_M_Get_Attribute_Space_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Attribute_Space_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Attribute_Space_Handle; 
   cthis->super->type = M_GET_ATTRIBUTE_SPACE_HANDLE;
   /* objectClass= <no default value in message spec using builtin>    */
   /* attribute= <no default value in message spec using builtin>    */
   cer_SpaceHandle_t space=0;
   return newObj;
}

void cer_M_Get_Attribute_Space_Handle_destroy(cer_M_Get_Attribute_Space_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Attribute_Space_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,attribute);
   MB_write_uint32(msgBuffer,space);
}

void M_Get_Attribute_Space_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   attribute = static_cast<AttributeHandle>(MB_read_uint32(msgBuffer));
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Space_Handle_getObjectClass(cer_M_Get_Attribute_Space_Handle_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Attribute_Space_Handle_setObjectClass(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_AttributeHandle_t cer_M_Get_Attribute_Space_Handle_getAttribute(cer_M_Get_Attribute_Space_Handle_t* cthis)  {return cthis->attribute;}
void cer_M_Get_Attribute_Space_Handle_setAttribute(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_AttributeHandle_t newAttribute) {cthis->attribute=newAttribute;}
cer_SpaceHandle_t cer_M_Get_Attribute_Space_Handle_getSpace(cer_M_Get_Attribute_Space_Handle_t* cthis)  {return cthis->space;}
void cer_M_Get_Attribute_Space_Handle_setSpace(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
FILE* M_Get_Attribute_Space_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Attribute_Space_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," attribute = " + attribute + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out,"[M_Get_Attribute_Space_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Attribute_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class> ------------------------ */
cer_M_Get_Object_Class_t* 
cer_M_Get_Object_Class_create(uint32_t nb) {
   cer_M_Get_Object_Class_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Object_Class_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Object_Class; 
   cthis->super->type = M_GET_OBJECT_CLASS;
   /* objectClass= <no default value in message spec using builtin>    */
   /* object= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Object_Class_destroy(cer_M_Get_Object_Class_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Object_Class_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,objectClass);
   MB_write_uint32(msgBuffer,object);
}

void M_Get_Object_Class_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectClass = static_cast<ObjectClassHandle>(MB_read_uint32(msgBuffer));
   object = static_cast<ObjectHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_getObjectClass(cer_M_Get_Object_Class_t* cthis)  {return cthis->objectClass;}
void cer_M_Get_Object_Class_setObjectClass(cer_M_Get_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass) {cthis->objectClass=newObjectClass;}
cer_ObjectHandle_t cer_M_Get_Object_Class_getObject(cer_M_Get_Object_Class_t* cthis)  {return cthis->object;}
void cer_M_Get_Object_Class_setObject(cer_M_Get_Object_Class_t* cthis,  cer_ObjectHandle_t newObject) {cthis->object=newObject;}
FILE* M_Get_Object_Class_show(FILE* out) {
   fprintf(out,"[M_Get_Object_Class -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectClass = " + objectClass + " "     + "\n");
   fprintf(out," object = " + object + " "     + "\n");
   fprintf(out,"[M_Get_Object_Class -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Space_Handle> ------------------------ */
cer_M_Get_Interaction_Space_Handle_t* 
cer_M_Get_Interaction_Space_Handle_create(uint32_t nb) {
   cer_M_Get_Interaction_Space_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Interaction_Space_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Interaction_Space_Handle; 
   cthis->super->type = M_GET_INTERACTION_SPACE_HANDLE;
   /* interactionClass= <no default value in message spec using builtin>    */
   cer_SpaceHandle_t space=0;
   return newObj;
}

void cer_M_Get_Interaction_Space_Handle_destroy(cer_M_Get_Interaction_Space_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Interaction_Space_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,interactionClass);
   MB_write_uint32(msgBuffer,space);
}

void M_Get_Interaction_Space_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   interactionClass = static_cast<InteractionClassHandle>(MB_read_uint32(msgBuffer));
   space = static_cast<SpaceHandle>(MB_read_uint32(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Space_Handle_getInteractionClass(cer_M_Get_Interaction_Space_Handle_t* cthis)  {return cthis->interactionClass;}
void cer_M_Get_Interaction_Space_Handle_setInteractionClass(cer_M_Get_Interaction_Space_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass) {cthis->interactionClass=newInteractionClass;}
cer_SpaceHandle_t cer_M_Get_Interaction_Space_Handle_getSpace(cer_M_Get_Interaction_Space_Handle_t* cthis)  {return cthis->space;}
void cer_M_Get_Interaction_Space_Handle_setSpace(cer_M_Get_Interaction_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace) {cthis->space=newSpace;}
FILE* M_Get_Interaction_Space_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Interaction_Space_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," interactionClass = " + interactionClass + " "     + "\n");
   fprintf(out," space = " + space + " "     + "\n");
   fprintf(out,"[M_Get_Interaction_Space_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Interaction_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Transportation_Handle> ------------------------ */
cer_M_Get_Transportation_Handle_t* 
cer_M_Get_Transportation_Handle_create(uint32_t nb) {
   cer_M_Get_Transportation_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Transportation_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Transportation_Handle; 
   cthis->super->type = M_GET_TRANSPORTATION_HANDLE;
   /* transportationName= <no default value in message spec using builtin>    */
   cer_TransportType_t transportation=0;
   return newObj;
}

void cer_M_Get_Transportation_Handle_destroy(cer_M_Get_Transportation_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Transportation_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,transportationName);
   MB_write_uint8(msgBuffer,transportation);
}

void M_Get_Transportation_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   transportationName = MB_read_string(msgBuffer);
   transportation = static_cast<TransportType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Transportation_Handle_getTransportationName(cer_M_Get_Transportation_Handle_t* cthis)  {return cthis->transportationName;}
void cer_M_Get_Transportation_Handle_setTransportationName(cer_M_Get_Transportation_Handle_t* cthis,  char* newTransportationName) {cthis->transportationName=newTransportationName;}
cer_TransportType_t cer_M_Get_Transportation_Handle_getTransportation(cer_M_Get_Transportation_Handle_t* cthis)  {return cthis->transportation;}
void cer_M_Get_Transportation_Handle_setTransportation(cer_M_Get_Transportation_Handle_t* cthis,  cer_TransportType_t newTransportation) {cthis->transportation=newTransportation;}
FILE* M_Get_Transportation_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Transportation_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," transportationName = " + transportationName + " "     + "\n");
   fprintf(out," transportation = " + transportation + " "     + "\n");
   fprintf(out,"[M_Get_Transportation_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Transportation_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Transportation_Name> ------------------------ */
cer_M_Get_Transportation_Name_t* 
cer_M_Get_Transportation_Name_create(uint32_t nb) {
   cer_M_Get_Transportation_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Transportation_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Transportation_Name; 
   cthis->super->type = M_GET_TRANSPORTATION_NAME;
   /* transportationName= <no default value in message spec using builtin>    */
   /* transportation= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Transportation_Name_destroy(cer_M_Get_Transportation_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Transportation_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,transportationName);
   MB_write_uint8(msgBuffer,transportation);
}

void M_Get_Transportation_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   transportationName = MB_read_string(msgBuffer);
   transportation = static_cast<TransportType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Transportation_Name_getTransportationName(cer_M_Get_Transportation_Name_t* cthis)  {return cthis->transportationName;}
void cer_M_Get_Transportation_Name_setTransportationName(cer_M_Get_Transportation_Name_t* cthis,  char* newTransportationName) {cthis->transportationName=newTransportationName;}
cer_TransportType_t cer_M_Get_Transportation_Name_getTransportation(cer_M_Get_Transportation_Name_t* cthis)  {return cthis->transportation;}
void cer_M_Get_Transportation_Name_setTransportation(cer_M_Get_Transportation_Name_t* cthis,  cer_TransportType_t newTransportation) {cthis->transportation=newTransportation;}
FILE* M_Get_Transportation_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Transportation_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," transportationName = " + transportationName + " "     + "\n");
   fprintf(out," transportation = " + transportation + " "     + "\n");
   fprintf(out,"[M_Get_Transportation_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Transportation_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Ordering_Handle> ------------------------ */
cer_M_Get_Ordering_Handle_t* 
cer_M_Get_Ordering_Handle_create(uint32_t nb) {
   cer_M_Get_Ordering_Handle_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Ordering_Handle_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Ordering_Handle; 
   cthis->super->type = M_GET_ORDERING_HANDLE;
   /* orderingName= <no default value in message spec using builtin>    */
   cer_OrderType_t ordering=0;
   return newObj;
}

void cer_M_Get_Ordering_Handle_destroy(cer_M_Get_Ordering_Handle_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Ordering_Handle_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,orderingName);
   MB_write_uint8(msgBuffer,ordering);
}

void M_Get_Ordering_Handle_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   orderingName = MB_read_string(msgBuffer);
   ordering = static_cast<OrderType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Ordering_Handle_getOrderingName(cer_M_Get_Ordering_Handle_t* cthis)  {return cthis->orderingName;}
void cer_M_Get_Ordering_Handle_setOrderingName(cer_M_Get_Ordering_Handle_t* cthis,  char* newOrderingName) {cthis->orderingName=newOrderingName;}
cer_OrderType_t cer_M_Get_Ordering_Handle_getOrdering(cer_M_Get_Ordering_Handle_t* cthis)  {return cthis->ordering;}
void cer_M_Get_Ordering_Handle_setOrdering(cer_M_Get_Ordering_Handle_t* cthis,  cer_OrderType_t newOrdering) {cthis->ordering=newOrdering;}
FILE* M_Get_Ordering_Handle_show(FILE* out) {
   fprintf(out,"[M_Get_Ordering_Handle -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," orderingName = " + orderingName + " "     + "\n");
   fprintf(out," ordering = " + ordering + " "     + "\n");
   fprintf(out,"[M_Get_Ordering_Handle -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Ordering_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Ordering_Name> ------------------------ */
cer_M_Get_Ordering_Name_t* 
cer_M_Get_Ordering_Name_create(uint32_t nb) {
   cer_M_Get_Ordering_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Get_Ordering_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Get_Ordering_Name; 
   cthis->super->type = M_GET_ORDERING_NAME;
   /* orderingName= <no default value in message spec using builtin>    */
   /* ordering= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Get_Ordering_Name_destroy(cer_M_Get_Ordering_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Get_Ordering_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,orderingName);
   MB_write_uint8(msgBuffer,ordering);
}

void M_Get_Ordering_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   orderingName = MB_read_string(msgBuffer);
   ordering = static_cast<OrderType>(MB_read_uint8(msgBuffer));
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Ordering_Name_getOrderingName(cer_M_Get_Ordering_Name_t* cthis)  {return cthis->orderingName;}
void cer_M_Get_Ordering_Name_setOrderingName(cer_M_Get_Ordering_Name_t* cthis,  char* newOrderingName) {cthis->orderingName=newOrderingName;}
cer_OrderType_t cer_M_Get_Ordering_Name_getOrdering(cer_M_Get_Ordering_Name_t* cthis)  {return cthis->ordering;}
void cer_M_Get_Ordering_Name_setOrdering(cer_M_Get_Ordering_Name_t* cthis,  cer_OrderType_t newOrdering) {cthis->ordering=newOrdering;}
FILE* M_Get_Ordering_Name_show(FILE* out) {
   fprintf(out,"[M_Get_Ordering_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," orderingName = " + orderingName + " "     + "\n");
   fprintf(out," ordering = " + ordering + " "     + "\n");
   fprintf(out,"[M_Get_Ordering_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Get_Ordering_Name> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Class_Relevance_Advisory_Switch> ------------------------ */
cer_M_Enable_Class_Relevance_Advisory_Switch_t* 
cer_M_Enable_Class_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Enable_Class_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Class_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Class_Relevance_Advisory_Switch; 
   cthis->super->type = M_ENABLE_CLASS_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Enable_Class_Relevance_Advisory_Switch_destroy(cer_M_Enable_Class_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Class_Relevance_Advisory_Switch> ------------------------ */
cer_M_Disable_Class_Relevance_Advisory_Switch_t* 
cer_M_Disable_Class_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Disable_Class_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Class_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Class_Relevance_Advisory_Switch; 
   cthis->super->type = M_DISABLE_CLASS_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Disable_Class_Relevance_Advisory_Switch_destroy(cer_M_Disable_Class_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Enable_Attribute_Relevance_Advisory_Switch> ------------------------ */
cer_M_Enable_Attribute_Relevance_Advisory_Switch_t* 
cer_M_Enable_Attribute_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Enable_Attribute_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Attribute_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Attribute_Relevance_Advisory_Switch; 
   cthis->super->type = M_ENABLE_ATTRIBUTE_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Enable_Attribute_Relevance_Advisory_Switch_destroy(cer_M_Enable_Attribute_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Attribute_Relevance_Advisory_Switch> ------------------------ */
cer_M_Disable_Attribute_Relevance_Advisory_Switch_t* 
cer_M_Disable_Attribute_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Disable_Attribute_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Attribute_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Attribute_Relevance_Advisory_Switch; 
   cthis->super->type = M_DISABLE_ATTRIBUTE_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Disable_Attribute_Relevance_Advisory_Switch_destroy(cer_M_Disable_Attribute_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Enable_Attribute_Scope_Advisory_Switch> ------------------------ */
cer_M_Enable_Attribute_Scope_Advisory_Switch_t* 
cer_M_Enable_Attribute_Scope_Advisory_Switch_create(uint32_t nb) {
   cer_M_Enable_Attribute_Scope_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Attribute_Scope_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Attribute_Scope_Advisory_Switch; 
   cthis->super->type = M_ENABLE_ATTRIBUTE_SCOPE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Enable_Attribute_Scope_Advisory_Switch_destroy(cer_M_Enable_Attribute_Scope_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Attribute_Scope_Advisory_Switch> ------------------------ */
cer_M_Disable_Attribute_Scope_Advisory_Switch_t* 
cer_M_Disable_Attribute_Scope_Advisory_Switch_create(uint32_t nb) {
   cer_M_Disable_Attribute_Scope_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Attribute_Scope_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Attribute_Scope_Advisory_Switch; 
   cthis->super->type = M_DISABLE_ATTRIBUTE_SCOPE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Disable_Attribute_Scope_Advisory_Switch_destroy(cer_M_Disable_Attribute_Scope_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Enable_Interaction_Relevance_Advisory_Switch> ------------------------ */
cer_M_Enable_Interaction_Relevance_Advisory_Switch_t* 
cer_M_Enable_Interaction_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Enable_Interaction_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Enable_Interaction_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Enable_Interaction_Relevance_Advisory_Switch; 
   cthis->super->type = M_ENABLE_INTERACTION_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Enable_Interaction_Relevance_Advisory_Switch_destroy(cer_M_Enable_Interaction_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Disable_Interaction_Relevance_Advisory_Switch> ------------------------ */
cer_M_Disable_Interaction_Relevance_Advisory_Switch_t* 
cer_M_Disable_Interaction_Relevance_Advisory_Switch_create(uint32_t nb) {
   cer_M_Disable_Interaction_Relevance_Advisory_Switch_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Disable_Interaction_Relevance_Advisory_Switch_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Disable_Interaction_Relevance_Advisory_Switch; 
   cthis->super->type = M_DISABLE_INTERACTION_RELEVANCE_ADVISORY_SWITCH;
   return newObj;
}

void cer_M_Disable_Interaction_Relevance_Advisory_Switch_destroy(cer_M_Disable_Interaction_Relevance_Advisory_Switch_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Tick_Request> ------------------------ */
cer_M_Tick_Request_t* 
cer_M_Tick_Request_create(uint32_t nb) {
   cer_M_Tick_Request_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Tick_Request_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Tick_Request; 
   cthis->super->type = M_TICK_REQUEST;
   /* multiple= <no default value in message spec using builtin>    */
   /* minTickTime= <no default value in message spec using builtin>    */
   /* maxTickTime= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Tick_Request_destroy(cer_M_Tick_Request_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Tick_Request_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_bool(msgBuffer,multiple);
   MB_write_double(msgBuffer,minTickTime);
   MB_write_double(msgBuffer,maxTickTime);
}

void M_Tick_Request_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   multiple = MB_read_bool(msgBuffer);
   minTickTime = MB_read_double(msgBuffer);
   maxTickTime = MB_read_double(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
uint8_t cer_M_Tick_Request_getMultiple(cer_M_Tick_Request_t* cthis)  {return cthis->multiple;}
void cer_M_Tick_Request_setMultiple(cer_M_Tick_Request_t* cthis,  uint8_t newMultiple) {cthis->multiple=newMultiple;}
double cer_M_Tick_Request_getMinTickTime(cer_M_Tick_Request_t* cthis)  {return cthis->minTickTime;}
void cer_M_Tick_Request_setMinTickTime(cer_M_Tick_Request_t* cthis,  double newMinTickTime) {cthis->minTickTime=newMinTickTime;}
double cer_M_Tick_Request_getMaxTickTime(cer_M_Tick_Request_t* cthis)  {return cthis->maxTickTime;}
void cer_M_Tick_Request_setMaxTickTime(cer_M_Tick_Request_t* cthis,  double newMaxTickTime) {cthis->maxTickTime=newMaxTickTime;}
FILE* M_Tick_Request_show(FILE* out) {
   fprintf(out,"[M_Tick_Request -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," multiple = " + multiple + " "     + "\n");
   fprintf(out," minTickTime = " + minTickTime + " "     + "\n");
   fprintf(out," maxTickTime = " + maxTickTime + " "     + "\n");
   fprintf(out,"[M_Tick_Request -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Tick_Request> ------------------------ */

/* ---------------------- BEGIN <M_Tick_Request_Next> ------------------------ */
cer_M_Tick_Request_Next_t* 
cer_M_Tick_Request_Next_create(uint32_t nb) {
   cer_M_Tick_Request_Next_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Tick_Request_Next_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Tick_Request_Next; 
   cthis->super->type = M_TICK_REQUEST_NEXT;
   return newObj;
}

void cer_M_Tick_Request_Next_destroy(cer_M_Tick_Request_Next_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Tick_Request_Stop> ------------------------ */
cer_M_Tick_Request_Stop_t* 
cer_M_Tick_Request_Stop_create(uint32_t nb) {
   cer_M_Tick_Request_Stop_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Tick_Request_Stop_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Tick_Request_Stop; 
   cthis->super->type = M_TICK_REQUEST_STOP;
   return newObj;
}

void cer_M_Tick_Request_Stop_destroy(cer_M_Tick_Request_Stop_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name> ------------------------ */
cer_M_Reserve_Object_Instance_Name_t* 
cer_M_Reserve_Object_Instance_Name_create(uint32_t nb) {
   cer_M_Reserve_Object_Instance_Name_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Reserve_Object_Instance_Name_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Reserve_Object_Instance_Name; 
   cthis->super->type = M_RESERVE_OBJECT_INSTANCE_NAME;
   /* objectName= <no default value in message spec using builtin>    */
   return newObj;
}

void cer_M_Reserve_Object_Instance_Name_destroy(cer_M_Reserve_Object_Instance_Name_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void M_Reserve_Object_Instance_Name_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,objectName);
}

void M_Reserve_Object_Instance_Name_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   objectName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
char* cer_M_Reserve_Object_Instance_Name_getObjectName(cer_M_Reserve_Object_Instance_Name_t* cthis)  {return cthis->objectName;}
void cer_M_Reserve_Object_Instance_Name_setObjectName(cer_M_Reserve_Object_Instance_Name_t* cthis,  char* newObjectName) {cthis->objectName=newObjectName;}
FILE* M_Reserve_Object_Instance_Name_show(FILE* out) {
   fprintf(out,"[M_Reserve_Object_Instance_Name -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," objectName = " + objectName + " "     + "\n");
   fprintf(out,"[M_Reserve_Object_Instance_Name -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <M_Reserve_Object_Instance_Name> ------------------------ */

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name_Succeeded> ------------------------ */
cer_M_Reserve_Object_Instance_Name_Succeeded_t* 
cer_M_Reserve_Object_Instance_Name_Succeeded_create(uint32_t nb) {
   cer_M_Reserve_Object_Instance_Name_Succeeded_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Reserve_Object_Instance_Name_Succeeded_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Reserve_Object_Instance_Name_Succeeded; 
   cthis->super->type = M_RESERVE_OBJECT_INSTANCE_NAME_SUCCEEDED;
   return newObj;
}

void cer_M_Reserve_Object_Instance_Name_Succeeded_destroy(cer_M_Reserve_Object_Instance_Name_Succeeded_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name_Failed> ------------------------ */
cer_M_Reserve_Object_Instance_Name_Failed_t* 
cer_M_Reserve_Object_Instance_Name_Failed_create(uint32_t nb) {
   cer_M_Reserve_Object_Instance_Name_Failed_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(cer_M_Reserve_Object_Instance_Name_Failed_t));
   assert(newObj!=NULL);
   cthis->super->messageName = M_Reserve_Object_Instance_Name_Failed; 
   cthis->super->type = M_RESERVE_OBJECT_INSTANCE_NAME_FAILED;
   return newObj;
}

void cer_M_Reserve_Object_Instance_Name_Failed_destroy(cer_M_Reserve_Object_Instance_Name_Failed_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

Message* M_Factory_create(M_Type type){ 
   Message* msg = NULL;

   switch (type) {
      case Message_NOT_USED:
         return -1; /* value NOT_USED may not be used*/
         break;
      case Message_M_OPEN_CONNEXION:
         msg = new M_Open_Connexion();
         break;
      case Message_M_CLOSE_CONNEXION:
         msg = new M_Close_Connexion();
         break;
      case Message_M_CREATE_FEDERATION_EXECUTION:
         msg = new M_Create_Federation_Execution();
         break;
      case Message_M_DESTROY_FEDERATION_EXECUTION:
         msg = new M_Destroy_Federation_Execution();
         break;
      case Message_M_JOIN_FEDERATION_EXECUTION:
         msg = new M_Join_Federation_Execution();
         break;
      case Message_M_RESIGN_FEDERATION_EXECUTION:
         msg = new M_Resign_Federation_Execution();
         break;
      case Message_M_REGISTER_FEDERATION_SYNCHRONIZATION_POINT:
         msg = new M_Register_Federation_Synchronization_Point();
         break;
      case Message_M_SYNCHRONIZATION_POINT_REGISTRATION_FAILED:
         msg = new M_Synchronization_Point_Registration_Failed();
         break;
      case Message_M_SYNCHRONIZATION_POINT_REGISTRATION_SUCCEEDED:
         msg = new M_Synchronization_Point_Registration_Succeeded();
         break;
      case Message_M_ANNOUNCE_SYNCHRONIZATION_POINT:
         msg = new M_Announce_Synchronization_Point();
         break;
      case Message_M_SYNCHRONIZATION_POINT_ACHIEVED:
         msg = new M_Synchronization_Point_Achieved();
         break;
      case Message_M_FEDERATION_SYNCHRONIZED:
         msg = new M_Federation_Synchronized();
         break;
      case Message_M_REQUEST_FEDERATION_SAVE:
         msg = new M_Request_Federation_Save();
         break;
      case Message_M_INITIATE_FEDERATE_SAVE:
         msg = new M_Initiate_Federate_Save();
         break;
      case Message_M_FEDERATE_SAVE_BEGUN:
         msg = new M_Federate_Save_Begun();
         break;
      case Message_M_FEDERATE_SAVE_COMPLETE:
         msg = new M_Federate_Save_Complete();
         break;
      case Message_M_FEDERATE_SAVE_NOT_COMPLETE:
         msg = new M_Federate_Save_Not_Complete();
         break;
      case Message_M_FEDERATION_SAVED:
         msg = new M_Federation_Saved();
         break;
      case Message_M_FEDERATION_NOT_SAVED:
         msg = new M_Federation_Not_Saved();
         break;
      case Message_M_REQUEST_FEDERATION_RESTORE:
         msg = new M_Request_Federation_Restore();
         break;
      case Message_M_REQUEST_FEDERATION_RESTORE_FAILED:
         msg = new M_Request_Federation_Restore_Failed();
         break;
      case Message_M_REQUEST_FEDERATION_RESTORE_SUCCEEDED:
         msg = new M_Request_Federation_Restore_Succeeded();
         break;
      case Message_M_INITIATE_FEDERATE_RESTORE:
         msg = new M_Initiate_Federate_Restore();
         break;
      case Message_M_FEDERATE_RESTORE_COMPLETE:
         msg = new M_Federate_Restore_Complete();
         break;
      case Message_M_FEDERATE_RESTORE_NOT_COMPLETE:
         msg = new M_Federate_Restore_Not_Complete();
         break;
      case Message_M_FEDERATION_RESTORED:
         msg = new M_Federation_Restored();
         break;
      case Message_M_FEDERATION_NOT_RESTORED:
         msg = new M_Federation_Not_Restored();
         break;
      case Message_M_FEDERATION_RESTORE_BEGUN:
         msg = new M_Federation_Restore_Begun();
         break;
      case Message_M_PUBLISH_OBJECT_CLASS:
         msg = new M_Publish_Object_Class();
         break;
      case Message_M_UNPUBLISH_OBJECT_CLASS:
         msg = new M_Unpublish_Object_Class();
         break;
      case Message_M_PUBLISH_INTERACTION_CLASS:
         msg = new M_Publish_Interaction_Class();
         break;
      case Message_M_UNPUBLISH_INTERACTION_CLASS:
         msg = new M_Unpublish_Interaction_Class();
         break;
      case Message_M_SUBSCRIBE_OBJECT_CLASS_ATTRIBUTES:
         msg = new M_Subscribe_Object_Class_Attributes();
         break;
      case Message_M_UNSUBSCRIBE_OBJECT_CLASS:
         msg = new M_Unsubscribe_Object_Class();
         break;
      case Message_M_SUBSCRIBE_INTERACTION_CLASS:
         msg = new M_Subscribe_Interaction_Class();
         break;
      case Message_M_UNSUBSCRIBE_INTERACTION_CLASS:
         msg = new M_Unsubscribe_Interaction_Class();
         break;
      case Message_M_START_REGISTRATION_FOR_OBJECT_CLASS:
         msg = new M_Start_Registration_For_Object_Class();
         break;
      case Message_M_STOP_REGISTRATION_FOR_OBJECT_CLASS:
         msg = new M_Stop_Registration_For_Object_Class();
         break;
      case Message_M_TURN_INTERACTIONS_ON:
         msg = new M_Turn_Interactions_On();
         break;
      case Message_M_TURN_INTERACTIONS_OFF:
         msg = new M_Turn_Interactions_Off();
         break;
      case Message_M_REGISTER_OBJECT_INSTANCE:
         msg = new M_Register_Object_Instance();
         break;
      case Message_M_UPDATE_ATTRIBUTE_VALUES:
         msg = new M_Update_Attribute_Values();
         break;
      case Message_M_DISCOVER_OBJECT_INSTANCE:
         msg = new M_Discover_Object_Instance();
         break;
      case Message_M_REFLECT_ATTRIBUTE_VALUES:
         msg = new M_Reflect_Attribute_Values();
         break;
      case Message_M_SEND_INTERACTION:
         msg = new M_Send_Interaction();
         break;
      case Message_M_RECEIVE_INTERACTION:
         msg = new M_Receive_Interaction();
         break;
      case Message_M_DELETE_OBJECT_INSTANCE:
         msg = new M_Delete_Object_Instance();
         break;
      case Message_M_LOCAL_DELETE_OBJECT_INSTANCE:
         msg = new M_Local_Delete_Object_Instance();
         break;
      case Message_M_REMOVE_OBJECT_INSTANCE:
         msg = new M_Remove_Object_Instance();
         break;
      case Message_M_CHANGE_ATTRIBUTE_TRANSPORTATION_TYPE:
         msg = new M_Change_Attribute_Transportation_Type();
         break;
      case Message_M_CHANGE_INTERACTION_TRANSPORTATION_TYPE:
         msg = new M_Change_Interaction_Transportation_Type();
         break;
      case Message_M_REQUEST_OBJECT_ATTRIBUTE_VALUE_UPDATE:
         msg = new M_Request_Object_Attribute_Value_Update();
         break;
      case Message_M_REQUEST_CLASS_ATTRIBUTE_VALUE_UPDATE:
         msg = new M_Request_Class_Attribute_Value_Update();
         break;
      case Message_M_PROVIDE_ATTRIBUTE_VALUE_UPDATE:
         msg = new M_Provide_Attribute_Value_Update();
         break;
      case Message_M_ATTRIBUTES_IN_SCOPE:
         msg = new M_Attributes_In_Scope();
         break;
      case Message_M_ATTRIBUTES_OUT_OF_SCOPE:
         msg = new M_Attributes_Out_Of_Scope();
         break;
      case Message_M_TURN_UPDATES_ON_FOR_OBJECT_INSTANCE:
         msg = new M_Turn_Updates_On_For_Object_Instance();
         break;
      case Message_M_TURN_UPDATES_OFF_FOR_OBJECT_INSTANCE:
         msg = new M_Turn_Updates_Off_For_Object_Instance();
         break;
      case Message_M_REQUEST_ATTRIBUTE_OWNERSHIP_DIVESTITURE:
         msg = new M_Request_Attribute_Ownership_Divestiture();
         break;
      case Message_M_REQUEST_ATTRIBUTE_OWNERSHIP_ASSUMPTION:
         msg = new M_Request_Attribute_Ownership_Assumption();
         break;
      case Message_M_NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE:
         msg = new M_Negotiated_Attribute_Ownership_Divestiture();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_DIVESTITURE_NOTIFICATION:
         msg = new M_Attribute_Ownership_Divestiture_Notification();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_ACQUISITION_NOTIFICATION:
         msg = new M_Attribute_Ownership_Acquisition_Notification();
         break;
      case Message_M_REQUEST_ATTRIBUTE_OWNERSHIP_ACQUISITION:
         msg = new M_Request_Attribute_Ownership_Acquisition();
         break;
      case Message_M_REQUEST_ATTRIBUTE_OWNERSHIP_RELEASE:
         msg = new M_Request_Attribute_Ownership_Release();
         break;
      case Message_M_QUERY_ATTRIBUTE_OWNERSHIP:
         msg = new M_Query_Attribute_Ownership();
         break;
      case Message_M_INFORM_ATTRIBUTE_OWNERSHIP:
         msg = new M_Inform_Attribute_Ownership();
         break;
      case Message_M_IS_ATTRIBUTE_OWNED_BY_FEDERATE:
         msg = new M_Is_Attribute_Owned_By_Federate();
         break;
      case Message_M_ATTRIBUTE_IS_NOT_OWNED:
         msg = new M_Attribute_Is_Not_Owned();
         break;
      case Message_M_ATTRIBUTE_OWNED_BY_RTI:
         msg = new M_Attribute_Owned_By_Rti();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_ACQUISITION_IF_AVAILABLE:
         msg = new M_Attribute_Ownership_Acquisition_If_Available();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_UNAVAILABLE:
         msg = new M_Attribute_Ownership_Unavailable();
         break;
      case Message_M_UNCONDITIONAL_ATTRIBUTE_OWNERSHIP_DIVESTITURE:
         msg = new M_Unconditional_Attribute_Ownership_Divestiture();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_ACQUISITION:
         msg = new M_Attribute_Ownership_Acquisition();
         break;
      case Message_M_CANCEL_NEGOTIATED_ATTRIBUTE_OWNERSHIP_DIVESTITURE:
         msg = new M_Cancel_Negotiated_Attribute_Ownership_Divestiture();
         break;
      case Message_M_ATTRIBUTE_OWNERSHIP_RELEASE_RESPONSE:
         msg = new M_Attribute_Ownership_Release_Response();
         break;
      case Message_M_CANCEL_ATTRIBUTE_OWNERSHIP_ACQUISITION:
         msg = new M_Cancel_Attribute_Ownership_Acquisition();
         break;
      case Message_M_CONFIRM_ATTRIBUTE_OWNERSHIP_ACQUISITION_CANCELLATION:
         msg = new M_Confirm_Attribute_Ownership_Acquisition_Cancellation();
         break;
      case Message_M_CHANGE_ATTRIBUTE_ORDER_TYPE:
         msg = new M_Change_Attribute_Order_Type();
         break;
      case Message_M_CHANGE_INTERACTION_ORDER_TYPE:
         msg = new M_Change_Interaction_Order_Type();
         break;
      case Message_M_ENABLE_TIME_REGULATION:
         msg = new M_Enable_Time_Regulation();
         break;
      case Message_M_DISABLE_TIME_REGULATION:
         msg = new M_Disable_Time_Regulation();
         break;
      case Message_M_ENABLE_TIME_CONSTRAINED:
         msg = new M_Enable_Time_Constrained();
         break;
      case Message_M_DISABLE_TIME_CONSTRAINED:
         msg = new M_Disable_Time_Constrained();
         break;
      case Message_M_QUERY_LBTS:
         msg = new M_Query_Lbts();
         break;
      case Message_M_QUERY_FEDERATE_TIME:
         msg = new M_Query_Federate_Time();
         break;
      case Message_M_QUERY_MIN_NEXT_EVENT_TIME:
         msg = new M_Query_Min_Next_Event_Time();
         break;
      case Message_M_MODIFY_LOOKAHEAD:
         msg = new M_Modify_Lookahead();
         break;
      case Message_M_QUERY_LOOKAHEAD:
         msg = new M_Query_Lookahead();
         break;
      case Message_M_RETRACT:
         msg = new M_Retract();
         break;
      case Message_M_REQUEST_RETRACTION:
         msg = new M_Request_Retraction();
         break;
      case Message_M_TIME_ADVANCE_REQUEST:
         msg = new M_Time_Advance_Request();
         break;
      case Message_M_TIME_ADVANCE_REQUEST_AVAILABLE:
         msg = new M_Time_Advance_Request_Available();
         break;
      case Message_M_NEXT_EVENT_REQUEST:
         msg = new M_Next_Event_Request();
         break;
      case Message_M_NEXT_EVENT_REQUEST_AVAILABLE:
         msg = new M_Next_Event_Request_Available();
         break;
      case Message_M_FLUSH_QUEUE_REQUEST:
         msg = new M_Flush_Queue_Request();
         break;
      case Message_M_TIME_ADVANCE_GRANT:
         msg = new M_Time_Advance_Grant();
         break;
      case Message_M_ENABLE_ASYNCHRONOUS_DELIVERY:
         msg = new M_Enable_Asynchronous_Delivery();
         break;
      case Message_M_DISABLE_ASYNCHRONOUS_DELIVERY:
         msg = new M_Disable_Asynchronous_Delivery();
         break;
      case Message_M_TIME_REGULATION_ENABLED:
         msg = new M_Time_Regulation_Enabled();
         break;
      case Message_M_TIME_CONSTRAINED_ENABLED:
         msg = new M_Time_Constrained_Enabled();
         break;
      case Message_M_DDM_CREATE_REGION:
         msg = new M_Ddm_Create_Region();
         break;
      case Message_M_DDM_MODIFY_REGION:
         msg = new M_Ddm_Modify_Region();
         break;
      case Message_M_DDM_DELETE_REGION:
         msg = new M_Ddm_Delete_Region();
         break;
      case Message_M_DDM_REGISTER_OBJECT:
         msg = new M_Ddm_Register_Object();
         break;
      case Message_M_DDM_ASSOCIATE_REGION:
         msg = new M_Ddm_Associate_Region();
         break;
      case Message_M_DDM_UNASSOCIATE_REGION:
         msg = new M_Ddm_Unassociate_Region();
         break;
      case Message_M_DDM_SUBSCRIBE_ATTRIBUTES:
         msg = new M_Ddm_Subscribe_Attributes();
         break;
      case Message_M_DDM_UNSUBSCRIBE_ATTRIBUTES:
         msg = new M_Ddm_Unsubscribe_Attributes();
         break;
      case Message_M_DDM_SUBSCRIBE_INTERACTION:
         msg = new M_Ddm_Subscribe_Interaction();
         break;
      case Message_M_DDM_UNSUBSCRIBE_INTERACTION:
         msg = new M_Ddm_Unsubscribe_Interaction();
         break;
      case Message_M_DDM_REQUEST_UPDATE:
         msg = new M_Ddm_Request_Update();
         break;
      case Message_M_GET_OBJECT_CLASS_HANDLE:
         msg = new M_Get_Object_Class_Handle();
         break;
      case Message_M_GET_OBJECT_CLASS_NAME:
         msg = new M_Get_Object_Class_Name();
         break;
      case Message_M_GET_ATTRIBUTE_HANDLE:
         msg = new M_Get_Attribute_Handle();
         break;
      case Message_M_GET_ATTRIBUTE_NAME:
         msg = new M_Get_Attribute_Name();
         break;
      case Message_M_GET_INTERACTION_CLASS_HANDLE:
         msg = new M_Get_Interaction_Class_Handle();
         break;
      case Message_M_GET_INTERACTION_CLASS_NAME:
         msg = new M_Get_Interaction_Class_Name();
         break;
      case Message_M_GET_PARAMETER_HANDLE:
         msg = new M_Get_Parameter_Handle();
         break;
      case Message_M_GET_PARAMETER_NAME:
         msg = new M_Get_Parameter_Name();
         break;
      case Message_M_GET_OBJECT_INSTANCE_HANDLE:
         msg = new M_Get_Object_Instance_Handle();
         break;
      case Message_M_GET_OBJECT_INSTANCE_NAME:
         msg = new M_Get_Object_Instance_Name();
         break;
      case Message_M_GET_SPACE_HANDLE:
         msg = new M_Get_Space_Handle();
         break;
      case Message_M_GET_SPACE_NAME:
         msg = new M_Get_Space_Name();
         break;
      case Message_M_GET_DIMENSION_HANDLE:
         msg = new M_Get_Dimension_Handle();
         break;
      case Message_M_GET_DIMENSION_NAME:
         msg = new M_Get_Dimension_Name();
         break;
      case Message_M_GET_ATTRIBUTE_SPACE_HANDLE:
         msg = new M_Get_Attribute_Space_Handle();
         break;
      case Message_M_GET_OBJECT_CLASS:
         msg = new M_Get_Object_Class();
         break;
      case Message_M_GET_INTERACTION_SPACE_HANDLE:
         msg = new M_Get_Interaction_Space_Handle();
         break;
      case Message_M_GET_TRANSPORTATION_HANDLE:
         msg = new M_Get_Transportation_Handle();
         break;
      case Message_M_GET_TRANSPORTATION_NAME:
         msg = new M_Get_Transportation_Name();
         break;
      case Message_M_GET_ORDERING_HANDLE:
         msg = new M_Get_Ordering_Handle();
         break;
      case Message_M_GET_ORDERING_NAME:
         msg = new M_Get_Ordering_Name();
         break;
      case Message_M_ENABLE_CLASS_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Enable_Class_Relevance_Advisory_Switch();
         break;
      case Message_M_DISABLE_CLASS_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Disable_Class_Relevance_Advisory_Switch();
         break;
      case Message_M_ENABLE_ATTRIBUTE_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Enable_Attribute_Relevance_Advisory_Switch();
         break;
      case Message_M_DISABLE_ATTRIBUTE_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Disable_Attribute_Relevance_Advisory_Switch();
         break;
      case Message_M_ENABLE_ATTRIBUTE_SCOPE_ADVISORY_SWITCH:
         msg = new M_Enable_Attribute_Scope_Advisory_Switch();
         break;
      case Message_M_DISABLE_ATTRIBUTE_SCOPE_ADVISORY_SWITCH:
         msg = new M_Disable_Attribute_Scope_Advisory_Switch();
         break;
      case Message_M_ENABLE_INTERACTION_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Enable_Interaction_Relevance_Advisory_Switch();
         break;
      case Message_M_DISABLE_INTERACTION_RELEVANCE_ADVISORY_SWITCH:
         msg = new M_Disable_Interaction_Relevance_Advisory_Switch();
         break;
      case Message_M_TICK_REQUEST:
         msg = new M_Tick_Request();
         break;
      case Message_M_TICK_REQUEST_NEXT:
         msg = new M_Tick_Request_Next();
         break;
      case Message_M_TICK_REQUEST_STOP:
         msg = new M_Tick_Request_Stop();
         break;
      case Message_M_RESERVE_OBJECT_INSTANCE_NAME:
         msg = new M_Reserve_Object_Instance_Name();
         break;
      case Message_M_RESERVE_OBJECT_INSTANCE_NAME_SUCCEEDED:
         msg = new M_Reserve_Object_Instance_Name_Succeeded();
         break;
      case Message_M_RESERVE_OBJECT_INSTANCE_NAME_FAILED:
         msg = new M_Reserve_Object_Instance_Name_Failed();
         break;
      case Message_LAST:
         return -1; /* value LAST may not be used*/
         break;
   } /*  end if switch (type)
   return msg;
} /* end of M_Factory_create */

Message* M_Factory_receive(MStreamType stream) throw (