#ifndef AB_H
#define AB_H
/* ****-**** Global System includes ****-**** */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <assert.h>
#include <string.h>
/* ****-**** Includes coming from native types ****-**** */

#include "MsgBuffer.h"

#define  MAX_CSTRINGSIZE 255

typedef uint32_t MType;

typedef char* MStreamType;
/*  The generated file will be put in 
 *  the AddressBook package
 */
/*  Native types has been defined:
 * - by included headers (see above)
 * - with typedef (see below [if any])
 */

typedef uint32_t MType;

typedef char* MStreamType;
static const uint32_t ab_versionMajor = 1;
static const uint32_t ab_versionMinor = 0;

typedef enum ab_PhoneType {
   ab_pt_MOBILE = 0, 
   ab_pt_HOME, 
   ab_pt_WORK 

} ab_PhoneType_t; /* end of enum PhoneType */

/* ---------------------- BEGIN <nmsg> ------------------------ */


typedef enum ab_MessageType {
   ab_mt_NOT_USED = 0, 
   ab_mt_PERSON, 
   ab_mt_ADDRESSBOOK, 
   ab_mt_LAST 

} ab_MessageType_t; /* end of enum MessageType */

typedef struct  ab_nmsg {
   uint32_t type;
   char* messageName;
} ab_nmsg_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
ab_nmsg_t* ab_nmsg_create(uint32_t nb);
/* Destructor function */
void ab_nmsg_destroy(ab_nmsg_t** cthis);

/* Serialize function */
void ab_nmsg_serialize(ab_nmsg_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void ab_nmsg_deserialize(ab_nmsg_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
uint32_t ab_nmsg_getType(ab_nmsg_t* cthis) ;
void ab_nmsg_setType(ab_nmsg_t* cthis,  uint32_t newType);
char* ab_nmsg_getMessageName(ab_nmsg_t* cthis) ;
void ab_nmsg_setMessageName(ab_nmsg_t* cthis,  char* newMessageName);
/* the show method */
FILE* nmsg_show(FILE* out);
/* ---------------------- END <nmsg> ------------------------ */

/* ---------------------- BEGIN <PhoneNumber> ------------------------ */

typedef struct  ab_PhoneNumber {
   char* number;
   ab_PhoneType_t type;
   uint8_t _hasType;
} ab_PhoneNumber_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
ab_PhoneNumber_t* ab_PhoneNumber_create(uint32_t nb);
/* Destructor function */
void ab_PhoneNumber_destroy(ab_PhoneNumber_t** cthis);

/* Serialize function */
void ab_PhoneNumber_serialize(ab_PhoneNumber_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void ab_PhoneNumber_deserialize(ab_PhoneNumber_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* ab_PhoneNumber_getNumber(ab_PhoneNumber_t* cthis) ;
void ab_PhoneNumber_setNumber(ab_PhoneNumber_t* cthis,  char* newNumber);
ab_PhoneType_t ab_PhoneNumber_getType(ab_PhoneNumber_t* cthis) ;
void ab_PhoneNumber_setType(ab_PhoneNumber_t* cthis,  ab_PhoneType_t newType);
uint8_t hasType(ab_PhoneNumber_t cthis);
/* the show method */
FILE* PhoneNumber_show(FILE* out);
/* ---------------------- END <PhoneNumber> ------------------------ */

/* ---------------------- BEGIN <Person> ------------------------ */

typedef struct  ab_Person {
   nmsg super;
   char* name;
   int32_t id;
   char* email;
   uint8_t _hasEmail;
   ab_PhoneNumber_t* phone;
   uint32_t phoneSize;
} ab_Person_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
ab_Person_t* ab_Person_create(uint32_t nb);
/* Destructor function */
void ab_Person_destroy(ab_Person_t** cthis);

/* Serialize function */
void ab_Person_serialize(ab_Person_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void ab_Person_deserialize(ab_Person_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* ab_Person_getName(ab_Person_t* cthis) ;
void ab_Person_setName(ab_Person_t* cthis,  char* newName);
int32_t ab_Person_getId(ab_Person_t* cthis) ;
void ab_Person_setId(ab_Person_t* cthis,  int32_t newId);
char* ab_Person_getEmail(ab_Person_t* cthis) ;
void ab_Person_setEmail(ab_Person_t* cthis,  char* newEmail);
uint8_t hasEmail(ab_Person_t cthis);
uint32_t ab_Person_getPhoneSize(ab_Person_t* cthis);
void ab_Person_setPhoneSize(ab_Person_t* cthis, uint32_t sz);
ab_PhoneNumber_t ab_Person_getPhone(ab_Person_t* cthis, uint32_t rank);
void ab_Person_setPhone(ab_Person_t* cthis, ab_PhoneNumber_t newPhone, uint32_t rank);
/* the show method */
FILE* Person_show(FILE* out);
/* ---------------------- END <Person> ------------------------ */

/* ---------------------- BEGIN <AddressBook> ------------------------ */

typedef struct  ab_AddressBook {
   nmsg super;
   ab_Person_t* person;
   uint32_t personSize;
} ab_AddressBook_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
ab_AddressBook_t* ab_AddressBook_create(uint32_t nb);
/* Destructor function */
void ab_AddressBook_destroy(ab_AddressBook_t** cthis);

/* Serialize function */
void ab_AddressBook_serialize(ab_AddressBook_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void ab_AddressBook_deserialize(ab_AddressBook_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
uint32_t ab_AddressBook_getPersonSize(ab_AddressBook_t* cthis);
void ab_AddressBook_setPersonSize(ab_AddressBook_t* cthis, uint32_t sz);
ab_Person_t ab_AddressBook_getPerson(ab_AddressBook_t* cthis, uint32_t rank);
void ab_AddressBook_setPerson(ab_AddressBook_t* cthis, ab_Person_t newPerson, uint32_t rank);
/* the show method */
FILE* AddressBook_show(FILE* out);
/* ---------------------- END <AddressBook> ------------------------ */


/*
nmsg* MFactory_create(MType type); 
*/
/*  AB_H
#endif
