// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_SHOW_LIST_H
#define CBC_SHOW_LIST_H

#include <gtkmm.h>
#include <string>
#include <vector>
#include <list>

#include "cbc-show.h"
class CBCShowList: public std::list<CBCShow>
{
    public:

	//! Create an empty track list.
	CBCShowList();

	//! Destructor.
        virtual ~CBCShowList();
        
        bool contains(Glib::ustring id);
        //statics
        static CBCShowList* create_from_html(const char *data, int datalen);
        
    protected:
        CBCShowList(const char *data, int datalen);
    private:
        Glib::ustring get_id(Glib::ustring data);
        Glib::ustring get_title(Glib::ustring data);
        Glib::ustring get_desc(Glib::ustring data);
        Glib::ustring get_span(Glib::ustring data, Glib::ustring span);
        bool get_live(Glib::ustring data);

};

#endif // CBC_SHOW_LIST_H

