// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include "tray-icon.h"
#include "main.h"
#include "cbc-osd-connector.h"

TrayIcon::TrayIcon()
{
  icon = Gtk::StatusIcon::create(Gdk::Pixbuf::create_from_file (Main::get_data_path() + "/data/cbc-osd.png"));
  icon->signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::open_cbc_in_browser));
  Gtk::MenuItem &menu_visit = *Gtk::manage(new Gtk::MenuItem("Open cbc.ca"));
  menu_visit.signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::open_cbc_in_browser));
  menu.append(menu_visit);
  Gtk::MenuItem &menu_check_now = *Gtk::manage(new Gtk::MenuItem("Check Now"));
  menu_check_now.signal_activate().connect(sigc::mem_fun(Main::instance(), &Main::restart_polling));
  menu.append(menu_check_now);
  Gtk::CheckMenuItem &menu_news = *Gtk::manage(new Gtk::CheckMenuItem("News"));
  menu_news.set_active(Main::get_watching_news());
  menu_news.signal_toggled().connect(sigc::mem_fun(Main::instance(), &Main::set_news_toggled));
  menu.append(menu_news);
  Gtk::CheckMenuItem &menu_sports = *Gtk::manage(new Gtk::CheckMenuItem("Sports"));
  menu_sports.set_active(Main::get_watching_sports());
  menu_sports.signal_toggled().connect(sigc::mem_fun(Main::instance(), &Main::set_sports_toggled));
  menu.append(menu_sports);
  Gtk::ImageMenuItem &menu_about = *Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::ABOUT));
  menu.append(menu_about);
  menu_about.signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::on_show_about));
  Gtk::ImageMenuItem &menu_quit = *Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::QUIT));
  menu.append(menu_quit);
  menu_quit.signal_activate().connect(sigc::mem_fun(Main::instance(), &Main::stop_main_loop));
  menu.show_all();
  icon->signal_popup_menu().connect(sigc::mem_fun(*this, &TrayIcon::on_show_popup));
}

TrayIcon::~TrayIcon()
{
}

void TrayIcon::on_show_about()
{
  Gtk::AboutDialog about;
  about.set_copyright("Copyright (C) 2011 Ben Asselstine");
  about.set_version(PACKAGE_VERSION);
  about.set_program_name(Glib::get_prgname());
  about.set_logo(Gdk::Pixbuf::create_from_file (Main::get_data_path() + "/data/cbc-osd.png"));
  about.set_website("http://www.nongnu.org/cbc-osd");
  about.set_comments("The most important feature of this program is freedom.\n"
                     "This tool was not created by, nor is it in any way \n"
                     "endorsed by the Canadian Broadcasting Corporation.");
  about.set_license("This software is licensed under the terms of the \nGNU General Public License Version 3.\nhttp://www.gnu.org/licenses/gpl.html");
  std::vector<Glib::ustring> authors;
  authors.push_back("Ben Asselstine");
  about.set_authors(authors);
  std::vector<Glib::ustring> artists;
  artists.push_back("CBC icon is from http://en.wikipedia.org/wiki/File:CBC_Logo_1992-Present.svg and is listed as being in the public domain.");
  about.set_artists(artists);
  about.run();
  about.hide();
}

void TrayIcon::on_show_popup(guint button, guint32 activate_time) 
{
  if (icon)
    icon->popup_menu_at_position(menu, button, activate_time);
}

void TrayIcon::open_cbc_in_browser()
{
  Glib::ustring cmd = Glib::find_program_in_path("gvfs-open") + " '" + CBC_VIDEO_BASE +"'";
  Glib::spawn_command_line_async(cmd);
}
