//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_SHOW_H 
#define CBC_SHOW_H
#include <gtkmm.h>
#include "event-date-region.h"
class CBCShow
{
    public:

        CBCShow(Glib::ustring id, Glib::ustring title, time_t point, guint duration);

        CBCShow(const CBCShow& t);

        bool is_showing();

        Glib::ustring get_id() const {return d_id;};
        Glib::ustring get_title() const {return d_title;};
	//! Destructor.
        ~CBCShow();

    protected:
    private:
        Glib::ustring d_id;
        Glib::ustring d_title;
        EventDateRegion d_air;

};

#endif // CBC_SHOW_H
