#!/usr/bin/perl -w

# catkin.pl
# Copyright (C) 2002-2004 colin z robertson
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# path to data dir:
my $CATKIN_DIR = '/path/to/catkin/config/dir/';
# path to libraries (if necessary):
my @LIB_DIRS = qw( /path/to/perl/modules );

eval {
	eval('
		use lib @LIB_DIRS;
		use strict;
		use CGI;
		use CGI::Carp qw( fatalsToBrowser );
		use Catkin::Interface;
	');
	if ($@) {
		die "Error in loading modules: $@\n";
	}
	# This is for IIS. You may want to remove it if you use a sane system.
	my $logfile = "$CATKIN_DIR/errlog";
	if (-e $logfile) { unlink $logfile if -s $logfile > 250000; }
	open(STDERR,">>$logfile");
	
	my $cgi = new CGI();
	my $catkin = new Catkin::Interface($CATKIN_DIR);
	
	print $catkin->process_cgi($cgi);
};
if ($@) {
	print "Content-Type: text/plain\n\nError: $@";
	exit;
}
