/* Xmlizable.java -- Defines the XML serialization process for a class.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.xml;

import java.io.Serializable;

import javax.xml.namespace.QName;

/**
 * Specifies that a class can be converted to an XML tree.  The methods
 * specified by this class allow additional information to be specified
 * to the serializer.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Serializer
 */
public interface Xmlizable
  extends Serializable
{

  /**
   * Retrieves the name to use for the XML element that represents
   * this class.  If <code>null</code> is specified, the class name
   * will be used with the first letter set to lowercase.
   *
   * @return the element name, or <code>null</code> if the class name
   *         should be used.
   */
  String getElementName();

  /**
   * Retrieves an array of qualified names which specifies the
   * namespaces to declare when serializing this element as XML.
   * Specifying <code>null</code> or an empty array corresponds to no
   * namespace declarations.
   *
   * @return an array of qualified names for namespace declaration.
   */
  QName[] getDeclaredNamespaces();

}
