/* TypeChecking.java -- A program to evaluate the type of haskell code.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.services;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import java.net.MalformedURLException;
import java.net.URISyntaxException;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

import nongnu.cashews.language.grounding.MessagePart;
import nongnu.cashews.language.grounding.SoapMessage;
import nongnu.cashews.language.grounding.SoapOperation;

import nongnu.cashews.soap.SoapClient;

/**
 * A client implementation to call the type checking web service.
 * 
 * @author Atheesh Sanka (acp04as@shef.ac.uk)
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class TypeChecker
{

  /**
   * A test endpoint for the service within the DCS.
   */
  private static final String TEST_ENDPOINT =
    "http://esk.dcs.shef.ac.uk:8080/typeCheckingService";

  /**
   * A simple test harness to call the type checker.
   *
   * @param args the command-line arguments.
   * @throws IOException if an I/O error occurs.
   * @throws URISyntaxException if one of the operation URIs is invalid.
   * @throws MalformedURLException if the endpoint URL is invalid.
   * @throws InstantiationException if a needed class can't be instantiated.
   * @throws IllegalAccessException if a needed class can't be accessed.
   * @throws ClassNotFoundException if a needed class can't be found.
   */
  public static void main(String[] args) 
    throws URISyntaxException, MalformedURLException, IOException,
	   InstantiationException, IllegalAccessException,
	   ClassNotFoundException
  {
    BufferedReader br = 
      new BufferedReader(new InputStreamReader(System.in));
    String expression;
    
    System.out.print("Please enter the expression: ");
    
    expression = br.readLine();
    
       boolean flag = new TypeChecker().callService(expression);
       
       if( flag == false )
       System.out.println( "Invalid expression" );
   
  }

   
  /**
   * Calls the type checking web service with the supplied
   * expression.  The supplied expression should contain valid Haskell
   * code.
   * 
   * @param expression the expression to supply to the service.
   * @return true if the code typed correctly, false otherwise.
   * @throws IOException if an I/O error occurs.
   * @throws URISyntaxException if one of the operation URIs is invalid.
   * @throws MalformedURLException if the endpoint URL is invalid.
   * @throws InstantiationException if a needed class can't be instantiated.
   * @throws IllegalAccessException if a needed class can't be accessed.
   * @throws ClassNotFoundException if a needed class can't be found.
   */
  public boolean callService( String expression )
    throws URISyntaxException, MalformedURLException, IOException,
	   InstantiationException, IllegalAccessException,
	   ClassNotFoundException
  {
    SoapOperation operation = new SoapOperation(TEST_ENDPOINT);
    SoapMessage input = new SoapMessage(null, "typeCheckRequest");
    MessagePart part1 = new MessagePart("expr");
    part1.setName(null, "expr");
    part1.setType(W3C_XML_SCHEMA_NS_URI, "string", "xsd");
    input.addPart(part1);
    operation.setInputMessage(input);
    SoapClient client = new SoapClient();
    Boolean b = (Boolean) client.call(operation, expression);
    return b;
    /* Axis code
	Service  service = new Service();
	Call call = (Call) service.createCall();
	call.setTargetEndpointAddress( new java.net.URL(TEST_ENDPOINT) );
	call.setOperationName("typeCheckRequest");
	call.addParameter("expr", org.apache.axis.Constants.XSD_STRING,
			  javax.xml.rpc.ParameterMode.IN);
	call.setReturnType( org.apache.axis.Constants.XSD_STRING );
	
	String result = (String) call.invoke( new Object[] { expression } );

	if( result.indexOf( "error" ) == -1 )
	  {
	    System.out.println( "The type of '" + expression + "' is '" 
				+ result + "'" );
	    return true;
	  }
	else
	  return false;
	
      } 
    catch (Exception e) 
      {
	System.err.println(e.toString());
	e.printStackTrace();
	return false;
      }
    */
  }     

}
