/* XMLParser.java -- Parser for RDF in XML form.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.rdf;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

import nongnu.cashews.xml.Parser;

import org.xml.sax.SAXException;

/**
 * This class is simply a wrapper around the existing parser to enable
 * the testing of RDF parsing.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class XMLParser
  extends Parser
{

  /**
   * Constructs a new RDF-based parser, using the specified handler
   * for messages.
   *
   * @param logHandler the handler to use for log messages.
   * @throws SAXException if the parser fails to obtain an
   *         <code>XMLReader</code> instance.
   */
  public XMLParser(Handler handler)
    throws SAXException
  {
    super(handler, new RDFHandler(handler));
  }

  /**
   * Retrieves the RDF handler used by the parser.
   *
   * @return the XML event handler.
   */
  public RDFHandler getRDFHandler()
  {
    return (RDFHandler) getHandler();
  }

  /**
   * A simple test harness to parse the RDF files supplied on the command
   * line.
   * 
   * @param args the command line arguments.
   * @throws SAXException if a <code>XMLReader</code> can't be obtained
   *         or an error occurs during parsing.
   * @throws IOException if an error occurs in the underlying input.
   */
  public static void main(String[] args)
    throws SAXException, IOException
  {
    Handler handler = new ConsoleHandler();
    handler.setLevel(Level.FINE);
    XMLParser parser = new XMLParser(handler);
    for (int a = 0; a < args.length; ++a)
      {
	parser.parse(args[a]);
	System.out.println(parser.getRDFHandler().getGraph());
      }
  }

}
