/* UnknownType.java -- A Type implementation representing an unknown type.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.rdf;

/**
 * <p>
 * An <code>UnknownType</code> instance results from a URI which does not
 * match a known type.  It implements the type by simply storing its URI
 * and providing an identity mapping for <code>getValue()</code>.
 * </p>
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class UnknownType
  implements Type
{

  /**
   * The URI of the unknown type.
   */
  private String uri;

  /**
   * Constructs a new <code>UnknownType</code> using the specified URI
   * of the unknown type.
   *
   * @param uri the URI of the unknown type.
   */
  public UnknownType(String uri)
  {
    this.uri = uri;
  }

  /**
   * Returns a textual representation of the unknown type.
   *
   * @return a textual representation.
   */
  public String toString()
  {
    return getClass().getName() +
      "[uri = " +
      uri +
      "]";
  }

  /**
   * Returns a deep copy of this unknown type.
   *
   * @return a clone of the unknown type.
   */
  public UnknownType clone()
  {
    try
      {
	return (UnknownType) super.clone();
      }
    catch (CloneNotSupportedException e)
      {
	throw new IllegalStateException("Unexpected exception: " + e, e);
      }
  }

  /**
   * Retrieves the actual value of this type instance by applying a lexical to
   * value mapping.  For the unknown type, the mapping is simply an identity
   * function, and the original lexical value is returned.
   * 
   * @param lexical the lexical representation of the literal.
   * @return the supplied lexical.
   */
  public String getValue(String lexical)
  {
    return lexical;
  }

}
