/* Service.java -- Representation of an OWL-S service.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.service;

import java.util.List;

/**
 * A <code>Service</code> organises the various parts of an OWL-S web service
 * description.  A service is made up of profiles, models and groundings,
 * and effectively forms a description of the API the service provider
 * wants to make available to others.  Each service references 0 or more
 * profiles, and an optional model.  If a model is specified, it must
 * be accompanied by one or more groundings.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Service
{

  /**
   * The profiles presented by the service to describe what it does.
   *
   * @serial the service profiles.
   */
  private List<ServiceProfile> profiles;

  /**
   * The model, which describes how the service works.
   *
   * @serial the service model.
   */
  private ServiceModel model;

  /**
   * The groundings, which support the service and make it usable.
   *
   * @serial the service groundings.
   */
  private List<ServiceGrounding> groundings;

}
