/* ValueSpecifier.java -- Representation of a binding with an XML value.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

import nongnu.cashews.rdf.XMLLiteral;

import java.net.URI;

/**
 * A value specifier is a binding where the value is given via the
 * interpretation of an XML literal.  The type of the resulting value
 * is also specified.  The XML literal may contain reference to variables
 * and/or <code>ValueOf</code> constructs.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see ValueForm
 * @see ValueFunction
 * @see ValueOf
 */
public abstract class ValueSpecifier
  extends ValueDescriptor
{

  /**
   * The XML literal which, when interpreted, specifies the value
   * of the bound parameter.
   *
   * @serial the XML literal.
   */
  private XMLLiteral value;

  /**
   * The type of the value resulting from the interpretation of
   * the XML literal.
   *
   * @serial the type of the resulting value.
   */
  private URI type;

}
