/* Process.java -- Representation of an OWL-S process.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

import java.util.ArrayList;
import java.util.List;

import nongnu.cashews.owls.expression.Condition;
import nongnu.cashews.owls.service.ServiceModel;

/**
 * A <code>Process</code> is a generalisation of atomic and composite
 * processes.  It encapsulates the common process information, including
 * the process name, parameters, preconditions, participants and results.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Parameter
 * @see Participant
 * @see Result
 * @see nongnu.cashews.owls.expression.Condition
 */
public abstract class Process
  extends ServiceModel
{

  /**
   * The name of the process.  These need not be unique.
   *
   * @serial the process name.
   * FIXME: We type this as a String, for want of a defined type.
   */
  private String name;

  /**
   * The input parameters of this process.
   *
   * @serial the input parameters.
   */
  private List<Input> inputs;

  /**
   * The output parameters of this process.
   *
   * @serial the output parameters.
   */
  private List<Output> outputs;

  /**
   * The local parameters of this process.
   * 
   * @serial the local parameters. 
   */
  private List<Local> locals;

  /**
   * The results of this process.
   * 
   * @serial the results.
   */
  private List<Result> results;

  /**
   * The participants in the use of the process.
   *
   * @serial the participants.
   */
  private List<Participant> participants;

  /**
   * The preconditions of this process.
   *
   * @serial the preconditions.
   */
  private List<Condition> preconditions;

  /**
   * Default constructor which initialises the internal storage.
   */
  public Process()
  {
    inputs = new ArrayList<Input>();
    outputs = new ArrayList<Output>();
    locals = new ArrayList<Local>();
    results = new ArrayList<Result>();
    participants = new ArrayList<Participant>();
    preconditions = new ArrayList<Condition>();
  }

  /**
   * Add a <code>Participant</code> to the list of participants
   * associated with this process.
   *
   * @param participant the new participant.
   */
  public void addParticipant(Participant participant)
  {
    participants.add(participant);
  }

}
