/* Participant.java -- Representation of a participant in the use of a process.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

/**
 * A <code>Participant</code> takes part in the use of a process.
 * Usually, there are two participants: the client and the server.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Participant
{

  /**
   * The identifier for this participant.
   *
   * @serial the participant's ID.
   */
  private String id;

  /**
   * A representation of the client as a participant in the process.
   */
  public static final Participant CLIENT = new Participant("TheClient");

  /**
   * A representation of the server as a participant in the process.
   */
  public static final Participant SERVER = new Participant("TheServer");

  /**
   * Constructs a <code>Participant</code> with the specified ID.
   *
   * @param id the id for this participant.
   */
  public Participant(String id)
  {
    this.id = id;
  }


}
