/* ValueCollector.java -- Collects data from the result of a function.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.language.process;

import java.net.URI;

import nongnu.cashews.language.expression.Expression;

/**
 * Connects a performance input to the result of some function.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Performance
 * @see Expression
 */
public class ValueCollector
{

  /**
   * The input on the performance.
   *
   * @serial the performance input.
   */
  private URI toInput;

  /**
   * The width of the collector.
   *
   * @serial the collector's width.
   */
  private int width;

  /**
   * The function which provides the input.
   *
   * @serial the function.
   */
  private Expression function;

}

