/* MultiPerform.java -- A composite process which wraps several performances.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.language.process;

import java.util.ArrayList;
import java.util.List;

/**
 * A generic superclass for composite processes which handle an arbitrary
 * length list of <code>Performance</code>s, interleaved with
 * <code>Connection<code>s.  
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Performance
 * @see Connection
 */
public abstract class MultiPerform
  implements CProcess
{

  /**
   * The interleaved list of performances and connections.
   *
   * @serial the interleaved list.
   */
  private List<MultiPerformElement> content;

  /**
   * Construct a new <code>MultiPerform</code> construct.
   */
  public MultiPerform()
  {
    content = new ArrayList<MultiPerformElement>();
  }

  /**
   * Adds a new <code>MultiPerformElement</code> to the content of
   * this <code>MultiPerform</code>.
   *
   * @param element the element to add.
   * @return <code>true</code> if the element was added.
   */
  public boolean add(MultiPerformElement element)
  {
    if (element == null)
      return false;
    content.add(element);
    return true;
  }

  /**
   * Retrieves a shallow clone of the content.
   *
   * @return a shallow clone of the content list.
   */
  public List<MultiPerformElement> getContent()
  {
    return new ArrayList<MultiPerformElement>(content);
  }

  /**
   * Returns a <code>String</code> representation of this
   * <code>MultiPerform</code>.
   *
   * @return a textual representation.
   */
  public String toString()
  {
    return getClass().getName() +
      "[content=" +
      content +
      "]";
  }

}

