/* CompositeChoicePage.java -- The wizard page for choosing the CP.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.eclipse.gui;

import nongnu.cashews.language.process.AnyOrder;
import nongnu.cashews.language.process.ChooseOne;
import nongnu.cashews.language.process.Sequence;
import nongnu.cashews.language.process.Split;
import nongnu.cashews.language.process.SplitJoin;

import org.eclipse.jface.wizard.WizardPage;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

/**
 * The wizard page for selecting a composite process.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class CompositeChoicePage
  extends WizardPage
{

  /**
   * The list of composite process types.
   */
  private List list;

  /**
   * Construct a new <code>CompositeChoicePage</code>.
   */
  public CompositeChoicePage()
  {
    super("Choose a composite process type");
  }

  /**
   * Create the controls for this page.
   *
   * @param parent the parent wizard.
   */
  public void createControl(Composite parent)
  {
    Composite container = new Composite(parent, SWT.NULL);
    RowLayout layout = new RowLayout(SWT.VERTICAL);
    layout.justify = true;
    layout.fill = false;
    container.setLayout(layout);
    Label label = new Label(container, SWT.LEFT);
    label.setText("Choose a composite process type:");
    list = new List(container, SWT.SINGLE);
    list.add("Sequence");
    list.add("AnyOrder");
    list.add("Split");
    list.add("SplitJoin");
    list.add("ChooseOne");
    list.addSelectionListener(new SelectionAdapter()
      {
	public void widgetSelected(SelectionEvent e)
	{
	  CashewsWizard wizard = (CashewsWizard) getWizard();
	  int index = list.getSelectionIndex();
	  switch (index)
	    {
	    case 0:
	      wizard.getProcess().setControlStructure(new Sequence());
	      break;
	    case 1:
	      wizard.getProcess().setControlStructure(new AnyOrder());
	      break;
	    case 2:
	      wizard.getProcess().setControlStructure(new Split());
	      break;
	    case 3:
	      wizard.getProcess().setControlStructure(new SplitJoin());
	      break;
	    case 4:
	      wizard.getProcess().setControlStructure(new ChooseOne());
	      break;
	    }
	}
      });
    setControl(container);
    setPageComplete(true);
  }

}
