/* CashewsWizard.java -- The wizard for creating CASheW-s instances.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.eclipse.gui;

import java.net.URISyntaxException;

import nongnu.cashews.language.process.CompositeProcess;

import org.eclipse.jface.wizard.Wizard;

/**
 * The wizard for creating a composite process.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class CashewsWizard
  extends Wizard
{

  /**
   * The created composite process.
   */
  private CompositeProcess cp;

  /**
   * Constructs a new CASheW-s wizard.
   */
  public CashewsWizard()
  {
    super();
    setNeedsProgressMonitor(true);
    setWindowTitle("CASheW-s");
    try
      {
	cp = new CompositeProcess("CompProc");
      }
    catch (URISyntaxException e)
      {
	throw new InternalError("Couldn't initialise composite process.");
      }
  }

  /**
   * Add the pages needed by the wizard.
   */
  public void addPages()
  {
    addPage(new CompositeChoicePage());
    addPage(new OperationChoicePage());
    //addPage(new ConnectionPage());
  }

  /**
   * Performs the finish operations.
   *
   * @returns <code>true</code> if it is okay to finish.
   */
  public boolean performFinish()
  {
    if (cp.getControlStructure() != null)
      return true;
    else
      return false;
  }

  /**
   * Retrieves the composite process being created.
   *
   * @return the composite process.
   */
  public CompositeProcess getProcess()
  {
    return cp;
  }

  /**
   * Sets the composite process to the one supplied.
   *
   * @param cp the new composite process.
   */
  public void setProcess(CompositeProcess cp)
  {
    this.cp = cp;
  }

}
