/* Cashews.java -- Main interface for the Java side of CASheW-s.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.eclipse.gui;

import java.net.URI;

import nongnu.cashews.language.grounding.SoapOperation;
import static nongnu.cashews.services.Processes.TEST_COMPOSITE_SEQUENCE;
import nongnu.cashews.services.WorkflowService;
import nongnu.cashews.soap.SoapClient;

import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.wizard.WizardDialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/**
 * The main application window.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Cashews
  extends ApplicationWindow
{
  /**
   * Constructs a new CASheW-s application.
   */
  public Cashews()
  {
    super(null);
  }

  /**
   * Create the contents of the window.
   *
   * @param parent the parent composite.
   * @return the created composite.
   */
  public Control createContents(Composite parent)
  {
    Button button = new Button(parent, SWT.PUSH);
    button.setText("Create a composite process");
    button.addSelectionListener(new SelectionAdapter()
      {
	public void widgetSelected(SelectionEvent event)
	{
	  CashewsWizard wizard = new CashewsWizard();
	  new WizardDialog(getShell(), wizard).open();
	  try 
	    {
	      SoapClient client = new SoapClient();
	      SoapOperation operation = WorkflowService.getService();
	      client.call(operation, new URI("testWorkflow3"),
			  TEST_COMPOSITE_SEQUENCE);
	    }
	  catch (Exception e)
	    {
	      e.printStackTrace();
	    }
	}
      });
    return button;
  }

  /**
   * Entry point for the application.
   *
   * @param args the command-line arguments.
   */
  public static void main(String[] args)
  {
    Cashews cw = new Cashews();
    cw.setBlockOnOpen(true);
    cw.open();
    Display.getCurrent().dispose();
  }

}
