/* EllipseNodeCellEditorLocator.java -- Locator for elliptical nodes.
Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.

The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.tools;
/**
 * @author Xianfeng Liu <acp04xfl@shef.ac.uk>
 */
import nongnu.cashews.eclipse.composer.figures.EndPointFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class EndPointNodeCellEditorLocator 
implements CellEditorLocator
{

private EndPointFigure nodeFigure;

public EndPointNodeCellEditorLocator(EndPointFigure nodeFigure)
{
 this.nodeFigure = nodeFigure;
}

// ------------------------------------------------------------------------
// Abstract methods from CellEditorLocator

public void relocate(CellEditor celleditor)
{
  Text text = (Text) celleditor.getControl();
  Point pref = text.computeSize(SWT.DEFAULT, SWT.DEFAULT);
  Rectangle rect = this.nodeFigure.getTextBounds();
  text.setBounds(rect.x - 1, rect.y - 1, pref.x + 1, pref.y + 1);
}
}
