/* DiagramLayoutEditPolicy.java -- Policy for editing the diagram layout.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.policies;

import nongnu.cashews.eclipse.composer.commands.CreateNodeCommand;

import nongnu.cashews.eclipse.composer.commands.MoveNodeCommand;
import nongnu.cashews.eclipse.composer.model.Diagram;
import nongnu.cashews.eclipse.composer.model.Node;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

//XYLayoutEditPolicy is a policy that constrains figures by a location and size
//This extends it with the capability to change the location

public class DiagramLayoutEditPolicy 
  extends XYLayoutEditPolicy
{

  // ------------------------------------------------------------------------
  // Overridden from ConstrainedLayoutEditPolicy

  protected EditPolicy createChildEditPolicy(EditPart child)
  {
    // we need to do this because the default is resizable
    return new NonResizableEditPolicy();
  }

  // ------------------------------------------------------------------------
  // Abstract methods from ConstrainedLayoutEditPolicy

  protected Command createAddCommand(EditPart child, Object constraint)
  {
    return null; // no support for adding
  }

  protected Command createChangeConstraintCommand(EditPart child,
                                                  Object constraint)
  {
    // return a command to move the part to the location given by the constraint
    MoveNodeCommand locationCommand = new MoveNodeCommand();
    locationCommand.setNode((Node) child.getModel());
    locationCommand.setLocation(((Rectangle) constraint).getLocation());
    return locationCommand;
  }

  // ------------------------------------------------------------------------
  // Abstract methods from LayoutEditPolicy

  protected Command getCreateCommand(CreateRequest request)
  {
    CreateNodeCommand command = new CreateNodeCommand();
    command.setDiagram((Diagram) getHost().getModel());
    command.setNode((Node) request.getNewObject());
    Rectangle constraint = (Rectangle) getConstraintFor(request);
    command.setLocation(constraint.getLocation());
    return command;
  }

  protected Command getDeleteDependantCommand(Request request)
  {
    return null; // no support for deleting a dependant
  }
}
