/* NodePart.java -- A node part of the diagram.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import nongnu.cashews.eclipse.composer.model.Node;
import nongnu.cashews.eclipse.composer.policies.NodeDirectEditPolicy;
import nongnu.cashews.eclipse.composer.policies.NodeEditPolicy;
import nongnu.cashews.eclipse.composer.policies.NodeGraphicalNodeEditPolicy;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;

public abstract class NodePart 
  extends AbstractGraphicalEditPart 
  implements PropertyChangeListener, NodeEditPart
{

  protected DirectEditManager manager;

  // ------------------------------------------------------------------------
  // Overridden from AbstractGraphicalEditPart

  // override activate to register with the model for property changes
  public void activate()
  {
    if (isActive())
      {
        return;
      }
    super.activate();
    ((Node) getModel()).addPropertyChangeListener(this);
  }

  // override deactivate to deregister with the model
  public void deactivate()
  {
    if (!isActive())
      {
        return;
      }
    super.deactivate();
    ((Node) getModel()).removePropertyChangeListener(this);
  }

  protected List getModelSourceConnections()
  {
    return ((Node) this.getModel()).getOutgoingConnections();
  }

  protected List getModelTargetConnections()
  {
    return ((Node) this.getModel()).getIncomingConnections();
  }

  // ------------------------------------------------------------------------
  // Overridden from AbstractEditPart

  protected void refreshVisuals()
  {

  }

  public void performRequest(Request request)
  {

  }

  // ------------------------------------------------------------------------
  // Abstract methods from AbstractGraphicalEditPart

  protected IFigure createFigure()
  {
    // return new NodeFigure();
    return new Figure();
  }

  // ------------------------------------------------------------------------
  // Abstract methods from AbstractEditPart

  protected void createEditPolicies()
  {
    installEditPolicy(EditPolicy.COMPONENT_ROLE, new NodeEditPolicy());
    installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
                      new NodeGraphicalNodeEditPolicy());
    installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new NodeDirectEditPolicy());
  }

  // ------------------------------------------------------------------------
  // Abstract methods from PropertyChangeListener

  public void propertyChange(PropertyChangeEvent changeEvent)
  {
    if (changeEvent.getPropertyName().equals(Node.LOCATION))
      {
        refreshVisuals();
      }
    else if (changeEvent.getPropertyName().equals(Node.NAME))
      {
        refreshVisuals();
      }
    else if (changeEvent.getPropertyName().equals(Node.INPUTS))
      {
        refreshTargetConnections();
      }
    else if (changeEvent.getPropertyName().equals(Node.OUTPUTS))
      {
        refreshSourceConnections();
      }
  }

  // ------------------------------------------------------------------------
  // Abstract methods from NodeEditPart

  public ConnectionAnchor getSourceConnectionAnchor(
                                                    ConnectionEditPart connection)
  {
    return new NodeConnectionAnchor(getFigure());
  }

  public ConnectionAnchor getTargetConnectionAnchor(
                                                    ConnectionEditPart connection)
  {
    return new NodeConnectionAnchor(getFigure());
  }

  public ConnectionAnchor getSourceConnectionAnchor(Request request)
  {
    return new NodeConnectionAnchor(getFigure());
  }

  public ConnectionAnchor getTargetConnectionAnchor(Request request)
  {
    return new NodeConnectionAnchor(getFigure());
  }

  // ------------------------------------------------------------------------
  // Inner Classes

  private static class NodeConnectionAnchor 
    extends ChopboxAnchor
  {

    public NodeConnectionAnchor(IFigure figure)
    {
      super(figure);
    }

  }
}
