/* EllipseNode.java -- Representation of an ellipsical node.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/
/**
 * 
 * @author Xianfeng Liu  <acp04xfl@shef.ac.uk>
 * 
 * 
 */
package nongnu.cashews.eclipse.composer.model;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

import nongnu.cashews.eclipse.composer.util.Dialogs;
import nongnu.cashews.language.process.Performance;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PerformanceElement 
  extends Node 
  
  
  implements IPropertySource, XMLizable
{

  // serialization version
  static final long serialVersionUID = 4;
  Performance performance;
  // properties

  // descriptors for property sheet
  static final IPropertyDescriptor[] descriptors;
  static
    {
      descriptors = new IPropertyDescriptor[] { new TextPropertyDescriptor(
                                                                           NAME,
                                                                           "Name") };
    }

  // actual fields

  public PerformanceElement(String name)
  {
    setName(name);
  }
  
  

  public void setLocation(Point p)
  {
    if (location.equals(p))
      {
        return;
      }
    location = p;
    firePropertyChange(LOCATION, null, p);
  }

  public Point getLocation()
  {
    return location;
  }

  public String getName()
  {
    return name;
  }

  public void addInput(ConnectionElement connection)
  {
    inputs.add(connection);
    fireStructureChange(INPUTS, connection);
  }

  public void addOutput(ConnectionElement connection)
  {
    
    outputs.add(connection);
    fireStructureChange(OUTPUTS, connection);
  }

  public List getIncomingConnections()
  {
    return inputs;
  }

  public List getOutgoingConnections()
  {
    return outputs;
  }

  public void removeInput(ConnectionElement connection)
  {
    inputs.remove(connection);
    fireStructureChange(INPUTS, connection);
  }

  public void removeOutput(ConnectionElement connection)
  {
    outputs.remove(connection);
    fireStructureChange(OUTPUTS, connection);
  }

  // ------------------------------------------------------------------------
  // Abstract methods from IPropertySource

  public Object getEditableValue()
  {
    return this;
  }

  public Object getPropertyValue(Object id)
  {
    if (NAME.equals(id))
      {
        return getName();
      }
    else
      {
        return null;
      }
  }

  public boolean isPropertySet(Object id)
  {
    return true;
  }

  public void resetPropertyValue(Object id)
  {
    // do nothing
  }

  public void setPropertyValue(Object id, Object value)
  {
    if (id == NAME)
      {
        setName((String) value);
      }
  }

  /*
   * (non-Javadoc)
   * 
   * @see nongnu.cashews.eclipse.composer.model.XMLizable#toXML()
   */
  public String toXML()
  {
    StringBuffer str = new StringBuffer();
    str.append("<EllipseNode ");
    str.append(" name=");
    str.append("\"");
    str.append(name);
    str.append("\"");
    str.append(" XLocation = ");
    str.append("\"");
    str.append(location.x);
    str.append("\"");

    str.append(" YLocation = ");
    str.append("\"");
    str.append(location.y);
    str.append("\"");
    str.append(">");
    if(outputs != null && outputs.size() > 0)
    {
      Iterator i = outputs.iterator();
      Node tempNode = null;
      ConnectionElement tempConnection = null;
      while (i.hasNext())
      {
          tempConnection = (ConnectionElement) i.next();
          tempNode = (Node) tempConnection.getTarget();
          str.append("<OutgoingEdge Destination=");
          str.append("\"");
          str.append(tempNode.getName());
          str.append("\"");
          str.append("/>");
      }
    }
    str.append("</EllipseNode>");
    return str.toString();
  }
  
  /**
   * Retrieves the performance associated with this
   * node.
   * 
   * @return the performance.
   */
  public Performance getPerformance()
  {
   return performance;   
  }
  
  /**
   * Sets the name of the node, and its corresponding
   * performance.
   * 
   * @param name the new name of the node.
   */
  public void setName(String name)
  {
   try 
   {
     if (performance == null)
       performance = new Performance(name);
     else
       performance.setName(name);
     super.setName(name);
   }
   catch (URISyntaxException e)
   {
     Dialogs.displayErrorDialog("Invalid name: " + e);
   }
  }
   
}
