/* NodeFactory.java -- Factory for creating nodes.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor Eclipse plug-in.

 The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
 and redistribute it under the terms of the GNU General Public License
 version 2 (or, at your option, any later version), and/or the Eclipse
 Public License version 1.0.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.

 The University of Sheffield makes available all content in this plug-in
 ("Content"). Unless otherwise indicated below, the Content is provided to
 you under the terms and conditions of the Eclipse Public License Version
 1.0 ("EPL"). A copy of the EPL is available at
 http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
 "Program" will mean the Content.

 If you did not receive this Content directly from the University of Sheffield,
 the Content is being redistributed by another party ("Redistributor") and
 different terms and conditions may apply to your use of any object code in
 the Content. Check the Redistributor's license that was provided with the
 Content. If no such license exists, contact the Redistributor. Unless
 otherwise indicated below, the terms and conditions of the EPL still apply
 to any source code in the Content.

 */


package nongnu.cashews.eclipse.composer.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import nongnu.cashews.eclipse.composer.commands.DiagramSingleton;
import org.eclipse.gef.requests.SimpleFactory;

public abstract class NodeFactory extends SimpleFactory
{

  int autoId;

  private Node node;
  
  

  /**
   * @param aClass
   */
  public NodeFactory(Class aClass)
  {
    super(aClass);
    // TODO Auto-generated constructor stub
  }

  public Node getNewObject()
  {
    
    do
      {
        node = createNode("Untitled" + autoId);
        ++autoId;
      }
    while (!NodeRegistrar.registerNewNode(
                                          node.getName(),
                                          (Diagram) DiagramSingleton.getInstance().getDiagram()));

    /*ProcessDefine pd = new ProcessDefine(null);
    pd.run();
    
    String name = null;
    name = pd.getName();
    NodeRegistrar.registerNewNode(
      name,
      (Diagram) DiagramSingleton.getInstance().getDiagram());
     node = createNode(name);*/
    return node;
  }

  public Node getNewObject(String name)
  {
    Pattern untitled = Pattern.compile("Untitled([0-9]*)");
    Matcher matcher = untitled.matcher(name);
    if (matcher.matches())
      {
        int serializedId = Integer.parseInt(matcher.group(1));
        autoId = serializedId + 1;
      }

    NodeRegistrar.registerNewNode(
                                  name,
                                  (Diagram) DiagramSingleton.getInstance().getDiagram());
    node = createNode(name);
    return node;
  }

  public abstract Node createNode(String name);

}
