package nongnu.cashews.eclipse.composer.model;
/**
 * @author Xianfeng Liu <acp04xfl@shef.ac.uk>
 */
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class EndPointNode 
  extends Node 
  implements IPropertySource, XMLizable
{

  // serialization version
  static final long serialVersionUID = 4;

  // properties

  // descriptors for property sheet
  static final IPropertyDescriptor[] descriptors;
  static
    {
      descriptors = new IPropertyDescriptor[] { new TextPropertyDescriptor(
                                                                           NAME,
                                                                           "Name") };
    }

  // actual fields

  public EndPointNode(String name)
  {
    setName(name);
  }

  public void setLocation(Point p)
  {
    if (location.equals(p))
      {
        return;
      }
    location = p;
    firePropertyChange(LOCATION, null, p);
  }

  public Point getLocation()
  {
    return location;
  }

  public String getName()
  {
    return name;
  }

  public void addInput(ConnectionElement connection)
  {
    inputs.add(connection);
    fireStructureChange(INPUTS, connection);
  }

  public void addOutput(ConnectionElement connection)
  {
    
    outputs.add(connection);
    fireStructureChange(OUTPUTS, connection);
  }

  public List getIncomingConnections()
  {
    return inputs;
  }

  public List getOutgoingConnections()
  {
    return outputs;
  }

  public void removeInput(ConnectionElement connection)
  {
    inputs.remove(connection);
    fireStructureChange(INPUTS, connection);
  }

  public void removeOutput(ConnectionElement connection)
  {
    outputs.remove(connection);
    fireStructureChange(OUTPUTS, connection);
  }

  // ------------------------------------------------------------------------
  // Abstract methods from IPropertySource

  public Object getEditableValue()
  {
    return this;
  }

  public Object getPropertyValue(Object id)
  {
    if (NAME.equals(id))
      {
        return getName();
      }
    else
      {
        return null;
      }
  }

  public boolean isPropertySet(Object id)
  {
    return true;
  }

  public void resetPropertyValue(Object id)
  {
    // do nothing
  }

  public void setPropertyValue(Object id, Object value)
  {
    if (id == NAME)
      {
        setName((String) value);
      }
  }

  /*
   * (non-Javadoc)
   * 
   * @see nongnu.cashews.eclipse.composer.model.XMLizable#toXML()
   */
  public String toXML()
  {
    StringBuffer str = new StringBuffer();
    str.append("<EndPoint ");
    str.append(" name=");
    str.append("\"");
    str.append(name);
    str.append("\"");
    str.append(" XLocation = ");
    str.append("\"");
    str.append(location.x);
    str.append("\"");

    str.append(" YLocation = ");
    str.append("\"");
    str.append(location.y);
    str.append("\"");
    str.append(">");
    if(outputs != null && outputs.size() > 0)
    {
      Iterator i = outputs.iterator();
      Node tempNode = null;
      ConnectionElement tempConnection = null;
      while (i.hasNext())
      {
          tempConnection = (ConnectionElement) i.next();
          tempNode = (Node) tempConnection.getTarget();
          str.append("<OutgoingEdge Destination=");
          str.append("\"");
          str.append(tempNode.getName());
          str.append("\"");
          str.append("/>");
      }
    }
    str.append("</EndPoint>");
    return str.toString();
  }
}
