/* EllipseNodeFigure.java -- Figure for the elliptical node.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class PerformanceNodeFigure 
  extends Figure
{

  private String name;

  private RoundedRectangle ellipseFigure;

  private Label label;

  public PerformanceNodeFigure()
  {
    this.ellipseFigure = new RoundedRectangle();
    Dimension d = new Dimension(40, 40);
    this.ellipseFigure.setCornerDimensions(d);
    this.label = new Label();
    this.add(ellipseFigure);
    this.add(label);
  }

  public String getText()
  {
    return this.label.getText();
  }

  public Rectangle getTextBounds()
  {
    return this.label.getTextBounds();
  }

  public void setName(String name)
  {
    this.name = name;
    this.label.setText(name);
    this.repaint();
  }

  // ------------------------------------------------------------------------
  // Overridden methods from Figure

  public void setBounds(Rectangle rect)
  {
    super.setBounds(rect);
    this.ellipseFigure.setBounds(rect);
    this.label.setBounds(rect);
  }
}
