/* RenameNodeCommand.java -- Command for renaming nodes.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.commands;

import nongnu.cashews.eclipse.composer.model.Diagram;
import nongnu.cashews.eclipse.composer.model.Node;
import org.eclipse.gef.commands.Command;

public class RenameNodeCommand 
  extends Command
{
  Diagram diagram;
  
  private Node node;

  private String newName;

  private String oldName;

  // setters

  public void setName(String name)
  {
    this.newName = name;
  }

  public void setNode(Node node)
  {
    this.node = node;
  }

  // ------------------------------------------------------------------------
  // Overridden from Command

  public String getLabel()
  {
    return "Rename Node";
  }

  public boolean canExecute(){
   return false;   
  }
  public void execute()
  {/* if (newName.equals("")){
      Dialogs.displayErrorDialog("The name of the node can not be null!");
    return;
  }
    if (!NodeRegistrar.renameNode(oldName, newName, (Diagram)DiagramSingleton.getInstance().getDiagram()))
      {
        Dialogs.displayErrorDialog("The node, " + newName + ", already exists.");
        return;
      }
    oldName = this.node.getName();
    this.node.setName(newName);*/
  }

  public void undo()
  {
    this.node.setName(oldName);
  }

  public void redo()
  {
    this.node.setName(newName);
  }
  public void setDiagram(Diagram d)
  {
   this.diagram = d;
   DiagramSingleton.getInstance().setDiagram(d);
  }
}
