/* DeleteNodeCommand.java -- Command for deleting nodes.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor Eclipse plug-in.

 The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
 and redistribute it under the terms of the GNU General Public License
 version 2 (or, at your option, any later version), and/or the Eclipse
 Public License version 1.0.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.

 The University of Sheffield makes available all content in this plug-in
 ("Content"). Unless otherwise indicated below, the Content is provided to
 you under the terms and conditions of the Eclipse Public License Version
 1.0 ("EPL"). A copy of the EPL is available at
 http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
 "Program" will mean the Content.

 If you did not receive this Content directly from the University of Sheffield,
 the Content is being redistributed by another party ("Redistributor") and
 different terms and conditions may apply to your use of any object code in
 the Content. Check the Redistributor's license that was provided with the
 Content. If no such license exists, contact the Redistributor. Unless
 otherwise indicated below, the terms and conditions of the EPL still apply
 to any source code in the Content.

 */


package nongnu.cashews.eclipse.composer.commands;

import nongnu.cashews.eclipse.composer.model.ConnectionElement;
import nongnu.cashews.eclipse.composer.model.Diagram;
import nongnu.cashews.eclipse.composer.model.Node;
import nongnu.cashews.eclipse.composer.model.NodeRegistrar;
import org.eclipse.gef.commands.Command;

public class DeleteNodeCommand extends Command
{

  private Diagram diagram;

  private Node node;

  private ConnectionElement connection;


  // setters

  public void setDiagram(Diagram diagram)
  {
    this.diagram = diagram;
  }

  public void setNode(Node node)
  {
    this.node = node;
  }

  public void setConnection(ConnectionElement connection)
  {
    this.connection = connection;
  }

  // ------------------------------------------------------------------------
  // Overridden from Command

  public String getLabel()
  {
    return "Delete Node";
  }

  public void execute()
  {
     if(diagram.getNodes() == null)
        return;
    int nodeSize = diagram.getNodes().size();
    for (int i = 0; i < nodeSize; i++)
      {

        Node temp = (Node) diagram.getNodes().get(i);
        if (temp.getOutgoingConnections() != null)
          {

            if (temp.getOutgoingConnections().size() != 0)
              {
                for (int j = 0; j < temp.getOutgoingConnections().size(); j++)
                  {

                    ConnectionElement outgoing = (ConnectionElement) temp.getOutgoingConnections().get(
                                                                                         j);
                    if (node.getName().equals(outgoing.getTarget().getName()))
                      {// temp.removeOutput(cn);
                        if (temp.getOutgoingConnections().remove(outgoing))
                          {
                            outgoing.getSource().removeOutput(outgoing);
                            System.out.println("Outgoing Connection Deleted");
                            j--;
                          }
                        else
                          {
                            System.out.println("Outgoing Connection Delete Failed");
                          }

                      }

                  }
              }
          }
        if (temp.getIncomingConnections() != null)
          {
            if (temp.getIncomingConnections().size() != 0)
              {
                for (int k = 0; k < temp.getIncomingConnections().size(); k++)
                  {

                    ConnectionElement incoming = (ConnectionElement) temp.getIncomingConnections().get(
                                                                                         k);

                    if (node.getName().equals(incoming.getSource().getName()))
                      {
                        if (temp.getIncomingConnections().remove(incoming))
                          {
                            incoming.getTarget().removeInput(incoming);
                            System.out.println("Incoming Connection Deleted");
                            k--;
                          }
                        else
                          {
                            System.out.println("Incoming Delete Failed");
                          }
                      }

                  }
              }

          }
      }
    if(node.getOutgoingConnections() != null)
      node.getOutgoingConnections().clear();
    if(node.getIncomingConnections()!=null)
      node.getIncomingConnections().clear();
    
    diagram.removeNode(node);
    NodeRegistrar.removeNode(node.getName());
    
    //dp.refreshVisuals();
  }

  public void undo()
  {
    diagram.addNode(node);
  }

  public void redo()
  {
    execute();
  }
}
