/* ConnectionCreateCommand.java -- Command for creating connections.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor Eclipse plug-in.

 The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
 and redistribute it under the terms of the GNU General Public License
 version 2 (or, at your option, any later version), and/or the Eclipse
 Public License version 1.0.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.

 The University of Sheffield makes available all content in this plug-in
 ("Content"). Unless otherwise indicated below, the Content is provided to
 you under the terms and conditions of the Eclipse Public License Version
 1.0 ("EPL"). A copy of the EPL is available at
 http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
 "Program" will mean the Content.

 If you did not receive this Content directly from the University of Sheffield,
 the Content is being redistributed by another party ("Redistributor") and
 different terms and conditions may apply to your use of any object code in
 the Content. Check the Redistributor's license that was provided with the
 Content. If no such license exists, contact the Redistributor. Unless
 otherwise indicated below, the terms and conditions of the EPL still apply
 to any source code in the Content.

 */


package nongnu.cashews.eclipse.composer.commands;

import java.util.List;

import nongnu.cashews.eclipse.composer.model.ConnectionElement;
import nongnu.cashews.eclipse.composer.model.Node;
import nongnu.cashews.eclipse.composer.ui.ConnectionWindow;

import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand extends Command
{

  protected ConnectionElement connection;

  protected Node source;

  protected Node target;

  // setters

  public void setSource(Node source)
  {
    this.source = source;
  }

  public void setConnection(ConnectionElement connection)
  {
    this.connection = connection;
  }

  public void setTarget(Node target)
  {
    this.target = target;
  }

  // ------------------------------------------------------------------------
  // Overridden from Command

  public String getLabel()
  {
    return "Create Connection";
  }

  public boolean canExecute()
  {
    if (source.equals(target))
      {
        return false;
      }

    // Check for existence of connection already
    if (source.getOutgoingConnections() != null)
      {
        List connections = this.source.getOutgoingConnections();
        if (connections.size() != 0)
          {
            for (int i = 0; i < connections.size(); i++)
              {
                if (((ConnectionElement) connections.get(i)).getTarget().equals(target))
                  return false;
              }
          }
      }
    return true;
  }

  public void execute()
  {
      this.connection = new ConnectionElement(source, target);
      ConnectionWindow cw = new ConnectionWindow(null, connection);
      cw.open();
  }

  public void undo()
  {
    this.source.removeOutput(this.connection);
    this.target.removeInput(this.connection);
  }

  public void redo()
  {
    this.source.addOutput(this.connection);
    this.target.addInput(this.connection);
  }
}
