/* PairList.java -- A list of heterogenous pairs.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.commons;

import java.util.LinkedList;

/**
 * A list consisting of pairs of values.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see java.util.List
 */
public class PairList<A,B>
  extends LinkedList<Pair<A,B>>
{

  /**
   * Serialization ID.
   */

  /**
   * Constructs an empty <code>PairList</code>.
   */
  public PairList()
  {
    super();
  }

  /**
   * Constructs a <code>PairList</code> using the contents of the supplied
   * pair list.
   *
   * @param l the list whose contents are to be used as the start of the
   *          contents for the new list.
   */
  public PairList(PairList<A, B> l)
  {
    super(l);
  }

  /**
   * Returns true if the list contains the specified value.
   * The value is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return true if the set contains the specified value.
   */
  public boolean contains(A left, B right)
  {
    return super.contains(new Pair<A,B>(left,right));
  }

  /**
   * Adds the specified value to the list.  The value
   * is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return <code>true</code>.
   */
  public boolean add(A left, B right)
  {
    return super.add(new Pair<A,B>(left,right));
  }

  /**
   * Adds the specified value to the list at the supplied index.
   * Anything already at that position is shifted to the right (the
   * index is incremented by one). The value is constructed as the
   * pair of the two supplied values.
   *
   * @param index the index at which to place this pair.
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   */
  public void add(int index, A left, B right)
  {
    super.add(index, new Pair<A,B>(left,right));
  }

  /**
   * Adds the specified value to the front of this list.  Anything
   * already at that position is shifted to the right (the index is
   * incremented by one). The value is constructed as the pair of the
   * two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   */
  public void addFirst(A left, B right)
  {
    super.addFirst(new Pair<A,B>(left,right));
  }

  /**
   * Adds the specified value to the end of this list.  The value is
   * constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   */
  public void addLast(A left, B right)
  {
    super.addLast(new Pair<A,B>(left,right));
  }

  /**
   * Returns the index of the first occurrence of the supplied value.
   * The value is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return the index of the first occurrence.
   */
  public int indexOf(A left, B right)
  {
    return super.indexOf(new Pair<A,B>(left,right));
  }

  /**
   * Returns the index of the last occurrence of the supplied value.
   * The value is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return the index of the last occurrence.
   */
  public int lastIndexOf(A left, B right)
  {
    return super.lastIndexOf(new Pair<A,B>(left,right));
  }

  /**
   * Appends the specified value to the end of the queue.  The value
   * is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return <code>true</code>.
   */
  public boolean offer(A left, B right)
  {
    return super.offer(new Pair<A,B>(left,right));
  }

  /**
   * Removes the specified value from the set.  The value
   * is constructed as the pair of the two supplied values.
   *
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return true if the set contained the value.
   */
  public boolean remove(A left, B right)
  {
    return super.remove(new Pair<A,B>(left,right));
  }

  /**
   * Replaces the value at the specified index with the supplied
   * value.  The value is constructed as the pair of the two
   * supplied values.
   *
   * @param index the index at which to place this pair.
   * @param left the left-hand value of the key.
   * @param right the right-hand value of the key.
   * @return the previous value at the index.
   */
  public Pair<A,B> set(int index, A left, B right)
  {
    return super.set(index, new Pair<A,B>(left,right));
  }

}
