/*******************************************************************************
 * capi20wrapper - Collection of functions and data structures for accessing
 *                 a shared library which implements the interface as described
 *                 in section 'Linux' in part two of CAPI 2.0
 * 
 * Written in 2014 by Swen Lünig.
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright
 * and related and neighboring rights to this software to the public domain
 * worldwide. This software is distributed without any warranty.
 * 
 * You should have received a copy of the CC0 Public Domain Dedication along
 * with this software. If not, see
 * <http://creativecommons.org/publicdomain/zero/1.0/>.
 ******************************************************************************/

#ifndef CAPI20WRAPPER_H
#define CAPI20WRAPPER_H

/******************************************************************************
 * Some Types from Section 3.2 in CAPI 2.0
 *****************************************************************************/

typedef unsigned char      capi20wrapper_Byte_t;
typedef unsigned short int capi20wrapper_Word_t;
typedef unsigned long int  capi20wrapper_DWord_t;

/* Because of the escape code for the length, the type is word not byte!
 */
typedef struct {
  capi20wrapper_Word_t length;
  const capi20wrapper_Byte_t * data;
} capi20wrapper_Struct_t;

/******************************************************************************
 * Sending of Messages
 *****************************************************************************/

extern
unsigned int
capi20wrapper_put_connect_active_resp ( unsigned int ApplID,
					capi20wrapper_Word_t Message_number,
					capi20wrapper_DWord_t PLCI );

extern
unsigned int
capi20wrapper_put_connect_req ( unsigned int ApplID,
				capi20wrapper_Word_t Message_number,
				capi20wrapper_DWord_t Controller,
				capi20wrapper_Word_t CIP_Value,
				const capi20wrapper_Struct_t * Called_party_number,
				const capi20wrapper_Struct_t * Calling_party_number,
				const capi20wrapper_Struct_t * Called_party_subaddress,
				const capi20wrapper_Struct_t * Calling_party_subaddress,
				const capi20wrapper_Struct_t * B_protocol,
				const capi20wrapper_Struct_t * BC,
				const capi20wrapper_Struct_t * LLC,
				const capi20wrapper_Struct_t * HLC,
				const capi20wrapper_Struct_t * Additional_Info );

extern
unsigned int
capi20wrapper_put_connect_resp ( unsigned int ApplID,
				 capi20wrapper_Word_t Message_number,
				 capi20wrapper_DWord_t PLCI,
				 capi20wrapper_Word_t Reject,
				 const capi20wrapper_Struct_t * B_protocol,
				 const capi20wrapper_Struct_t * Connected_number,
				 const capi20wrapper_Struct_t * Connected_subaddress,
				 const capi20wrapper_Struct_t * LLC,
				 const capi20wrapper_Struct_t * Additional_Info );

extern
unsigned int
capi20wrapper_put_disconnect_resp ( unsigned int ApplID,
				    capi20wrapper_Word_t Message_number,
				    capi20wrapper_DWord_t PLCI );

extern
unsigned int
capi20wrapper_put_disconnect_req ( unsigned int ApplID,
				   capi20wrapper_Word_t Message_number,
				   capi20wrapper_DWord_t PLCI,
				   const capi20wrapper_Struct_t * Additional_Info );

extern
unsigned int
capi20wrapper_put_listen_req ( unsigned int ApplID,
			       capi20wrapper_Word_t Message_number,
			       capi20wrapper_DWord_t Controller,
			       capi20wrapper_DWord_t Info_mask,
			       capi20wrapper_DWord_t CIP_Mask,
			       capi20wrapper_DWord_t CIP_Mask_2,
			       const capi20wrapper_Struct_t * Calling_party_number,
			       const capi20wrapper_Struct_t * Calling_party_subaddress );

/******************************************************************************
 * Receiving of Messages
 *****************************************************************************/

typedef struct {
  unsigned int (* get_connect_active_ind) ( unsigned int ApplID,
					    capi20wrapper_Word_t Message_number,
					    capi20wrapper_DWord_t PLCI,
					    const capi20wrapper_Struct_t * Connected_number,
					    const capi20wrapper_Struct_t * Connected_subaddress,
					    const capi20wrapper_Struct_t * LLC );
  
  unsigned int (* get_connect_conf) ( unsigned int ApplID,
				      capi20wrapper_Word_t Message_number,
				      capi20wrapper_DWord_t PLCI,
				      capi20wrapper_Word_t Info );
  
  unsigned int (* get_connect_ind) ( unsigned int ApplID,
				     capi20wrapper_Word_t Message_number,
				     capi20wrapper_DWord_t PLCI,
				     capi20wrapper_Word_t CIP_Value,
				     const capi20wrapper_Struct_t * Called_party_number,
				     const capi20wrapper_Struct_t * Calling_party_number,
				     const capi20wrapper_Struct_t * Called_party_subaddress,
				     const capi20wrapper_Struct_t * Calling_party_subaddress,
				     const capi20wrapper_Struct_t * BC,
				     const capi20wrapper_Struct_t * LLC,
				     const capi20wrapper_Struct_t * HLC,
				     const capi20wrapper_Struct_t * Additional_Info,
				     const capi20wrapper_Struct_t * Second_Calling_party_number );
  
  unsigned int (* get_disconnect_ind) ( unsigned int ApplID,
					capi20wrapper_Word_t Message_number,
					capi20wrapper_DWord_t PLCI,
					capi20wrapper_Word_t Reason );
  
  unsigned int (* get_listen_conf) ( unsigned int ApplID,
				     capi20wrapper_Word_t Message_number,
				     capi20wrapper_DWord_t Controller,
				     capi20wrapper_Word_t Info );
  
  void (* get_unknown_message) ( unsigned int ApplID,
				 capi20wrapper_Word_t Message_number,
				 capi20wrapper_Byte_t Command,
				 capi20wrapper_Byte_t Subcommand );
} capi20wrapper_Callbacks_t;

extern
unsigned int
capi20wrapper_get_message ( unsigned int ApplID,
			    const capi20wrapper_Callbacks_t * callbacks );

/******************************************************************************
 * Some Little Helpers
 *****************************************************************************/

extern
void capi20wrapper_printf_Struct ( const char * name,
				   const capi20wrapper_Struct_t * Struct );

#endif
