#include "extras.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include <fcntl.h>           /* Definition of AT_* constants */
#include <unistd.h>
#include <dirent.h>


#include <sys/types.h>
#include <sys/stat.h>





/** \fn char pds_filesep(void)
 *  \brief Retorna um caracter con el separador de archivo para el sistema.
 *  \return Retorna um caracter con el separador de archivo para el sistema.
 *  En caso de error de dedución, retorna '/' por defecto.
 *  \ingroup PdsFilesFuncGroup
 */
char pds_filesep(void)
{
    char c='/';

    char *string_data=NULL;

    string_data=(char*)getcwd(0,0);

    if(string_data==NULL)
    {
        return c;
    }

    if (strlen(string_data)>=2)
    if ( ((string_data[0]>=65)&&(string_data[0]<=90)) || ((string_data[0]>=97)&&(string_data[0]<=122)) )
    if (string_data[1]==':')
    {   
        c='\\';
    }
    
    free(string_data);
    return c;
}

/** \fn char *pds_get_dirname(const char * file_path)
 *  \brief Obtén el directorio madre desde una ruta de fichero.
 *
 *  Si la ruta de fichero es: /path_to_file/filename.c
 *  La función retorna:       /path_to_file
 *  \param[in] file_path Ruta del fichero a analizar.
 *  \return Retorna una nueva cadena de texto con el directorio madre, o 
 *  NULL en caso de error de reserva de memoria o fihero sin directorio madre.
 *  \ingroup PdsFilesFuncGroup
 */
char *pds_get_dirname(const char * file_path)
{
    char *dir_path=NULL;
    const char *ptr=NULL;
    int dir_path_size;
    int i;

    ptr=strrchr(file_path,pds_filesep());

    if(ptr==NULL)
    {
        dir_path=NULL;
    }
    else
    {
        dir_path_size=(int)(ptr-file_path);
        dir_path=(char*) calloc(dir_path_size+1,sizeof(char));
        if(dir_path!=NULL)
        {
            for(i=0;i<dir_path_size;i++) dir_path[i]=file_path[i];
        }
    }

    return dir_path; 
}

#ifdef __OS_UNIX__

#include <unistd.h>

char* get_absolute_speckle_tool_path(void)
{
    int N=4096;

    char *exepath =(char *) calloc(N+1,sizeof(char));

    int ID=readlink( "/proc/self/exe", exepath,N);
    ID++;

    char *CMD=(char *)calloc(strlen(exepath)+2,sizeof(char));
    sprintf(CMD,"%s%c",pds_get_dirname(exepath),pds_filesep());

    free(exepath);

    return CMD;
}

#endif

#ifdef __OS_WINDOWS__

#include <unistd.h>
#include <windows.h>


#define NNN 4096
char* get_absolute_speckle_tool_path(void)
{
    char exepath[NNN];
    wchar_t buffer[NNN];
    GetModuleFileName(NULL,buffer, NNN) ;
    for(int i = 0; buffer[i]; ++i) {
      wchar_t wc = buffer[i];
      char c = (char)wc;
      exepath[i] = c;
    }

    char *CMD=(char *)calloc(strlen(exepath)+2,sizeof(char));
    sprintf(CMD,"%s%c",pds_get_dirname(exepath),pds_filesep());

    return CMD;
}

#endif
