#include "saveimagesequenceinterface.h"
#include "ui_saveimagesequenceinterface.h"

#include <QFileDialog>
#include <QDir>
#include "extras.h"

SaveImageSequenceInterface::SaveImageSequenceInterface(QWidget *parent) :
    QDialog(parent), ui(new Ui::SaveImageSequenceInterface)
{
    //The default save as path is the current path
    ui->setupUi(this);
    ui->location_lineEdit->setText(QDir::currentPath());

    //set the icon of save as
    char *PROGRAM_DIR=get_absolute_speckle_tool_path();
    setWindowIcon(QIcon( QString(PROGRAM_DIR)+"../share/speckletool/icons/document-save-as.png"));
}

SaveImageSequenceInterface::~SaveImageSequenceInterface()
{
    delete ui;
    ui=NULL;
}

void SaveImageSequenceInterface::on_location_pushButton_clicked()
{
    aux = QFileDialog::getExistingDirectory(this, tr("Select Folder"), QDir::currentPath());
    ui->location_lineEdit->setText(aux);
}

QString SaveImageSequenceInterface::getLocation()
{
    return ui->location_lineEdit->text();
}

int SaveImageSequenceInterface::getNumImage()
{
    return ui->numberImage_spinBox->value();
}
