#ifndef MAINWINDOW_H
#define MAINWINDOW_H



#include <QMainWindow>
#include <QDebug>
#include <opencv/cv.h>
#include <opencv/highgui.h>

#include "auximagem.h"
#include "lasca.h"
#include "mhi.h"
#include "saveimagesequenceinterface.h"
#include "savevideointerface.h"
#include"dialogsobre.h"



namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();


private:
    // Variables:
    Ui::MainWindow *ui;

    bool firstTime;
    bool camOn;
    bool saveMode;
    bool openedVideoMode;
    int mode;
    int timer;
    int timer_SaveImgMode;
    int timer_SaveVideoMode;
    int algorhitm_selected_execute;
    int selected_image_camera;
    int numImages_SaveMode;
    int numImages_SaveVideoMode;
    int count_saveImg;
    int count_saveVideo;
    int selected_camera;
    QString dirName_SaveMode;
    QString fileName;
    double lastT;
    double lastT0;
    QString filename_time;
    FILE *fd_time;

    // * OpenCv objects:
    CvCapture* camera=NULL;
    CvVideoWriter *writer;
    IplImage* imgCam;
    IplImage* imgCamGray;

    // * Class objects:
    AuxImagem* auxImagemObj;
    Lasca* lascaObj;
    Mhi* mhiObj;
    SaveImageSequenceInterface* sisObj;
    SaveVideoInterface* svObj;
    DialogSobre* sobreObj;


    // Methods:
    void start_processing();
    void stop_processing();
    void restart_processing();
    void execute_mhi(IplImage *image);
    void execute_lasca(IplImage *image);
    void execute_regions(IplImage *colorImage, IplImage* grayImage);
    void execute_camera(IplImage *colorImage, IplImage* grayImage);
    void instantiate_mhiObj(int newValue);
    void execute_openFile();
    void execute_saveVideo();
    void execute_saveImageSequence();

protected:
    void timerEvent(QTimerEvent *);

private slots:
    void camera_first();
    void camera_second();
    void openFile();
    void saveVideo();
    void saveImageSequence();
    void sobre();
    void open_documentation();
    void on_color_image_camera_radioButton_clicked();
    void on_gray_imagem_camera_radioButton_clicked();
    void on_normal_image_camera_radioButton_clicked();
    void on_camera_execute_radioButton_clicked();
    void on_fps_spinBox_valueChanged(int );
    void on_automatic_duration_mhi_checkBox_stateChanged(int );
    void on_nFrames_spinBox_valueChanged(int );
    void on_regions_execute_radioButton_clicked();
    void on_mhi_execute_radioButton_clicked();
    void on_lasca_execute_radioButton_clicked();
    void on_processing_checkBox_stateChanged(int );
    void on_histogram_checkBox_stateChanged(int );
    void on_cam_pushButton_clicked();
    void on_lock_lasca_checkBox_stateChanged(int );
//    void on_canny_max_horizontalSlider_valueChanged(int value);
//    void on_canny_min_horizontalSlider_valueChanged(int value);
    void on_threshold_regions_horizontalSlider_valueChanged(int value);
    void on_mask_lasca_spinBox_valueChanged(int );
    void on_threshould_mhi_horizontalSlider_valueChanged(int value);
};

#endif // MAINWINDOW_H
