#include "savevideointerface.h"
#include "ui_savevideointerface.h"

#include <QFileDialog>
#include <QDir>

SaveVideoInterface::SaveVideoInterface(QWidget *parent) : QDialog(parent), ui(new Ui::SaveVideoInterface)
{
    ui->setupUi(this);
    ui->location_lineEdit->setText(QDir::currentPath());
    setWindowIcon(QIcon("icons/document-save.png"));
}

SaveVideoInterface::~SaveVideoInterface()
{
    delete ui;
}

void SaveVideoInterface::on_location_pushButton_clicked()
{
    QString aux = QFileDialog::getExistingDirectory(
            this,
            tr("Select Folder"),
            QDir::currentPath());
    ui->location_lineEdit->setText(aux);
}

QString SaveVideoInterface::getFileName()
{
    QString aux = ui->location_lineEdit->text().append("/");
    aux = aux.append(ui->name_lineEdit->text());
    aux = aux.append(".avi");
    return aux;
}

int SaveVideoInterface::getFPS()
{
    return ui->fps_spinBox->value();
}

int SaveVideoInterface::getTime()
{
    return (ui->min_spinBox->value() *  60 + ui->seg_spinBox->value());
}
