""" insert a targa image in the GUI
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Blender.BGL  import *

class Picture:

	def __init__(self, x, y, Path, Resolution):

		self.type="Picture"
		self.Path = Path
		self.Res  = Resolution
		self.LocX=x
		self.LocY=y
		self.Alpha=0
		self.Zoom=1.0


		f = open(self.Path,'rb')
		ee = f.read(18);
		print ee[13]
		width=ord(ee[13])*self.Res+ord(ee[12])
		height=ord(ee[15])*self.Res+ord(ee[14])
		ee=f.read()
		f.close()
		n=0
		if self.Alpha==1:
			bitmap= Buffer(GL_BYTE, ( height, width, 4))
			for y in range(height-1,0,-1):
				for x in range(0, width):
					bitmap[y][x][2]= ord(ee[n]); n=n+1
					bitmap[y][x][1]= ord(ee[n]); n=n+1
					bitmap[y][x][0]= ord(ee[n]); n=n+1
		if self.Alpha==0:
			bitmap= Buffer(GL_BYTE, ( height, width, 3))
			for y in range(height-1,0,-1):
				for x in range(0, width):
					bitmap[y][x][2]= ord(ee[n]); n=n+1
					bitmap[y][x][1]= ord(ee[n]); n=n+1
					bitmap[y][x][0]= ord(ee[n]); n=n+1

		self.BitmapBuffer=bitmap
		self.PicHeight=height
		self.PicWidth=width

	def drawIt(self):

		glRasterPos2i(self.LocX, self.LocY)
		glPixelZoom(self.Zoom,self.Zoom)
		if self.Alpha==1:
			glDrawPixels(self.PicWidth, self.PicHeight, GL_RGBA, GL_UNSIGNED_BYTE, self.BitmapBuffer)
		if self.Alpha==0:
			glDrawPixels(self.PicWidth, self.PicHeight, GL_RGB, GL_UNSIGNED_BYTE, self.BitmapBuffer)
			glFlush()
