# convert ies photometric files to radiance luminaires descriptions

unit = "m"
lamptype = "default"
maintenance_factor = "0.8"

import os, shutil

print "converting .ies files ..."

try:
   os.mkdir("lum")
except:
   print "the directory \"lum\" already exists"

files = os.listdir(os.getcwd())
files.sort()

for file in files:
   if os.path.splitext(file)[1] == ".ies" or os.path.splitext(file)[1] == ".IES":
      print "converting " + str(file)
      basename = str(os.path.splitext(file)[0])
      iesdir = os.path.join("lum",basename)
      try:
         os.mkdir(iesdir)
      except:
         print "  the directory \"" + str(iesdir) + "\" already exists"
      shutil.copyfile(file, os.path.join(iesdir,file))
      currentdir = os.getcwd()
      os.chdir(iesdir)
      convertcommand = "ies2rad -d"+unit+" -t "+lamptype+" -m "+maintenance_factor+" -o "+basename+" "+file
      os.system(convertcommand)
      makefile = open("Makefile","w")
      makefile.write("LUM="+basename+"\n\n")
      makefile.write("all: rvu\n\n")
      makefile.write("clean:\n")
      makefile.write("\trm -f ${LUM}.oct\n\n")
      makefile.write("${LUM}.oct: ${LUM}.rad ${LUM}.dat room.rad\n")
      makefile.write("\toconv room.rad ${LUM}.rad > ${LUM}.oct\n\n")
      makefile.write("rvu: ${LUM}.oct\n")
      makefile.write("\trvu -vp 0 -6 0 -vd 0 1 0 -vu 0 0 1 -vh 50 -vv 50 -vo 4.6 ${LUM}.oct\n\n")
      makefile.close()
      #viewfile = open("room.vf", "w")
      #viewfile.write("rview -vp 0 -6 0 -vd 0 1 0 -vu 0 0 1 -vh 50 -vv 50 -vo 4.6\n")
      #viewfile.close
      scenefile = open("room.rad", "w")
      scenefile.write("void plastic white\n")
      scenefile.write("0\n0\n5 .5 .5 .5 0 0\n\n")
      scenefile.write("!genbox white box 3 3 3 | xform -t -1.5 -1.5 -1.5\n")
      scenefile.close()
      makecommand = "make"
      os.system(makecommand)
      os.chdir(currentdir)

