""" brad: multiline message window
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from BaseWindowClass import BaseWindowClass
from Blender.Draw import *

class MultilineMessagewin(BaseWindowClass):

	def __init__(self, LocX, LocY, Width, Height, Message, Title, okEvent, Deco):

		BaseWindowClass.__init__(self,LocX,LocY,Width,Height)

		self.type="MultilineMessageWin"
		self.msg = Message
		self.okE=okEvent
		self.title = Title
		self.decoration = Deco

	msgColor = {'R':0, 'G':0, 'B':0} # default RGB = (0,0,0)

	def drawIt(self):
		if self.Visibility == 1:
			cw=8 #character width
			ch=16 #character height
			border = 10
			#find longest message
                        message_width = len(self.msg[0]) * cw
			for j in range(len(self.msg)):
				if len(self.msg[j]) > (message_width/cw):
					message_width = len(self.msg[j]) * cw
			message_height = len(self.msg) * ch + 70
			title_width = len(self.title) * cw

			if message_width > title_width:
					self.Width= message_width + border  #Autoresize with message length
			else:
					self.Width= title_width + border  #Autoresize with title length
			self.Height = message_height

			if self.decoration == 0:
				self.drawBox()
			else:
				self.drawBoxS()

			button_dy=55
			if len(self.msg)>0:
				for i in range(len(self.msg)):
					self.drawText(self.LocX+10,
						self.LocY-40-(i*ch),
						self.msgColor['R'],
						self.msgColor['G'],
						self.msgColor['B'],
						self.msg[i])
					button_dy = button_dy + ch

			Button("OK",
			 	self.okE,
				self.LocX+((self.Width/2)-((self.Width/3)/2)),
				self.LocY-button_dy,
				self.Width/4,
				20)

			if self.isSelected == 1:
				self.drawBoxHF()
			self.drawTitle(self.title)
