"""The Mousewin class handles checking of the mouse position and windows dragging.

Running a script in the Blender text window means
drawing GUI widgets within that area.
The Python window area is "cut" by the OpenGL function
glScissor().

Blender mouse coordinates are different that the one
used within the Python window, and this class converts
absolute Blender mouse coordinates to local Python window
coordinates.

The Python text window coordinates are taken by using
the OpenGL function

glGetFloatv(GL_SCISSOR_BOX,WinSize)

This function puts into the WinSize 4-dimensional buffer:
x, y, width and height of the scissor window.

The relative mouse position is calculated by subtraction:

def CalcXMousePos(self,XVal):
        return( XVal-self.WinSize[0])

def CalcYMousePos(self,YVal):
        return( YVal-self.WinSize[1])
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

global X, Y

from Blender.BGL  import *
from Blender.Draw import *

class Mousewin:

        def __init__(self):
                self.alreadyDeselect=0

        #-------------------------------------------#
        #     CALCULATE MOUSE POSITION              #
        #-------------------------------------------#

        WinSize = Buffer(GL_FLOAT,4);
        glGetFloatv(GL_SCISSOR_BOX,WinSize)
        def CalcXMousePos(self,XVal):
                """
                DESCRIPTION:
                Calculate the mouse X coordinate within the scissor box.

                SYNOPSIS:
                CalcXMousePos(self,XVal)

                PARAMETERS:
                None

                RETURN VALUES:
                Mouse X coordinate
                """
                return( XVal-self.WinSize[0])

        def CalcYMousePos(self,YVal):
                """
                DESCRIPTION:
                Calculate the mouse Y coordinate within the scissor box.

                SYNOPSIS:
                CalcYMousePos(self,YVal)

                PARAMETERS:
                None

                RETURN VALUES:
                Mouse Y coordinate
                """
                return( YVal-self.WinSize[1])


        #-------------------------------------------#
        #    DETECT MOUSE ON WINDOW                 #
        #-------------------------------------------#

        def isOnRectangle(self,X1,Y1,X2,Y2,theX,theY):

                #Assume that the rectangle is drawn from up-left corner to down-right corner
                return (theX >= X1 and theX <= X2) and (theY >= Y2 and theY <= Y1)

        #---------------------------------------------------------#
        # CALCULATE THE RELATIVE MOUSE POSITION RESPECT TO WINDOW #
        # AND MOVE THE WINDOW COORDINATES                         #
        #---------------------------------------------------------#

        def testAndMove(self,list,X,Y):
                result=[]
                for wind in list:
                        grabTest= self.isOnRectangle(wind.LocX,
                                        wind.LocY,
                                        wind.LocX+wind.Width,
                                        wind.LocY-wind.Height,
                                        X,Y)
                        if grabTest:
                                        dX=wind.LocX-X; result.append(dX)
                                        dY=wind.LocY-Y; result.append(dY)
                                        wind.isSelected=1
                                        self.alreadyDeselect=0
                                        return result


        #-------------------------------------------#
        #   DETECT MOUSE ON ITEM WIN AND EXPAND IT  #
        #-------------------------------------------#

        def expandTest(self,list,X,Y):
                for wind in list:
                        grabTest= self.isOnRectangle(wind.LocX,
                                        wind.LocY,
                                        wind.LocX+wind.Width,
                                        wind.LocY-wind.Height,
                                        X,Y)
                        if grabTest and wind.type == "item":
                                        wind.statusTest()

        #-------------------------------------------#
        #   DESELECT ALL WINDOWS                    #
        #-------------------------------------------#

        def deselectAll(self,list):
                if self.alreadyDeselect==0:
                        for wind in list:
                                wind.isSelected=0
                        self.alreadyDeselect==1
                        Draw()
