""" brad: location settings
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path
import string
import math

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *
from brad_lib import *

registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  brad_path  = registered_data['brad_path']

class Locationwin(BaseWindowClass):

    def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, Deco):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

        self.type="LocationWin"

        #self.Height = 110
        self.okE=okEvent
        self.decoration=Deco
        self.title=Title

        self.SelectedLocation = Create(0)

        self.LocationName  = Create("")
        self.LocationLat   = Create(0.0)
        self.LocationLon   = Create(0.0)
        self.LocationMer   = Create(0.0)
        self.LocationNorth = Create(0.0)

        self.updateLocation()

    #-------------------------------------------#
    #    DRAWING THE BUTTONS                    #
    #-------------------------------------------#

    def drawIt(self):

      if self.Visibility==1:
        if self.decoration == 0:
                self.drawBox()
        else:
                self.drawBoxS()

        #self.updateLocation()

        #select location and change location buttons
        rh = 45
        location_list_string = self.formatLocations(loadLocations(os.path.join(brad_path, "brad", "radiance", "loc", "locations.dat")))
        self.SelectedLocation = Menu(msg_Location+" %t|"+location_list_string, 35, self.LocX + 10, self.LocY-rh, int((self.Width-20)/2-4), 20, self.SelectedLocation.val, msg_Location)

        #location settings
        rh = 70
        self.LocationName=String(msg_Location+": ",0,self.LocX + 10, self.LocY-rh,int((self.Width-20)/4-4), 20,self.LocationName.val,256,msg_Location)
        self.LocationLat=Number(msg_Latitude+": ",0,self.LocX + 10 + int((self.Width-20)/4-4), self.LocY-rh,int((self.Width-20)/4-4), 20,self.LocationLat.val,-90.0,90.0,msg_LatitudeHint)
        self.LocationLon=Number(msg_Longitude+": ",0,self.LocX + 10 + 2*int((self.Width-20)/4-4), self.LocY-rh,int((self.Width-20)/4-4), 20,self.LocationLon.val,-180.0,180.0,msg_LongitudeHint)
        self.LocationMer=Number(msg_Meridian+": ",0,self.LocX + 10 + 3*int((self.Width-20)/4-4), self.LocY-rh,int((self.Width-20)/4-4), 20,self.LocationMer.val,-180.0,180.0,msg_MeridianHint)

        #north
        rh = 110
        self.LocationNorth=Slider(msg_North+": ", 0, self.LocX + 10 , self.LocY-rh, int((self.Width-20)/3)+10, 20, self.LocationNorth.val, -180.0, 180.0, 1, msg_North)
        radius = int((self.Width-20)/12)
        self.drawPolygonF(self.LocX + 10 + 2*int((self.Width-20)/3)-6,self.LocY-rh-20,30,radius+3,0,0,0,1)
        self.drawPolygonF(self.LocX + 10 + 2*int((self.Width-20)/3)-6,self.LocY-rh-20,30,radius,10,30,15,.8)
        self.drawPolygonF(self.LocX + 10 + 2*int((self.Width-20)/3)-6,self.LocY-rh-20,30,5,0,0,0,1)
        x1 = self.LocX + 10 + 2*int((self.Width-20)/3)-6
        y1 = self.LocY-rh-20
        x2 = x1 + int(math.sin(math.pi*(self.LocationNorth.val/180))*radius)
        y2 = y1 + int(math.cos(math.pi*(self.LocationNorth.val/180))*radius)
        self.drawLine(x1,y1,
                      x2,y2,
                      0,0,0,
                      2,1)

        #ok button
        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,int(self.Width/3-6),20)

        self.drawTitle(self.title)
        if self.isSelected == 1:
            self.drawBoxHF()
        self.updateLocation()

    def formatLocations(self, loclist):
       i=0
       locmenu = ""
       for loc in loclist:
          locmenu += string.split(loc)[0] + " %x"+ str(i)+"|"
          i+=1
       return locmenu

    def updateLocation(self):
       #event 35
       loclist = loadLocations(os.path.join(brad_path, "brad", "radiance", "loc", "locations.dat"))
       loc = loclist[self.SelectedLocation.val]
       self.LocationName.val = string.split(loc)[0]
       self.LocationLat.val  = float(string.split(loc)[1])
       self.LocationLon.val  = float(string.split(loc)[2])
       self.LocationMer.val  = float(string.split(loc)[3])*15.0

